#!/bin/sh
#
# $Id: RUN_Adempiere.sh,v 1.18 2005/07/21 16:44:54 jjanke Exp $
echo Adempiere Client $ADEMPIERE_HOME

#	Set directly to overwrite
#ADEMPIERE_HOME=/Adempiere
#JAVA_HOME=/usr/lib/java

##	Check Java Home
if [ $JAVA_HOME ]; then
  JAVA=$JAVA_HOME/bin/java
else
  JAVA=java
  echo JAVA_HOME is not set.
  echo   You may not be able to start Adempiere
  echo   Set JAVA_HOME to the directory of your local JDK.
fi

## Check Adempiere Home
if [ $ADEMPIERE_HOME ]; then
  CLASSPATH=$ADEMPIERE_HOME/lib/Adempiere.jar:$ADEMPIERE_HOME/lib/AdempiereCLib.jar:$ADEMPIERE_HOME/lib/CompiereJasperReqs.jar:$CLASSPATH
else
  CLASSPATH=lib/Adempiere.jar:lib/AdempiereCLib.jar:lib/CompiereJasperReqs.jar:$CLASSPATH
  echo ADEMPIERE_HOME is not set
  echo   You may not be able to start Adempiere
  echo   Set ADEMPIERE_HOME to the directory of Adempiere.
fi


# To switch between multiple installs, copy the created Adempiere.properties file
# Select the configuration by setting the PROP variable
PROP=
#PROP=-DPropertyFile=test.properties

#  To use your own Encryption class (implementing org.compiere.util.SecureInterface),
#  you need to set it here (and in the server start script) - example:
#  SECURE=-DADEMPIERE_SECURE=org.compiere.util.Secure
SECURE=

# JMX
ADEMPIERE_JMX="-Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.port=9001"
ADEMPIERE_JMX="$ADEMPIERE_JMX -Dcom.sun.management.jmxremote.authenticate=false  -Dcom.sun.management.jmxremote.ssl=false"
export ADEMPIERE_JMX

# GC_LOG
ADEMPIERE_GC="-XX:+PrintGCDetails -XX:+PrintGCDateStamps -Xloggc:/var/log/adempiere/gc-adempiere.log -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=8 -XX:GCLogFileSize=20M"
export ADEMPIERE_GC

# G1
ADEMPIERE_G1="-XX:+UseG1GC -XX:MaxGCPauseMillis=200 -XX:InitiatingHeapOccupancyPercent=70 -XX:+UseStringDeduplication -XX:StringDeduplicationAgeThreshold=3"

export ADEMPIERE_G1
 
# MetaSpace
ADEMPIERE_META="-XX:MetaspaceSize=200M -XX:MaxMetaspaceSize=2g -XX:MinMetaspaceFreeRatio=20"
export ADEMPIERE_META

$JAVA -Xms2g -Xmx2g $ADEMPIERE_GC $ADEMPIERE_G1 $ADEMPIERE_META -DADEMPIERE_HOME=$ADEMPIERE_HOME $PROP $SECURE -classpath $CLASSPATH org.compiere.Adempiere

