/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.X_MP_OT;
import org.compiere.model.X_MP_OT_Resource;
import org.compiere.model.X_MP_OT_Task;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateOTFromOrder
extends SvrProcess {
    private int p_Order_ID;
    private int cantOT;

    protected void prepare() {
        this.p_Order_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MOrder order = new MOrder(this.getCtx(), this.p_Order_ID, this.get_TrxName());
        MOrderLine[] lines = order.getLines(true, null);
        this.cantOT = 0;
        int i = 0;
        while (i < lines.length) {
            MOrderLine line = lines[i];
            if (line.get_ValueAsInt("MP_JobStandar_ID") > 0) {
                this.createOT(line, order.getDateOrdered(), line.get_ValueAsInt("MP_JobStandar_ID"));
            } else {
                line.setDescription("No Existe Estandar de Trabajo asociado");
                line.save();
            }
            ++i;
        }
        return "Se han generado " + this.cantOT + " \u00d3rdenes de Trabajo";
    }

    public boolean createOT(MOrderLine oLine, Timestamp Datetrx, int ID_SJob) {
        X_MP_OT newOT = new X_MP_OT(Env.getCtx(), 0, null);
        newOT.setDateTrx(Datetrx);
        newOT.setDescription("Generado Automaticamente");
        newOT.set_CustomColumn("C_OrderLine_ID", oLine.get_ID());
        newOT.set_CustomColumn("C_Order_ID", oLine.getC_Order_ID());
        newOT.setDocStatus("DR");
        newOT.setDocAction("CO");
        newOT.setC_DocType_ID(MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"OTP")[0].getC_DocType_ID());
        if (!newOT.save()) {
            return false;
        }
        if (!this.createOTTaskDetail(ID_SJob, newOT, oLine.get_ID())) {
            return false;
        }
        ++this.cantOT;
        oLine.set_CustomColumn("MP_OT_ID", newOT.get_ID());
        oLine.save();
        return true;
    }

    public boolean createOTTaskDetail(int ID_JobS, X_MP_OT OT, int ID_OrderLine) {
        String sql = "select * from MP_JobStandar_Task where MP_JobStandar_ID = ? ";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, ID_JobS);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Task ta = new X_MP_OT_Task(Env.getCtx(), 0, null);
                ta.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                ta.setMP_OT_ID(OT.getMP_OT_ID());
                ta.setDescription(rs.getString("Description"));
                ta.setDuration(rs.getBigDecimal("Duration"));
                ta.setC_UOM_ID(rs.getInt("C_UOM_ID"));
                ta.setStatus("NS");
                ta.saveEx();
                this.createOTResourceDetail(rs.getInt("MP_JobStandar_Task_ID"), ta.getMP_OT_Task_ID(), ID_OrderLine);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return true;
    }

    public boolean createOTResourceDetail(int ID_TaskSJob, int ID_OTTask, int ID_OrderLine) {
        String sql = "select * from MP_JobStandar_Resource where MP_JobStandar_Task_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, ID_TaskSJob);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Resource re = new X_MP_OT_Resource(Env.getCtx(), 0, null);
                re.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                re.setMP_OT_Task_ID(ID_OTTask);
                re.setCostAmt(rs.getBigDecimal("CostAmt"));
                re.setS_Resource_ID(rs.getInt("S_Resource_ID"));
                re.setM_BOM_ID(rs.getInt("M_BOM_ID"));
                re.setResourceQty(rs.getBigDecimal("RESOURCEQTY"));
                re.setResourceType(rs.getString("RESOURCETYPE"));
                re.set_ValueOfColumn("M_Product_ID", (Object)rs.getInt("M_Product_ID"));
                re.saveEx();
                re.set_CustomColumn("C_Order_ID", this.p_Order_ID);
                re.set_CustomColumn("C_OrderLine_ID", ID_OrderLine);
                re.saveEx();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return true;
    }
}

