/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModWindsorValidAvaiQtyOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModWindsorValidAvaiQtyOrder.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MOrderLine.Table_ID) {
            MOrderLine oLine = (MOrderLine)((Object)po);
            MOrder order = oLine.getParent();
            if (order.isSOTrx() && order.getDocStatus().compareTo("CO") != 0 && order.getDocStatus().compareTo("IP") != 0 && order.getC_DocTypeTarget().getDocSubTypeSO().compareTo("SO") == 0 && order.getC_DocTypeTarget_ID() == 1000030 && order.getAD_Client_ID() == 1000000 && oLine.getM_Product_ID() > 0 && oLine.getM_Product().isStocked() && oLine.getM_Product().getProductType().compareTo("I") == 0 && (!oLine.get_ValueAsBoolean("NotPrint") || oLine.getQtyEntered().compareTo(Env.ZERO) != 0)) {
                if (oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
                    int cant;
                    BigDecimal qtyAvarLine;
                    MRequisitionLine rLine = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
                    BigDecimal qtyUsed = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM (QtyOrdered) FROM C_OrderLine col  INNER JOIN C_Order co ON (col.C_Order_ID = co.C_Order_ID)  WHERE co.DocStatus NOT IN ('VO') AND C_OrderLine_ID <> " + oLine.get_ID() + " AND M_RequisitionLine_ID = " + rLine.get_ID()), (Object[])new Object[0]);
                    if (qtyUsed == null) {
                        qtyUsed = Env.ZERO;
                    }
                    if ((qtyAvarLine = rLine.getQty().subtract(qtyUsed)).compareTo(oLine.getQtyOrdered()) < 0) {
                        return "Error: Cantidad Supera Cantidad de Solicitud. <LC: 119>";
                    }
                    if (order.get_ValueAsString("MedioCompra").compareTo("Internet") != 0) {
                        if (rLine.getParent().get_ValueAsInt("C_Bpartner_ID") != order.getC_BPartner_ID()) {
                            return "Error: Solo puede usar reservas del mismo cliente";
                        }
                        if (rLine.getParent().get_ValueAsInt("C_Bpartner_Location_ID") != order.getC_BPartner_Location_ID() && !rLine.getParent().get_ValueAsBoolean("OverWriteRequisition")) {
                            return "Error: Solicitud no es de distribuci\u00c3\u00b3n. <LC: 128>";
                        }
                    }
                    if (order.get_ValueAsString("MedioCompra").compareTo("Internet") == 0 && (cant = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1) FROM M_Requisition  WHERE DocStatus IN ('CO','CL') AND C_BPartner_ID = " + order.getC_BPartner_ID() + " AND M_RequisitionRef_ID=" + rLine.getParent().get_ID()))) <= 0 && rLine.getParent().get_ValueAsInt("C_Bpartner_ID") != order.getC_BPartner_ID()) {
                        return "Error: Solo puede usar reservas del mismo cliente. <LC: 138>";
                    }
                } else {
                    BigDecimal qtyAvai = Env.ZERO;
                    if (order.get_ValueAsInt("OV_Prereserva_ID") > 0) {
                        BigDecimal aux;
                        qtyAvai = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000001) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                        if (qtyAvai == null) {
                            qtyAvai = Env.ZERO;
                        }
                        if ((aux = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000010) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0])) == null) {
                            aux = Env.ZERO;
                        }
                        if ((qtyAvai = qtyAvai.add(aux)).subtract(oLine.getQtyOrdered()).compareTo(Env.ZERO) < 0) {
                            return "ERROR: Stock Insuficiente. <LC: 156>";
                        }
                    } else {
                        BigDecimal aux2;
                        int ID_reqP;
                        if (order.get_ValueAsString("MedioCompra").compareTo("Internet") == 0 && (ID_reqP = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(mrl2.M_Requisition_ID) FROM  M_Requisition mr INNER JOIN M_Requisition mr2 ON (mr.M_RequisitionRef_ID = mr2.M_Requisition_ID) INNER JOIN M_Requisitionline mrl2 ON (mr2.M_Requisition_ID = mrl2.M_Requisition_ID) WHERE mr.DocStatus IN ('CO','CL') AND mr.C_BPartner_ID=" + order.getC_BPartner_ID() + " and mrl2.M_Product_ID = " + oLine.getM_Product_ID() + " and mr.M_Warehouse_ID = " + order.getM_Warehouse_ID() + " AND (mrl2.qty - mrl2.qtyUsed) > 0"))) > 0) {
                            MRequisition req = new MRequisition(po.getCtx(), ID_reqP, po.get_TrxName());
                            BigDecimal qtySol = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(qty - qtyUsed) FROM M_RequisitionLine rl  WHERE rl.IsActive = 'Y' AND rl.M_Requisition_ID = " + ID_reqP + " AND rl.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            return "ERROR: Debe usar solicitud Ecommerce abierta para este cliente. N\u00c2\u00b0: " + req.getDocumentNo() + ", producto " + oLine.getM_Product().getName() + " con cantidad " + qtySol + ". <LC: 193>";
                        }
                        int ID_req = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(mr.M_Requisition_ID) FROM M_RequisitionLine rl  INNER JOIN M_Requisition mr ON (rl.M_Requisition_ID = mr.M_Requisition_ID)  WHERE mr.DocStatus IN ('CO','CL') AND mr.C_BPartner_ID = " + order.getC_BPartner_ID() + " AND mr.C_BPartner_Location_ID = " + order.getC_BPartner_Location_ID() + " AND mr.M_Warehouse_ID = " + order.getM_Warehouse_ID() + " AND rl.M_Product_ID = " + oLine.getM_Product_ID() + " AND qty > qtyUsed"));
                        int ID_reqD = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(mr.M_Requisition_ID) FROM M_RequisitionLine rl  INNER JOIN M_Requisition mr ON (rl.M_Requisition_ID = mr.M_Requisition_ID)  WHERE mr.DocStatus IN ('CO','CL') AND mr.C_BPartner_ID = " + order.getC_BPartner_ID() + " AND mr.M_Warehouse_ID = " + order.getM_Warehouse_ID() + " AND mr.OverWriteRequisition = 'Y' AND mr.C_DocType_ID NOT IN (1000111,1000570)" + " AND rl.M_Product_ID = " + oLine.getM_Product_ID() + " AND qty > qtyUsed"));
                        if (ID_req > 0) {
                            MRequisition req = new MRequisition(po.getCtx(), ID_req, po.get_TrxName());
                            BigDecimal qtySol = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(qty - qtyUsed) FROM M_RequisitionLine rl  WHERE rl.IsActive = 'Y' AND rl.M_Requisition_ID = " + ID_req + " AND rl.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            return "ERROR: Debe usar solicitud abierta para este cliente. N\u00c2\u00b0: " + req.getDocumentNo() + ", producto " + oLine.getM_Product().getName() + "con cantidad " + qtySol + ". <LC: 217>";
                        }
                        if (ID_reqD > 0) {
                            MRequisition req = new MRequisition(po.getCtx(), ID_reqD, po.get_TrxName());
                            BigDecimal qtySol = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(qty - qtyUsed) FROM M_RequisitionLine rl  WHERE rl.IsActive = 'Y' AND rl.M_Requisition_ID = " + ID_reqD + " AND rl.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            return "ERROR: Debe usar solicitud de distribuci\u00c3\u00b3n abierta para este cliente. N\u00c2\u00b0: " + req.getDocumentNo() + ", producto " + oLine.getM_Product().getName() + " con cantidad " + qtySol + ". <LC: 224>";
                        }
                        if (order.getAD_Client_ID() == 1000000) {
                            BigDecimal aux;
                            qtyAvai = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000001) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            if (qtyAvai == null) {
                                qtyAvai = Env.ZERO;
                            }
                            if ((aux = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000010) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0])) == null) {
                                aux = Env.ZERO;
                            }
                            qtyAvai = qtyAvai.add(aux);
                        } else {
                            qtyAvai = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT bomqtyavailableofb(mp.M_Product_ID," + order.getM_Warehouse_ID() + ",0) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                        }
                        if (qtyAvai == null) {
                            qtyAvai = Env.ZERO;
                        }
                        if (order.getM_Warehouse_ID() == 1000025) {
                            aux2 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000025) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            if (aux2 == null) {
                                aux2 = Env.ZERO;
                            }
                            if (aux2.subtract(oLine.getQtyOrdered()).compareTo(Env.ZERO) < 0) {
                                return "ERROR: Stock Insuficiente: " + aux2.intValue() + ". Stock en otras bodegas:" + qtyAvai.intValue() + ". <LC: 270>";
                            }
                            return null;
                        }
                        if (order.getM_Warehouse_ID() == 1000027) {
                            aux2 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000027) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            if (aux2 == null) {
                                aux2 = Env.ZERO;
                            }
                            if (aux2.subtract(oLine.getQtyOrdered()).compareTo(Env.ZERO) < 0) {
                                return "ERROR: Stock Insuficiente: " + aux2.intValue() + ". Stock en otras bodegas:" + qtyAvai.intValue() + ". <LC: 284>";
                            }
                            return null;
                        }
                        if (qtyAvai.subtract(oLine.getQtyOrdered()).compareTo(Env.ZERO) < 0) {
                            return "ERROR: Stock Insuficiente y NO Existen solicitudes abiertas. <LC: 294>";
                        }
                    }
                }
            }
            if (order.isSOTrx() && order.getC_DocTypeTarget().getDocSubTypeSO().compareTo("RM") == 0 && oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
                return "ERROR. Linea de devoluci\u00c3\u00b3n NO debe tener solicitud asociada <LC: 368>";
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 1 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx() && order.getAD_Client_ID() == 1000000 && order.getC_DocTypeTarget_ID() == 1000030 && (order.getDocStatus().compareTo("CO") != 0 && order.getDocStatus().compareTo("IP") != 0 && order.getDocStatus().compareTo("IN") != 0 || order.get_ValueAsBoolean("ReValidar"))) {
            MOrderLine[] oLines = order.getLines(false, null);
            int i = 0;
            while (i < oLines.length) {
                MOrderLine oLine = oLines[i];
                if (oLine.getM_Product_ID() > 0 && oLine.getM_Product().isStocked() && oLine.getM_Product().getProductType().compareTo("I") == 0 && (!oLine.get_ValueAsBoolean("NotPrint") || oLine.getQtyEntered().compareTo(Env.ZERO) != 0) && oLine.get_ValueAsInt("M_RequisitionLine_ID") <= 0) {
                    BigDecimal qtyAvai = Env.ZERO;
                    if (order.get_ValueAsInt("OV_Prereserva_ID") > 0) {
                        BigDecimal aux;
                        qtyAvai = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000001) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                        if (qtyAvai == null) {
                            qtyAvai = Env.ZERO;
                        }
                        if ((aux = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000010) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0])) == null) {
                            aux = Env.ZERO;
                        }
                        if ((qtyAvai = qtyAvai.add(aux)).subtract(oLine.getQtyOrdered()).compareTo(Env.ZERO) < 0) {
                            return "ERROR: Stock Insuficiente Linea: " + oLine.getLine() + ". <LC: 458>";
                        }
                    } else {
                        MRequisition req;
                        int ID_reqP;
                        if (order.get_ValueAsString("MedioCompra").compareTo("Internet") == 0 && (ID_reqP = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(mrl2.M_Requisition_ID) FROM  M_Requisition mr INNER JOIN M_Requisition mr2 ON (mr.M_RequisitionRef_ID = mr2.M_Requisition_ID) INNER JOIN M_Requisitionline mrl2 ON (mr2.M_Requisition_ID = mrl2.M_Requisition_ID) WHERE mr.DocStatus IN ('CO','CL') AND mr.C_BPartner_ID=" + order.getC_BPartner_ID() + " AND mr.M_Warehouse_ID = " + order.getM_Warehouse_ID() + " and mrl2.M_Product_ID = " + oLine.getM_Product_ID() + " AND (mrl2.qty - mrl2.qtyUsed) > 0"))) > 0) {
                            MRequisition req2 = new MRequisition(po.getCtx(), ID_reqP, po.get_TrxName());
                            BigDecimal qtySol = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(qty - qtyUsed) FROM M_RequisitionLine rl  WHERE rl.IsActive = 'Y' AND rl.M_Requisition_ID = " + ID_reqP + " AND rl.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            return "ERROR: Debe usar solicitud Ecommerce abierta para este cliente. N\u00c2\u00b0: " + req2.getDocumentNo() + ", producto " + oLine.getM_Product().getName() + " con cantidad " + qtySol + " Linea OV:" + oLine.getLine() + ". <LC: 494>";
                        }
                        int ID_req = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(mr.M_Requisition_ID) FROM M_RequisitionLine rl  INNER JOIN M_Requisition mr ON (rl.M_Requisition_ID = mr.M_Requisition_ID)  WHERE mr.DocStatus IN ('CO','CL') AND mr.C_BPartner_ID = " + order.getC_BPartner_ID() + " AND mr.M_Warehouse_ID = " + order.getM_Warehouse_ID() + " AND mr.C_BPartner_Location_ID = " + order.getC_BPartner_Location_ID() + " AND mr.M_Warehouse_ID = " + order.getM_Warehouse_ID() + " AND rl.M_Product_ID = " + oLine.getM_Product_ID() + " AND qty > qtyUsed"));
                        int ID_reqD = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(mr.M_Requisition_ID) FROM M_RequisitionLine rl  INNER JOIN M_Requisition mr ON (rl.M_Requisition_ID = mr.M_Requisition_ID)  WHERE mr.DocStatus IN ('CO','CL') AND mr.C_BPartner_ID = " + order.getC_BPartner_ID() + " AND mr.M_Warehouse_ID = " + order.getM_Warehouse_ID() + " AND mr.OverWriteRequisition = 'Y' AND mr.C_DocType_ID NOT IN (1000111,1000570)" + " AND rl.M_Product_ID = " + oLine.getM_Product_ID() + " AND qty > qtyUsed"));
                        if (ID_req > 0) {
                            req = new MRequisition(po.getCtx(), ID_req, po.get_TrxName());
                            BigDecimal qtySol = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(qty - qtyUsed) FROM M_RequisitionLine rl  WHERE rl.IsActive = 'Y' AND rl.M_Requisition_ID = " + ID_req + " AND rl.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            return "ERROR: Debe usar solicitud abierta para este cliente. N\u00c2\u00b0: " + req.getDocumentNo() + ", producto " + oLine.getM_Product().getName() + "con cantidad " + qtySol + ". Liena OV:" + oLine.getLine() + ". <LC: 519>";
                        }
                        if (ID_reqD > 0) {
                            req = new MRequisition(po.getCtx(), ID_reqD, po.get_TrxName());
                            BigDecimal qtySol = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(qty - qtyUsed) FROM M_RequisitionLine rl  WHERE rl.IsActive = 'Y' AND rl.M_Requisition_ID = " + ID_reqD + " AND rl.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            return "ERROR: Debe usar solicitud de distribuci\u00c3\u00b3n abierta para este cliente. N\u00c2\u00b0: " + req.getDocumentNo() + ", producto " + oLine.getM_Product().getName() + " con cantidad " + qtySol;
                        }
                        if (order.getAD_Client_ID() == 1000000) {
                            BigDecimal aux;
                            qtyAvai = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000001) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            if (qtyAvai == null) {
                                qtyAvai = Env.ZERO;
                            }
                            if ((aux = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000010) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0])) == null) {
                                aux = Env.ZERO;
                            }
                            qtyAvai = qtyAvai.add(aux);
                            if (order.getM_Warehouse_ID() == 1000025) {
                                BigDecimal aux2 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000025) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                                if (aux2 == null) {
                                    aux2 = Env.ZERO;
                                }
                                qtyAvai = qtyAvai.add(aux2);
                                return null;
                            }
                        } else {
                            qtyAvai = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT bomqtyavailableofb(mp.M_Product_ID," + order.getM_Warehouse_ID() + ",0) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                            if (order.getC_BPartner_Location_ID() == 1010879 || order.getC_BPartner_Location_ID() == 1011338) {
                                BigDecimal aux2;
                                if (order.getM_Warehouse_ID() == 1000027) {
                                    BigDecimal aux3 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000027) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0]);
                                    if (aux3 == null) {
                                        aux3 = Env.ZERO;
                                    }
                                    qtyAvai = qtyAvai.add(aux3);
                                }
                                if ((aux2 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT qtyavailableofb(mp.M_Product_ID,1000024) FROM M_Product mp WHERE mp.M_Product_ID = " + oLine.getM_Product_ID()), (Object[])new Object[0])) == null) {
                                    aux2 = Env.ZERO;
                                }
                                qtyAvai = qtyAvai.add(aux2);
                            }
                        }
                        if (qtyAvai == null) {
                            qtyAvai = Env.ZERO;
                        }
                        if (qtyAvai.subtract(oLine.getQtyOrdered()).compareTo(Env.ZERO) < 0) {
                            return "ERROR: Stock Insuficiente y NO Existen solicitudes abiertas. Linea OV:" + oLine.getLine() + ". <LC: 578>";
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

