/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBankAccount;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.model.X_DM_Document;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessPaymentRequest
extends SvrProcess {
    private int Record_ID;
    private String P_DocAction;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        X_C_PaymentRequest pr = new X_C_PaymentRequest(Env.getCtx(), this.Record_ID, this.get_TrxName());
        String requestType = pr.getRequestType();
        requestType = Character.toString(requestType.charAt(0));
        if (pr.getLines().length == 0 && !requestType.equals("R")) {
            return "No Lines";
        }
        if (pr.getDocStatus().equals("WC") && pr.getC_BankAccount_ID() <= 0) {
            return "Debe indicar una cuenta bancaria para generar el pago";
        }
        if (pr.getDocStatus().equals("CO") && this.P_DocAction.equals("VO")) {
            MPayment pay = new MPayment(Env.getCtx(), pr.getC_Payment_ID(), this.get_TrxName());
            if (pay.getDocStatus().equals("CO") || pay.getDocStatus().equals("IP")) {
                return "el pago relacionado con esta solicitud se encuentra compleado o procesado, no puede se puede anular";
            }
            pay.deleteEx(true, this.get_TrxName());
            pr.setC_Payment_ID(0);
            pr.setDocStatus("VO");
            pr.save();
            if (requestType.equals("R")) {
                X_C_PaymentRequestLine[] lines = pr.getLines();
                int i = 0;
                while (i < lines.length) {
                    X_C_PaymentRequestLine prLine = lines[i];
                    if (prLine.get_ValueAsInt("DM_Document_ID") > 0) {
                        X_DM_Document doc = new X_DM_Document(this.getCtx(), prLine.get_ValueAsInt("DM_Document_ID"), this.get_TrxName());
                        BigDecimal amtAllo = (BigDecimal)doc.get_Value("AllocatedAmt");
                        amtAllo = amtAllo.subtract(prLine.getAmt());
                        doc.set_CustomColumn("AllocatedAmt", amtAllo);
                        doc.saveEx(this.get_TrxName());
                    }
                    ++i;
                }
            }
            return "Pago generado borrado y solicitud de pago anulada";
        }
        if (pr.getDocStatus().equals("DR")) {
            int prLine;
            if (requestType.equals("P")) {
                String sqlcandet = "SELECT COUNT(*) FROM C_PaymentRequestLine WHERE (gl_journalline_id is null OR isactive = 'N') AND C_Paymentrequest_id = " + pr.get_ID();
                int cantDet = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcandet);
                if (cantDet > 0) {
                    return "Linea de Detalle no V\u00e1lida";
                }
            }
            boolean override = pr.get_ValueAsBoolean("Override");
            if (requestType.equals("I") && !override) {
                X_C_PaymentRequestLine[] lines;
                X_C_PaymentRequestLine[] amtAllo = lines = pr.getLines();
                int doc = lines.length;
                prLine = 0;
                while (prLine < doc) {
                    MInvoice invo;
                    String sqlVal;
                    int cant;
                    X_C_PaymentRequestLine line = amtAllo[prLine];
                    if (line.getC_Invoice_ID() > 0 && (cant = DB.getSQLValue(null, (String)(sqlVal = "SELECT COUNT(*) FROM C_Payment cp WHERE cp.C_BPartner_ID = ? AND (SELECT COUNT(*) FROM C_AllocationLine cal WHERE cal.C_Payment_ID = cp.C_Payment_ID) < 1 AND cp.PayAmt = ? AND cp.IsReceipt = 'N' AND cp.DocStatus NOT IN ('VO')"), (Object[])new Object[]{(invo = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.get_TrxName())).getC_BPartner_ID(), invo.getGrandTotal()})) > 0) {
                        return "Existe un pago sin asignaciones para el mismo socio de negocio con el mismo monto que la factura " + invo.getDocumentNo();
                    }
                    ++prLine;
                }
            }
            pr.setDocStatus("WC");
            pr.setProcessed(true);
            pr.save();
            X_C_PaymentRequestLine[] doc = pr.getLines();
            prLine = doc.length;
            int line = 0;
            while (line < prLine) {
                X_C_PaymentRequestLine line2 = doc[line];
                line2.setProcessed(true);
                line2.save();
                ++line;
            }
            this.commitEx();
            return "Solicitud Enviada";
        }
        if (pr.getDocStatus().equals("WC") && pr.isSignature1() && pr.isSignature2()) {
            if (requestType.equals("I") || requestType.equals("R") || requestType.equals("P") || requestType.equals("M")) {
                if (pr.getC_Payment_ID() > 0) {
                    this.log.log(Level.SEVERE, "Payment Already Generated");
                    return "Pago ya generado";
                }
                int cantNGP = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM C_PaymentRequestLine rl  INNER JOIN DM_Document dm ON (rl.DM_Document_ID = dm.DM_Document_ID) INNER JOIN AD_Org org ON (dm.AD_Org_ID = org.AD_Org_ID)  WHERE  C_PaymentRequest_ID = " + pr.get_ID() + " AND NoGenPayrequest = 'Y'"));
                int cantResTypeN = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM C_PaymentRequestLine rl INNER JOIN DM_Document dm ON (rl.DM_Document_ID = dm.DM_Document_ID)  INNER JOIN TP_Refund re ON (dm.TP_Refund_ID = re.TP_Refund_ID)  WHERE  C_PaymentRequest_ID=" + pr.get_ID() + " AND type = '01'"));
                if (!requestType.equals("R") || cantResTypeN <= 0 || cantNGP <= 0) {
                    String com;
                    MBankAccount bank;
                    if (pr.getTenderType().equals("K") && (pr.getCheckNo() == null || pr.getCheckNo().length() == 0) && (bank = MBankAccount.get((Properties)this.getCtx(), (int)pr.getC_BankAccount_ID())).get_ValueAsInt("CheckSequence") > 0) {
                        pr.setCheckNo(bank.get_ValueAsString("CheckSequence"));
                        bank.set_CustomColumn("CheckSequence", (Object)(bank.get_ValueAsInt("CheckSequence") + 1));
                        bank.save();
                    }
                    MPayment pay = new MPayment(Env.getCtx(), 0, this.get_TrxName());
                    pay.setIsReceipt(false);
                    pay.setAD_Org_ID(pr.getAD_Org_ID());
                    pay.setC_BPartner_ID(pr.getC_BPartner_ID());
                    pay.setC_BankAccount_ID(pr.getC_BankAccount_ID());
                    pay.setDateTrx(pr.getDateTrx());
                    pay.setDateAcct(pr.getDateAcct());
                    pay.setC_Currency_ID(pr.getC_Currency_ID());
                    pay.setTenderType(pr.getTenderType());
                    if (pr.getTenderType().equals("K")) {
                        pay.setCheckNo(pr.getCheckNo());
                    }
                    if (!requestType.equals("I")) {
                        pay.setC_Currency_ID(pr.getC_Currency_ID());
                    }
                    if (pr.getC_Charge_ID() > 0) {
                        pay.setC_Charge_ID(pr.getC_Charge_ID());
                    }
                    pay.setPayAmt(pr.getPayAmt());
                    pay.set_CustomColumn("C_PaymentRequest_ID", pr.getC_PaymentRequest_ID());
                    if (!pay.save()) {
                        this.log.log(Level.SEVERE, "Payment not save");
                        return "Payment not save ";
                    }
                    this.log.config("Payment ID :" + pay.getC_Payment_ID());
                    pr.setDocStatus("CO");
                    pr.setC_Payment_ID(pay.getC_Payment_ID());
                    pr.setProcessed(true);
                    pr.save();
                    this.log.config("pr saved");
                    pr.setDocStatus("CO");
                    if (requestType.equals("I") && pr.getLines().length > 0) {
                        X_C_PaymentRequestLine[] lines;
                        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, pr.getDateTrx(), pr.getC_Currency_ID(), "Payment Request", this.get_TrxName());
                        alloc.setAD_Org_ID(pr.getAD_Org_ID());
                        if (!alloc.save()) {
                            this.log.log(Level.SEVERE, "Allocation not created");
                            return "Allocation not created";
                        }
                        X_C_PaymentRequestLine[] cant = lines = pr.getLines();
                        int sqlVal = lines.length;
                        int invo = 0;
                        while (invo < sqlVal) {
                            X_C_PaymentRequestLine line = cant[invo];
                            if (line.getC_Invoice_ID() > 0) {
                                MAllocationLine aLine = new MAllocationLine(alloc, line.getAmt().negate(), Env.ZERO, Env.ZERO, Env.ZERO);
                                aLine.setC_Invoice_ID(line.getC_Invoice_ID());
                                aLine.setC_Payment_ID(pay.getC_Payment_ID());
                                if (!aLine.save()) {
                                    this.log.log(Level.SEVERE, "Allocation Line not written ");
                                }
                            }
                            ++invo;
                        }
                    }
                    if ((com = pr.get_ValueAsString("PayComplete")).equals("Y") || com.equals(true) || com.equalsIgnoreCase("true")) {
                        pay.setDocStatus(pay.completeIt());
                        String IsCon = pr.get_ValueAsString("IsReconciled");
                        if (IsCon.equals("Y") || IsCon.equals(true) || IsCon.equalsIgnoreCase("true")) {
                            pay.setIsReconciled(true);
                        }
                        pay.save();
                    }
                    if (requestType.equals("P")) {
                        pay.setIsAllocated(true);
                        pay.save();
                    }
                    this.commitEx();
                    return "Pago Generado :" + pay.getDocumentNo();
                }
            } else {
                X_C_PaymentRequestLine[] lines = pr.getLines();
                int count = 0;
                X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n2];
                    MJournalLine gline = new MJournalLine(this.getCtx(), line.getGL_JournalLine_ID(), this.get_TrxName());
                    MPayment pay = new MPayment(Env.getCtx(), 0, this.get_TrxName());
                    pay.setIsReceipt(false);
                    pay.setAD_Org_ID(pr.getAD_Org_ID());
                    pay.setC_BPartner_ID(gline.get_ValueAsInt("C_BPartner_ID"));
                    pay.setC_BankAccount_ID(pr.getC_BankAccount_ID());
                    pay.setDateTrx(pr.getDateTrx());
                    pay.setDateAcct(pr.getDateAcct());
                    pay.setC_Currency_ID(pr.getC_Currency_ID());
                    pay.setTenderType(pr.getTenderType());
                    pay.setDescription(gline.getDescription());
                    if (pr.getTenderType().equals("K")) {
                        pay.setCheckNo(pr.getCheckNo());
                    }
                    if (!requestType.equals("I")) {
                        pay.setC_Currency_ID(pr.getC_Currency_ID());
                    }
                    if (pr.getC_Charge_ID() > 0) {
                        pay.setC_Charge_ID(pr.getC_Charge_ID());
                    }
                    pay.setPayAmt(line.getAmt());
                    pay.set_CustomColumn("C_PaymentRequest_ID", pr.getC_PaymentRequest_ID());
                    pay.save();
                    ++count;
                    line.set_ValueOfColumn("C_Payment_ID", (Object)pay.getC_Payment_ID());
                    line.save();
                    String com = pr.get_ValueAsString("PayComplete");
                    if (com.equals("Y") || com.equals(true) || com.equalsIgnoreCase("true")) {
                        pay.setDocStatus(pay.completeIt());
                        String IsCon = pr.get_ValueAsString("IsReconciled");
                        if (IsCon.equals("Y") || IsCon.equals(true) || IsCon.equalsIgnoreCase("true")) {
                            pay.setIsReconciled(true);
                        }
                        pay.save();
                    }
                    ++n2;
                }
                pr.setDocStatus("CO");
                pr.setProcessed(true);
                pr.save();
                return "Pagos Generados :" + count;
            }
        }
        if (!(!pr.getDocStatus().equals("WC") || pr.isSignature1() && pr.isSignature2())) {
            return "La solicitud necesita ser aprobada para generar el pago";
        }
        return "Ninguna Accion Realizada";
    }
}

