/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MPeriod;
import org.compiere.model.X_TP_CommissionBP;
import org.compiere.model.X_TP_CommissionTSM;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ProcessCommission
extends SvrProcess {
    private int p_TP_Commission_ID = 0;
    private String p_DocAction;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DocAction")) {
                this.p_DocAction = (String)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_TP_Commission_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_TP_Commission_ID > 0) {
            X_TP_CommissionTSM com = new X_TP_CommissionTSM(this.getCtx(), this.p_TP_Commission_ID, this.get_TrxName());
            if (this.p_DocAction == null) {
                this.p_DocAction = "CO";
            }
            if (com.getDocStatus().compareToIgnoreCase("DR") == 0 && this.p_DocAction.compareTo("CO") == 0) {
                MPeriod period = new MPeriod(this.getCtx(), com.getC_Period_ID(), this.get_TrxName());
                String sql = "SELECT mm.ad_org_id, mm.C_BPartner_ID,mm.C_ProjectOFB_ID,MAX(co.rut) as rut,  MAX(co.CommissionType) as CommissionType,MAX(co.Commission) as Commission, count(mm.M_Movement_ID) as qty  FROM rvofb_commission co INNER JOIN M_Movement mm ON (co.C_BPartner_ID = mm.C_BPartner_ID)  INNER JOIN AD_Org org ON (mm.AD_Org_ID = org.AD_Org_ID) WHERE org.IsNoCommission <> 'Y' AND MovementDate Between ? AND ?  GROUP BY mm.C_BPartner_ID, mm.C_ProjectOFB_ID, mm.AD_Org_ID  ORDER BY mm.ad_org_id, mm.C_ProjectOFB_ID,mm.C_BPartner_ID";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setTimestamp(1, period.getStartDate());
                    pstmt.setTimestamp(2, period.getEndDate());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_TP_CommissionBP comBP = new X_TP_CommissionBP(this.getCtx(), 0, this.get_TrxName());
                        comBP.setTP_CommissionTSM_ID(com.get_ID());
                        comBP.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                        comBP.setC_BPartner_ID(rs.getInt("C_BPartner_ID"));
                        comBP.setRut(rs.getString("Rut"));
                        comBP.setCommissionType(rs.getString("CommissionType"));
                        comBP.setCommission(rs.getBigDecimal("Commission"));
                        comBP.setC_ProjectOFB_ID(rs.getInt("C_ProjectOFB_ID"));
                        comBP.setQty(rs.getBigDecimal("qty"));
                        comBP.saveEx();
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Exception)e, sql);
                }
                com.setDocStatus("IP");
            } else if (com.getDocStatus().compareToIgnoreCase("IP") == 0 && this.p_DocAction.compareTo("CO") == 0) {
                com.setDocStatus("CO");
                com.setProcessed(true);
            } else if (com.getDocStatus().compareToIgnoreCase("DR") == 0 && this.p_DocAction.compareTo("VO") == 0) {
                com.setDocStatus("VO");
                com.setProcessed(true);
            } else if (com.getDocStatus().compareToIgnoreCase("IP") == 0 && this.p_DocAction.compareTo("VO") == 0) {
                com.setDocStatus("VO");
                com.setProcessed(true);
            } else if (com.getDocStatus().compareToIgnoreCase("CO") == 0 && this.p_DocAction.compareTo("VO") == 0) {
                com.setDocStatus("VO");
                com.setProcessed(true);
            }
            com.saveEx();
        }
        return "Procesado ";
    }
}

