/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelTSMUpdateCashBalance
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelTSMUpdateCashBalance.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Cash", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MCash.Table_ID) {
            MCash cash = (MCash)((Object)po);
            BigDecimal begbalance = Env.ZERO;
            String sql = "SELECT coalesce(Endingbalance,0) as endingbalance FROM C_Cash where C_Cash_ID in  (SELECT max(C_Cash_ID) from C_Cash where C_Cashbook_ID = " + cash.getC_CashBook_ID() + " " + " and docstatus='CO' and c_Cash_id != ?)";
            log.config("sql " + sql);
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
                pstmt.setInt(1, cash.get_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    begbalance = rs.getBigDecimal("Endingbalance");
                }
                rs.close();
                log.config("begbalance " + begbalance);
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, (Throwable)e);
            }
            if (begbalance.compareTo(Env.ZERO) == 0) {
                cash.setBeginningBalance(Env.ZERO);
            } else {
                cash.setBeginningBalance(begbalance);
            }
            cash.setEndingBalance(begbalance.add(cash.getStatementDifference()));
            cash.save();
            log.config("begbalance" + begbalance);
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

