/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MAsset;
import org.compiere.model.MBPartner;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelTSMCriticalDate
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelTSMCriticalDate.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner", (ModelValidator)this);
        engine.addModelChange("A_Asset", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MAsset asset;
        MBPartner bPart;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4) && po.get_Table_ID() == MBPartner.Table_ID && (bPart = (MBPartner)((Object)po)).get_ValueAsBoolean("IsUnLinked")) {
            DB.executeUpdate((String)("UPDATE C_CriticalDate SET Status = 'BA' WHERE C_BPartner_ID=" + bPart.get_ID()), (String)po.get_TrxName());
        }
        if (!(type != 5 && type != 4 || po.get_Table_ID() != MAsset.Table_ID || (asset = (MAsset)((Object)po)).isActive())) {
            DB.executeUpdate((String)("UPDATE C_CriticalDate SET Status = 'BA' WHERE A_Asset_ID=" + asset.get_ID()), (String)po.get_TrxName());
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MCash.Table_ID) {
            MCash cash = (MCash)((Object)po);
            BigDecimal begbalance = Env.ZERO;
            String sql = "SELECT coalesce(Endingbalance,0) as endingbalance FROM C_Cash where C_Cash_ID in  (SELECT max(C_Cash_ID) from C_Cash where C_Cashbook_ID = " + cash.getC_CashBook_ID() + " " + " and docstatus='CO' and c_Cash_id != ?)";
            log.config("sql " + sql);
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
                pstmt.setInt(1, cash.get_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    begbalance = rs.getBigDecimal("Endingbalance");
                }
                rs.close();
                log.config("begbalance " + begbalance);
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, (Throwable)e);
            }
            if (begbalance.compareTo(Env.ZERO) == 0) {
                cash.setBeginningBalance(Env.ZERO);
            } else {
                cash.setBeginningBalance(begbalance);
            }
            cash.setEndingBalance(begbalance.add(cash.getStatementDifference()));
            cash.save();
            log.config("begbalance" + begbalance);
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

