/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_MP_MaintainDetail;
import org.compiere.model.X_MP_OT;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMUpMaintainDetFromOT
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMUpMaintainDetFromOT.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("MP_OT", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        X_MP_OT ot;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_MP_OT.Table_ID && po.is_ValueChanged("DocStatus") && (ot = (X_MP_OT)po).getDocStatus().compareTo("CO") == 0) {
            String mysql = "select distinct MP_MAINTAINDetail_ID from MP_OT_TASK where MP_OT_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)mysql, (String)po.get_TrxName());
                pstmt.setInt(1, ot.get_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_MP_MaintainDetail mp = new X_MP_MaintainDetail(Env.getCtx(), rs.getInt(1), po.get_TrxName());
                    BigDecimal actualKm = null;
                    if (!mp.isProgrammingType().equals("C")) {
                        actualKm = (BigDecimal)ot.get_Value("tsm_km");
                        if (actualKm != null && actualKm.compareTo(Env.ZERO) > 0) {
                            mp.setnextmp(mp.getInterval().add(actualKm).setScale(2, 6));
                            mp.setlastmp(actualKm);
                        } else {
                            mp.setnextmp(mp.getInterval().add(mp.getlastread()).setScale(2, 6));
                        }
                    }
                    mp.save();
                    if (actualKm == null || actualKm.compareTo(Env.ZERO) <= 0) continue;
                    String sql = "SELECT MP_MaintainDetail_ID FROM MP_MaintainDetail md  WHERE md.MP_Maintain_ID IN (SELECT MP_MaintainRef_ID FROM MP_MaintainParent WHERE MP_Maintain_ID = ?)  AND md.A_Asset_ID = ? ";
                    CPreparedStatement pstmt2 = null;
                    try {
                        pstmt2 = DB.prepareStatement((String)sql, (String)po.get_TrxName());
                        pstmt2.setInt(1, mp.getMP_Maintain_ID());
                        pstmt2.setInt(2, mp.getA_Asset_ID());
                        ResultSet rs2 = pstmt2.executeQuery();
                        while (rs2.next()) {
                            X_MP_MaintainDetail mp2 = new X_MP_MaintainDetail(Env.getCtx(), rs2.getInt(1), po.get_TrxName());
                            if (!mp2.isProgrammingType().equals("C") && actualKm != null && actualKm.compareTo(Env.ZERO) > 0) {
                                mp2.setlastmp(actualKm);
                                mp2.setnextmp(mp2.getInterval().add(actualKm).setScale(2, 6));
                            }
                            mp2.save();
                        }
                        rs2.close();
                        pstmt2.close();
                        pstmt2 = null;
                        rs2 = null;
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, mysql, (Throwable)e);
                    }
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, mysql, (Throwable)e);
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

