/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import org.compiere.model.MAsset;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_MP_AssetMeter;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModTSMUpAssetOrgWHRC
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMUpAssetOrgWHRC.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID) {
            MInOut receipt = (MInOut)((Object)po);
            MInOutLine[] rlines = receipt.getLines(false);
            int i = 0;
            while (i < rlines.length) {
                MInOutLine rline = rlines[i];
                if (rline.get_ValueAsInt("A_Asset_ID") > 0) {
                    MAsset asset = new MAsset(po.getCtx(), rline.get_ValueAsInt("A_Asset_ID"), po.get_TrxName());
                    asset.setAD_Org_ID(rline.getAD_Org_ID());
                    asset.set_CustomColumn("M_Warehouse_ID", receipt.getM_Warehouse_ID());
                    asset.save();
                    if (rline.getC_Charge().getC_ChargeType().getValue().compareToIgnoreCase("TCRC") == 0) {
                        int ID_Meter = DB.getSQLValue((String)po.get_TrxName(), (String)" SELECT MAX(MP_Meter_ID) FROM MP_Meter WHERE upper(name) like 'KM'");
                        int ID_AssetMeter = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(MP_AssetMeter_ID) FROM MP_AssetMeter WHERE IsActive = 'Y' AND MP_Meter_ID = " + ID_Meter + " AND A_Asset_ID = " + asset.get_ID()));
                        int ID_AssetMeterLog = DB.getSQLValue((String)po.get_TrxName(), (String)(" SELECT MAX(MP_AssetMeter_Log_ID) FROM MP_AssetMeter_Log WHERE IsActive = 'Y' AND MP_AssetMeter_ID = " + ID_AssetMeter));
                        if (ID_Meter > 0 && ID_AssetMeter > 0) {
                            X_MP_AssetMeter aAssetMeter = new X_MP_AssetMeter(po.getCtx(), ID_AssetMeter, po.get_TrxName());
                            String nrecauchaje = aAssetMeter.get_ValueAsString("NRecauchaje");
                            int recacuchaje = 1;
                            if (nrecauchaje == null || nrecauchaje == "") {
                                nrecauchaje = "0";
                            }
                            if (nrecauchaje != null && ModTSMUpAssetOrgWHRC.isNumeric(nrecauchaje)) {
                                recacuchaje += Integer.parseInt(nrecauchaje);
                            }
                            aAssetMeter.set_CustomColumn("NRecauchaje", Integer.toString(recacuchaje));
                            aAssetMeter.save();
                            if (ID_AssetMeterLog > 0) {
                                DB.executeUpdate((String)("UPDATE MP_AssetMeter_Log SET NRecauchaje = '" + recacuchaje + "' " + " WHERE MP_AssetMeter_Log_ID = " + ID_AssetMeterLog), (String)po.get_TrxName());
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    public static boolean isNumeric(String str) {
        return str.matches("[+-]?\\d*(\\.\\d+)?") && !str.equals("");
    }
}

