/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAsset;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.ofb.model.OFBForward;
import org.ofb.utils.DateUtils;

public class ModTSMSAMOA
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMSAMOA.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_Inventory", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInventory.Table_ID) {
            MInventory inv = (MInventory)po;
            int flag = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT SUM(QtyInternalUse) FROM M_InventoryLine  WHERE IsActive = 'Y' AND M_Inventory_ID = " + inv.get_ID()));
            if (flag > 0 && inv.getAD_Org_ID() == 1000058 && (inv.getM_Warehouse_ID() == 1000013 || inv.getM_Warehouse_ID() == 1000001)) {
                try {
                    int cant = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1)  FROM M_InventoryLine il INNER JOIN M_Product mp ON (il.M_Product_ID = mp.M_Product_ID)  WHERE il.IsActive = 'Y' AND mp.IsSamoa = 'Y' AND M_Inventory_ID = " + inv.get_ID()));
                    if (cant > 0) {
                        MInventoryLine[] lines;
                        String ruta = OFBForward.PathFileTSMSAMOA();
                        ruta = String.valueOf(ruta) + inv.getDocumentNo() + ".txt";
                        String bu = "";
                        MAsset asset = null;
                        File file = new File(ruta);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        FileWriter fw = new FileWriter(file);
                        BufferedWriter bw = new BufferedWriter(fw);
                        MInventoryLine[] mInventoryLineArray = lines = inv.getLines(false);
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MProduct prod;
                            MInventoryLine line = mInventoryLineArray[n2];
                            if (line.isActive() && line.getM_Product_ID() > 0 && (prod = new MProduct(po.getCtx(), line.getM_Product_ID(), po.get_TrxName())).get_ValueAsBoolean("IsSamoa")) {
                                if (line.get_ValueAsInt("A_Asset_ID") > 0) {
                                    asset = new MAsset(po.getCtx(), line.get_ValueAsInt("A_Asset_ID"), po.get_TrxName());
                                    bu = String.valueOf(inv.getDocumentNo()) + ";" + inv.getM_Warehouse().getName() + ";" + DateUtils.formatDate(DateUtils.today(), true) + ";" + asset.getValue() + ";" + line.getM_Product().getValue() + ";" + line.getQtyInternalUse().setScale(3);
                                    bw.write(bu.toString());
                                    bw.newLine();
                                } else {
                                    int ID_Asset = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(rl.a_asset_id)  FROM m_requisitionline rl INNER JOIN m_requisition r ON (r.m_requisition_id = rl.m_requisition_id) INNER JOIN m_inventory i ON (r.m_inventory_id = i.m_inventory_id) INNER JOIN m_inventoryline il ON (i.m_inventory_ID = il.m_inventory_ID) WHERE il.line = rl.line AND il.m_inventoryline_id = " + line.get_ID()));
                                    if (ID_Asset > 0) {
                                        asset = new MAsset(po.getCtx(), ID_Asset, po.get_TrxName());
                                        bu = String.valueOf(inv.getDocumentNo()) + ";" + inv.getM_Warehouse().getName() + ";" + DateUtils.formatDate(DateUtils.today(), true) + ";" + asset.getValue() + ";" + line.getM_Product().getValue() + ";" + line.getQtyInternalUse().setScale(3);
                                        bw.write(bu.toString());
                                        bw.newLine();
                                    } else {
                                        throw new AdempiereException("ERROR:Linea sin activo relacionado");
                                    }
                                }
                            }
                            ++n2;
                        }
                        bw.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

