/*
 * Decompiled with CFR 0.152.
 */
package org.qdc.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModQDCUpdateQtyDelivered
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModQDCUpdateQtyDelivered.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        MInOut ship;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID && (ship = (MInOut)((Object)po)).getC_Order_ID() > 0 && ((order = new MOrder(po.getCtx(), ship.getC_Order_ID(), po.get_TrxName())).getC_DocType_ID() == 1000078 || order.getC_DocType_ID() == 1000085 || order.getC_DocType_ID() == 1000029)) {
            MOrderLine[] lines = order.getLines(true, null);
            int i = 0;
            while (i < lines.length) {
                MOrderLine line = lines[i];
                BigDecimal qtyDelivered = DB.getSQLValueBD((String)po.get_TrxName(), (String)"SELECT coalesce(sum(movementqty),0) from  m_inoutline iol inner join m_inout io on (iol.m_inout_id = io.m_inout_id)  where iol.c_orderline_id = ? ", (int)line.get_ID());
                log.config("qty delivered = " + qtyDelivered);
                if (qtyDelivered != null && qtyDelivered.compareTo(Env.ZERO) > 0) {
                    line.setQtyDelivered(qtyDelivered);
                    line.setQtyReserved(line.getQtyOrdered().subtract(qtyDelivered));
                    line.saveEx(po.get_TrxName());
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

