/*
 * Decompiled with CFR 0.152.
 */
package org.qdc.model;

import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModQDCShipmentValidateLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModQDCShipmentValidateLine.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MInOut min;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MInOut.Table_ID && (min = (MInOut)((Object)po)).get_ValueAsInt("M_InOut_ID") > 0 && min.getC_DocType_ID() != 1000013) {
            MInOutLine[] lines = min.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInOutLine line = lines[i];
                if (line.getM_Product_ID() > 0 && (line.get_Value("SKULine") == null || line.getM_Product().getSKU().compareTo(line.get_Value("SKULine").toString()) != 0)) {
                    return "Error. El SKU del producto " + line.getM_Product().getName() + " no corresponde al SKU de la linea";
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

