/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class SetTransactionLastinventory
extends SvrProcess {
    private Properties m_ctx;
    private int p_Product_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_Product_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        String mysql = "select p.m_product_id from m_product p inner join m_inventoryline il  on (p.m_product_id=il.m_product_id) inner join m_inventory i on (il.m_inventory_id=i.m_inventory_id) where p.isactive='Y' and p.ad_client_id=? and p.ISSTOCKED='Y' and p.PRODUCTTYPE='I' and i.docstatus='CO'";
        if (this.p_Product_ID > 0) {
            mysql = String.valueOf(mysql) + " and M_Product_ID=?";
        }
        mysql = String.valueOf(mysql) + " group by p.m_product_id\t";
        String sql2 = "select t.T_transaction_ID,t.movementdate, t.m_inventoryline_id  from m_transaction t  inner join m_inventoryline l on (t.m_inventoryline_id =l.m_inventoryline_id )  inner join m_inventory i on (il.m_inventory_id=i.m_inventory_id)  where t.m_product_id=? and  l.qtyinternaluse=0 and i.docstatus='CO' order by 2 desc, 3 desc";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            if (this.p_Product_ID > 0) {
                pstmt.setInt(2, this.p_Product_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTransaction trx = null;
                MInventoryLine ivl = null;
                CPreparedStatement pstmt2 = DB.prepareStatement((String)sql2, (String)this.get_TrxName());
                pstmt2.setInt(1, rs.getInt(1));
                ResultSet rs2 = pstmt.executeQuery();
                if (rs2.next()) {
                    trx = new MTransaction(Env.getCtx(), rs2.getInt(1), this.get_TrxName());
                    ivl = new MInventoryLine(Env.getCtx(), rs2.getInt(3), this.get_TrxName());
                }
                rs2.close();
                pstmt2.close();
                pstmt2 = null;
                if (trx == null || ivl == null) continue;
                trx.setMovementQty(ivl.getQtyCount());
                trx.saveEx();
                DB.executeUpdateEx((String)"update m_transaction set movementqty=0 where m_transaction_id<? and movementdate <= ? and m_product_id=? and m_locator_id=?", (Object[])new Object[]{trx.getM_Transaction_ID(), trx.getMovementDate(), ivl.getM_Product_ID(), ivl.getM_Locator_ID()}, (String)this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
        this.commitEx();
        pstmt = null;
        try {
            String sql = "select m_product_id,m_locator_id,M_ATTRIBUTESETINSTANCE_ID,qtyonhand,trxqty from ( select s.m_product_id, s.m_locator_id,s.M_ATTRIBUTESETINSTANCE_ID, sum(s.qtyonhand) as qtyonhand, (select sum(t.movementqty) from m_transaction t where t.m_product_id=s.m_product_id and t.m_locator_id=s.m_locator_id and t.M_ATTRIBUTESETINSTANCE_ID=s.M_ATTRIBUTESETINSTANCE_ID) as trxqty from m_storage s group by s.m_product_id, s.m_locator_id,M_ATTRIBUTESETINSTANCE_ID) where qtyonhand<>trxqty ";
            if (this.p_Product_ID > 0) {
                sql = String.valueOf(sql) + " and M_Product_ID=" + this.p_Product_ID;
            }
            int lastProduct_ID = 0;
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MStorage[] storages = this.getStorages(rs.getInt("m_product_id"), rs.getInt("m_locator_id"), rs.getInt("m_attributesetinstance_id"));
                if (lastProduct_ID != rs.getInt("m_product_id")) {
                    int j = 0;
                    while (j < storages.length) {
                        MStorage st = storages[j];
                        st.setQtyOnHand(Env.ZERO);
                        st.saveEx();
                        ++j;
                    }
                    lastProduct_ID = rs.getInt("m_product_id");
                }
                boolean fixed = false;
                int j = 0;
                while (j < storages.length) {
                    MStorage st = storages[j];
                    st.setQtyOnHand(rs.getBigDecimal("trxqty"));
                    st.saveEx();
                    fixed = true;
                }
                if (fixed) continue;
                MStorage.add(this.getCtx(), MLocator.get(this.getCtx(), rs.getInt(2)).getM_Warehouse_ID(), rs.getInt(2), rs.getInt(3), rs.getInt(4), 0, rs.getBigDecimal(1), Env.ZERO, Env.ZERO, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
        this.commitEx();
        return "ok";
    }

    public MStorage[] getStorages(int product_id, int locator_id, int ATTRIBUTESETINSTANCE_ID) {
        String mysql = "select * from m_storage where m_product_id=? and m_locator_id=? and M_ATTRIBUTESETINSTANCE_ID=?";
        CPreparedStatement pstmt = null;
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, product_id);
            pstmt.setInt(2, locator_id);
            pstmt.setInt(3, ATTRIBUTESETINSTANCE_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MStorage line = new MStorage(this.getCtx(), rs, this.get_TrxName());
                list.add(line);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
        MStorage[] lines = new MStorage[list.size()];
        list.toArray(lines);
        return lines;
    }
}

