/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class RepriceInvoice
extends SvrProcess {
    private int p_Invoice_ID = 0;
    private int p_ID_Currency = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_Currency_ID")) {
                this.p_ID_Currency = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_Invoice_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.getCtx(), this.p_Invoice_ID, this.get_TrxName());
        int ID_CurrencyBase = 228;
        int ID_CurrencyFinal = 228;
        if (this.p_ID_Currency > 0) {
            ID_CurrencyBase = this.p_ID_Currency;
        }
        if (inv.getC_Currency_ID() == ID_CurrencyBase) {
            throw new AdempiereUserError("Factura ya convertida", "Conversion Monetaria");
        }
        MCurrency curreTo = new MCurrency(this.getCtx(), ID_CurrencyBase, this.get_TrxName());
        BigDecimal MultiplyRate = (BigDecimal)inv.get_Value("MultiplyRate");
        if (MultiplyRate == null || MultiplyRate.signum() == 0) {
            MultiplyRate = MConversionRate.getRate(inv.getC_Currency_ID(), curreTo.get_ID(), inv.getDateInvoiced(), inv.getC_ConversionType_ID(), inv.getAD_Client_ID(), inv.getAD_Org_ID());
        }
        this.log.config("currency = " + inv.getC_Currency_ID() + " - To_Currency=" + curreTo.get_ID() + "- Date=" + inv.getDateInvoiced() + "-Conversion=" + inv.getC_ConversionType_ID());
        if (MultiplyRate == null || MultiplyRate.compareTo(Env.ZERO) <= 0) {
            throw new AdempiereUserError("Por favor definir el tipo de cambio", "Conversion Monetaria");
        }
        this.log.config("C_Invoice_ID:" + inv.get_ID() + "-MultiplyRate:" + MultiplyRate);
        inv.set_CustomColumn("MultiplyRate", MultiplyRate);
        BigDecimal ForeignPrice = (BigDecimal)inv.get_Value("ForeignPrice");
        if (ForeignPrice == null || ForeignPrice.signum() == 0) {
            inv.set_CustomColumn("ForeignPrice", inv.getGrandTotal());
            inv.setC_Currency_ID(ID_CurrencyFinal);
            inv.save();
        }
        String sql = "SELECT invl.C_InvoiceLine_ID  FROM C_InvoiceLine invl WHERE invl.C_Invoice_ID = " + inv.get_ID();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MInvoiceLine line = new MInvoiceLine(Env.getCtx(), rs.getInt(1), this.get_TrxName());
                    if (line.get_Value("ForeignPrice") != null && ((BigDecimal)line.get_Value("ForeignPrice")).compareTo(Env.ZERO) > 0) {
                        rs = null;
                        pstmt = null;
                        throw new AdempiereUserError("La conversion monetaria ya fue ejecutada con anterioridad para esta factura", "Conversion Monetaria");
                    }
                    line.set_CustomColumn("ForeignPrice", line.getPriceEntered());
                    this.log.config("setForeignPrice:" + line.getPriceActual().setScale(curreTo.getStdPrecision(), 6));
                    line.setPriceList(line.getPriceList().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6));
                    this.log.config("setPriceList:" + line.getPriceList().multiply(MultiplyRate));
                    line.setPrice(line.getPriceEntered().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6));
                    line.setLineNetAmt();
                    line.save();
                    line.setTaxAmt();
                    line.save();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                rs = null;
                pstmt = null;
                rs.close();
                pstmt.close();
                rs = null;
                pstmt = null;
            }
        }
        finally {
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        return "Conversi\u00f3n realizada";
    }
}

