/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.X_RH_MedicalLicenses;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessMedicalLicenses
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        X_RH_MedicalLicenses doc = new X_RH_MedicalLicenses(Env.getCtx(), this.Record_ID, this.get_TrxName());
        if (this.P_DocAction.equals("IP") && !doc.isProcessed()) {
            doc.setProcessed(true);
            doc.setDocStatus("IP");
            doc.save();
            return "Procesado";
        }
        if (this.P_DocAction.equals("CO") && (!doc.isProcessed() || doc.getDocStatus().equals("IP"))) {
            Timestamp fechaInicio = (Timestamp)doc.get_Value("datestartrequest");
            Calendar calCalendario = Calendar.getInstance();
            calCalendario.setTimeInMillis(fechaInicio.getTime());
            calCalendario.add(5, doc.getDays().intValueExact());
            Timestamp fechaFin = new Timestamp(calCalendario.getTimeInMillis());
            String sqlValid1 = "SELECT COUNT(DISTINCT (ar.rh_administrativerequests_ID)) FROM rh_administrativerequests  ar WHERE ( ( ( ? >= ar.datestartrequest AND ? <= ar.dateendrequest ) OR ( ? >= ar.datestartrequest AND ? <= ar.dateendrequest ) ) OR ( ( ar.datestartrequest >= ? AND ar.datestartrequest <= ? ) OR ( ar.dateendrequest >= ? AND ar.dateendrequest <=  ? ) ) ) AND ar.c_bpartner_id = ? AND ar.requesttype in ('CMT') AND ar.IsActive = 'Y' AND ar.DocStatus not in ('VO') ";
            int cantValid1 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlValid1, (Object[])new Object[]{fechaInicio, fechaInicio, fechaFin, fechaFin, fechaInicio, fechaFin, fechaInicio, fechaFin, doc.getC_BPartner_ID()});
            if (cantValid1 > 0) {
                throw new AdempiereException("No se puede completar Licencia Medica. Existe un Cometido en Conflicto");
            }
            String sqlValid2 = "SELECT COUNT(DISTINCT (ar.rh_administrativerequests_ID)) FROM rh_administrativerequests  ar WHERE ( ( ( ? >= ar.datestartrequest AND ? <= ar.dateendrequest ) OR ( ? >= ar.datestartrequest AND ? <= ar.dateendrequest ) ) OR ( ( ar.datestartrequest >= ? AND ar.datestartrequest <= ? ) OR ( ar.dateendrequest >= ? AND ar.dateendrequest <=  ? ) ) ) AND ar.c_bpartner_id = ? AND ar.requesttype in ('SVC') AND ar.IsActive = 'Y' AND ar.DocStatus not in ('VO') ";
            int cantValid2 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlValid2, (Object[])new Object[]{fechaInicio, fechaInicio, fechaFin, fechaFin, fechaInicio, fechaFin, fechaInicio, fechaFin, doc.getC_BPartner_ID()});
            if (cantValid2 > 0) {
                return "No se puede completar Licencia Medica. Existe una Solicitud de Feriado Legal en Conflicto";
            }
            String sqlValid3 = "SELECT COUNT(DISTINCT (ar.rh_administrativerequests_ID)) FROM rh_administrativerequests  ar LEFT JOIN RH_AdministrativeRequestsLine arl on (ar.rh_administrativerequests_ID = arl.rh_administrativerequests_ID ) WHERE ( arl.datestartrequest >= ? AND arl.datestartrequest <= ? ) AND ar.c_bpartner_id = ? AND ar.requesttype in ('PAD') AND ar.IsActive = 'Y' AND ar.DocStatus not in ('VO') ";
            int cantValid3 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlValid3, (Object[])new Object[]{fechaInicio, fechaFin, doc.getC_BPartner_ID()});
            if (cantValid3 > 0) {
                return "No se puede completar Licencia Medica. Existe un Permiso Administrativo en Conflicto";
            }
            String sqlValid4 = "SELECT COUNT(DISTINCT (ar.rh_administrativerequests_ID)) FROM rh_administrativerequests  ar WHERE ( ar.datestartrequest >= ? AND ar.datestartrequest <= ? ) AND ar.c_bpartner_id = ? AND ar.requesttype in ('SHE') AND ar.IsActive = 'Y' AND ar.DocStatus not in ('VO')";
            int cantValid4 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlValid4, (Object[])new Object[]{fechaInicio, fechaFin, doc.getC_BPartner_ID()});
            if (cantValid4 > 0) {
                return "No se puede completar Licencia Medica. Existe una Solicitud de Hora Extra en Conflicto";
            }
            doc.setProcessed(true);
            doc.setDocStatus("CO");
            doc.save();
            return "Completado";
        }
        if (this.P_DocAction.equals("VO") && doc.isProcessed() && doc.getDocStatus().equals("CO")) {
            doc.setProcessed(true);
            doc.setDocStatus("VO");
            doc.save();
            return "Anulado";
        }
        return "No es posible Cumplir la Accion ";
    }
}

