/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPaySchedule;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.X_C_OrderPaySchedule;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class OrderSchedule
extends SvrProcess {
    private Timestamp p_FirstDate;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("StartDate")) {
                    this.p_FirstDate = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        BigDecimal amtAcumUF;
        MOrder order = new MOrder(Env.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (order.get_ValueAsString("PaymentRule2").equals("P")) {
            this.agregaCargoPagare(order);
        }
        if (order.isSOTrx()) {
            BigDecimal qtyColegio;
            BigDecimal qtyMatricula;
            String SqlMatricula = "select coalesce(sum(col.qtyentered),0) from c_orderline col inner join m_product mp on (col.m_product_id = mp.m_product_id) inner join m_product_category mpc on (mp.m_product_category_id = mpc.m_product_category_id) where col.C_Order_ID = " + order.get_ID() + " and upper(mpc.name) like '%MATRICULA%'";
            String SqlColegio = "select coalesce(sum(col.qtyentered),0) from c_orderline col inner join m_product mp on (col.m_product_id = mp.m_product_id) inner join m_product_category mpc on (mp.m_product_category_id = mpc.m_product_category_id) where col.C_Order_ID = " + order.get_ID() + " and upper(mpc.name) like '%COLEGIATURA%'";
            try {
                qtyMatricula = DB.getSQLValueBD(null, (String)SqlMatricula, (Object[])new Object[0]);
                qtyColegio = DB.getSQLValueBD(null, (String)SqlColegio, (Object[])new Object[0]);
            }
            catch (Exception e) {
                qtyMatricula = Env.ZERO;
                qtyColegio = Env.ZERO;
            }
            if (qtyMatricula.compareTo(qtyColegio) != 0) {
                throw new AdempiereException("Error: Cantidad de Matriculas y Colegiaturas no coincide. Matriculas: " + qtyMatricula + " Colegiaturas: " + qtyColegio);
            }
        }
        DB.executeUpdate((String)("delete from C_OrderPaySchedule where C_Order_ID=" + order.getC_Order_ID()), (String)this.get_TrxName());
        MOrderLine[] lines = order.getLines(true, null);
        BigDecimal colAmt = Env.ZERO;
        BigDecimal maAmt = Env.ZERO;
        MOrderLine[] mOrderLineArray = lines;
        int n = lines.length;
        int e = 0;
        while (e < n) {
            MOrderLine line = mOrderLineArray[e];
            if (line.getM_Product_ID() > 0) {
                if (line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("COLEGIATURA") >= 0) {
                    colAmt = colAmt.add(line.getLineNetAmt());
                }
                if (line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("MATR\u00cdCULA") >= 0 || line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("MATRICULA") >= 0) {
                    maAmt = maAmt.add(line.getLineNetAmt());
                }
            } else {
                colAmt = colAmt.add(line.getLineNetAmt());
            }
            ++e;
        }
        MPaymentTerm pt = new MPaymentTerm(this.getCtx(), order.getC_PaymentTerm_ID(), this.get_TrxName());
        BigDecimal remainder = maAmt;
        X_C_OrderPaySchedule os = null;
        MPaySchedule[] mPayScheduleArray = pt.getSchedule(false);
        int n2 = mPayScheduleArray.length;
        int n3 = 0;
        while (n3 < n2) {
            MPaySchedule ps = mPayScheduleArray[n3];
            os = new X_C_OrderPaySchedule(this.getCtx(), 0, this.get_TrxName());
            os.setC_Order_ID(this.getRecord_ID());
            os.setDueAmt(maAmt.multiply(ps.getPercentage()).divide(Env.ONEHUNDRED, 0, 4));
            os.setDueDate(TimeUtil.addDays((Timestamp)order.getDateOrdered(), (int)ps.getNetDays()));
            os.setIsValid(true);
            os.set_CustomColumn("C_PaySchedule_ID", ps.getC_PaySchedule_ID());
            os.set_CustomColumn("IsMatricula", true);
            os.save();
            remainder = remainder.subtract(os.getDueAmt());
            BigDecimal amtAcumUF2 = MConversionRate.convert(this.getCtx(), os.getDueAmt(), order.getC_Currency_ID(), 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
            if (amtAcumUF2 == null) {
                return "No existe tasa de cambio para UF, no se puede completar la operacion";
            }
            try {
                os.set_CustomColumn("ForeignPrice", amtAcumUF2);
            }
            catch (Exception e2) {
                this.log.log(Level.SEVERE, e2.getMessage(), (Throwable)e2);
            }
            os.save();
            ++n3;
        }
        if (remainder.compareTo(Env.ZERO) != 0 && os != null) {
            os.setDueAmt(os.getDueAmt().add(remainder));
            os.save();
            amtAcumUF = MConversionRate.convert(this.getCtx(), os.getDueAmt(), order.getC_Currency_ID(), 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
            if (amtAcumUF == null) {
                return "No existe tasa de cambio para UF, no se puede completar la operacion";
            }
            try {
                os.set_CustomColumn("ForeignPrice", amtAcumUF);
            }
            catch (Exception e3) {
                this.log.log(Level.SEVERE, e3.getMessage(), (Throwable)e3);
            }
            os.save();
        }
        if (os == null) {
            os = new X_C_OrderPaySchedule(this.getCtx(), 0, this.get_TrxName());
            os.setC_Order_ID(this.getRecord_ID());
            os.setDueAmt(maAmt);
            os.setDueDate(TimeUtil.addDays((Timestamp)order.getDateOrdered(), (int)pt.getNetDays()));
            os.set_CustomColumn("IsMatricula", true);
            os.setIsValid(true);
            os.save();
            amtAcumUF = MConversionRate.convert(this.getCtx(), maAmt, order.getC_Currency_ID(), 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
            if (amtAcumUF == null) {
                return "No existe tasa de cambio para UF, no se puede completar la operacion";
            }
            try {
                os.set_CustomColumn("ForeignPrice", amtAcumUF);
            }
            catch (Exception e4) {
                this.log.log(Level.SEVERE, e4.getMessage(), (Throwable)e4);
            }
            os.save();
        }
        os = null;
        remainder = colAmt;
        pt = new MPaymentTerm(this.getCtx(), order.get_ValueAsInt("C_PaymentTerm2_ID"), this.get_TrxName());
        int i = 0;
        Timestamp dueDate = this.p_FirstDate;
        MPaySchedule[] mPayScheduleArray2 = pt.getSchedule(false);
        int n4 = mPayScheduleArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            MPaySchedule ps = mPayScheduleArray2[n5];
            os = new X_C_OrderPaySchedule(this.getCtx(), 0, this.get_TrxName());
            os.setC_Order_ID(this.getRecord_ID());
            os.setDueAmt(colAmt.multiply(ps.getPercentage()).divide(Env.ONEHUNDRED, 0, 4));
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(dueDate.getTime());
            if (i > 0) {
                cal.set(5, 1);
                cal.add(2, i);
            }
            Timestamp newDate = new Timestamp(cal.getTimeInMillis());
            os.setDueDate(newDate);
            os.setIsValid(true);
            os.set_CustomColumn("C_PaySchedule_ID", ps.getC_PaySchedule_ID());
            os.save();
            ++i;
            remainder = remainder.subtract(os.getDueAmt());
            BigDecimal amtAcumUF3 = MConversionRate.convert(this.getCtx(), os.getDueAmt(), order.getC_Currency_ID(), 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
            if (amtAcumUF3 == null) {
                return "No existe tasa de cambio para UF, no se puede completar la operacion";
            }
            try {
                os.set_CustomColumn("ForeignPrice", amtAcumUF3);
            }
            catch (Exception e5) {
                this.log.log(Level.SEVERE, e5.getMessage(), (Throwable)e5);
            }
            os.save();
            ++n5;
        }
        if (remainder.compareTo(Env.ZERO) != 0 && os != null) {
            os.setDueAmt(os.getDueAmt().add(remainder));
            os.save();
            BigDecimal amtAcumUF4 = MConversionRate.convert(this.getCtx(), os.getDueAmt(), order.getC_Currency_ID(), 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
            if (amtAcumUF4 == null) {
                return "No existe tasa de cambio para UF, no se puede completar la operacion";
            }
            try {
                os.set_CustomColumn("ForeignPrice", amtAcumUF4);
            }
            catch (Exception e6) {
                this.log.log(Level.SEVERE, e6.getMessage(), (Throwable)e6);
            }
            os.save();
        }
        if (os == null) {
            os = new X_C_OrderPaySchedule(this.getCtx(), 0, this.get_TrxName());
            os.setC_Order_ID(this.getRecord_ID());
            os.setDueAmt(colAmt);
            os.setDueDate(TimeUtil.addDays((Timestamp)order.getDateOrdered(), (int)pt.getNetDays()));
            os.setIsValid(true);
            os.save();
            BigDecimal amtAcumUF5 = MConversionRate.convert(this.getCtx(), os.getDueAmt(), order.getC_Currency_ID(), 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
            if (amtAcumUF5 == null) {
                return "No existe tasa de cambio para UF, no se puede completar la operacion";
            }
            try {
                os.set_CustomColumn("ForeignPrice", amtAcumUF5);
            }
            catch (Exception e7) {
                this.log.log(Level.SEVERE, e7.getMessage(), (Throwable)e7);
            }
            os.save();
        }
        return "Cuotas Calculadas";
    }

    private void agregaCargoPagare(MOrder order) {
        String sql3 = "SELECT max(C_Charge_ID) FROM C_Charge WHERE upper(TipoCargo)='TC13'  and isactive='Y' and AD_client_ID=" + order.getAD_Client_ID();
        int C_ChargeChange_ID = DB.getSQLValue((String)"C_Charge", (String)sql3);
        if (C_ChargeChange_ID <= 0) {
            throw new AdempiereException("No existe Cargo para Pagares");
        }
        BigDecimal chargeAmt = MCharge.get((Properties)order.getCtx(), (int)C_ChargeChange_ID).getChargeAmt();
        DB.executeUpdate((String)("delete from C_OrderLine where C_Order_ID=" + order.getC_Order_ID() + " and C_Charge_ID = " + C_ChargeChange_ID), (String)order.get_TrxName());
        int colegiaturas = 0;
        String sqlCant = "select count(distinct(C_OrderLine_ID)) FROM C_OrderLine col INNER JOIN M_Product mp on (col.M_Product_ID = mp.M_Product_ID) INNER JOIN M_Product_Category mpc on (mp.M_Product_Category_ID = mpc.M_Product_Category_ID) WHERE col.C_Order_ID = " + order.get_ID() + " AND upper(mpc.name) like '%COLEGIATURA%' ";
        colegiaturas = DB.getSQLValue((String)order.get_TrxName(), (String)sqlCant);
        if (colegiaturas > 0) {
            if (order.getC_Currency_ID() != 1000000) {
                BigDecimal chargeAmtCal = MConversionRate.convertBase(order.getCtx(), chargeAmt, 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                if (chargeAmtCal == null) {
                    chargeAmtCal = MConversionRate.convert(order.getCtx(), chargeAmt, 1000000, order.getC_Currency_ID(), order.getAD_Client_ID(), order.getAD_Org_ID());
                }
                if (chargeAmtCal == null) {
                    throw new AdempiereException("No existe tasa de cambio al dia UF");
                }
                chargeAmt = chargeAmtCal;
            }
            String sqlAmtCharge2 = "select (SUM(col.LineNetAmt)*2)/100 FROM C_OrderLine col  LEFT JOIN M_Product mp on (col.M_Product_ID = mp.M_Product_ID) LEFT JOIN M_Product_Category mpc on (mp.M_Product_Category_ID = mpc.M_Product_Category_ID) WHERE col.C_Order_ID = " + order.get_ID() + " AND (upper(mpc.name) not like '%MATRICULAS%' OR mpc.name is null)" + " AND (C_Charge_ID is null OR (C_Charge_ID <> " + C_ChargeChange_ID + " and c_charge_id is not null))";
            BigDecimal amtCharge2 = DB.getSQLValueBD((String)order.get_TrxName(), (String)sqlAmtCharge2, (Object[])new Object[0]);
            chargeAmt = chargeAmt.add(amtCharge2);
            MOrderLine line = new MOrderLine(order);
            line.setPriceActual(chargeAmt);
            line.setQty(Env.ONE);
            line.setQtyDelivered(Env.ZERO);
            line.setC_Charge_ID(C_ChargeChange_ID);
            line.setLineNetAmt();
            line.save();
        }
    }
}

