/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.OFBProductCost;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class OFBProcessCostDetailProduction
extends SvrProcess {
    private int p_Production_ID = 0;
    private Timestamp p_from;
    private String p_CostingLevel = "C";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        this.p_Production_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MProduction prod = new MProduction(this.getCtx(), this.p_Production_ID, this.get_TrxName());
        String sql = "SELECT m_productionline_id from m_productionline where m_productionplan_id in (SELECT m_productionplan_id from m_productionplan where m_production_id = ?)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        pstmt.setInt(1, this.p_Production_ID);
        rs = pstmt.executeQuery();
        while (rs.next()) {
            MProductionLine pl = new MProductionLine(this.getCtx(), rs.getInt("M_ProductionLine_ID"), this.get_TrxName());
            OFBProductCost.processCost(pl.getM_Product_ID(), this.get_TrxName(), this.getCtx());
        }
        this.commitEx();
        try {
            prod.set_CustomColumn("costflag", (Object)"Y");
            prod.save();
        }
        catch (Exception e) {
            throw new AdempiereException("No se puede actualizar");
        }
        return "Procesado";
    }
}

