/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.X_I_OrderMC;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSonChileCompra
extends SvrProcess {
    private String p_DocNo;
    private String p_Token;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocNo")) {
                    this.p_DocNo = para[i].getParameterAsString();
                } else if (name.equals("Token")) {
                    this.p_Token = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.log.config("TOKEN = " + this.p_Token);
        this.log.config("ORDEN = " + this.p_DocNo);
        String website = "http://api.mercadopublico.cl/servicios/v1/publico/ordenesdecompra.json?codigo=" + this.p_DocNo + "&ticket=" + this.p_Token;
        InputStream is = new URL(website).openStream();
        this.log.config("website = " + website);
        BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        while ((counter = rd.read()) != -1) {
            sb.append((char)counter);
        }
        String jsonText = sb.toString();
        this.log.config("jsonText = " + jsonText);
        JSONObject json = new JSONObject(jsonText);
        JSONArray jsonarr = json.getJSONArray("Listado");
        int lenght = jsonarr.length();
        String Codigo = jsonarr.getJSONObject(0).get("Codigo").toString();
        String Nombre = jsonarr.getJSONObject(0).get("Nombre").toString();
        String Descripcion = jsonarr.getJSONObject(0).get("Descripcion").toString();
        this.log.config("Valor : " + json.toString());
        this.log.config("Codigo " + Codigo);
        this.log.config("Nombre " + Nombre);
        String Proveedor = jsonarr.getJSONObject(0).get("Proveedor").toString();
        this.log.config("Proveedor " + Proveedor);
        JSONObject Prov = new JSONObject(jsonarr.getJSONObject(0).get("Proveedor").toString());
        String Nombre2 = Prov.getString("Nombre");
        String Rut = Prov.getString("RutSucursal");
        String Rut2 = Rut.replace(".", "");
        Rut2 = Rut2.substring(0, Rut2.length() - 2);
        this.log.config("Proveedor " + Proveedor);
        this.log.config("Proveedor " + Nombre2);
        this.log.config("Rut Proveedor " + Rut2);
        JSONObject line = new JSONObject(jsonarr.getJSONObject(0).get("Items").toString());
        JSONArray jsonarrline = line.getJSONArray("Listado");
        BigDecimal PrecioNeto = Env.ZERO;
        String Producto = null;
        String EspProveedor = null;
        int i = 0;
        while (i < jsonarrline.length()) {
            PrecioNeto = new BigDecimal(jsonarrline.getJSONObject(i).get("PrecioNeto").toString());
            Producto = jsonarrline.getJSONObject(i).get("Producto").toString();
            EspProveedor = jsonarrline.getJSONObject(i).get("EspecificacionProveedor").toString();
            this.log.config("Precio neto " + PrecioNeto);
            this.log.config("Producto " + Producto);
            this.log.config("EspProveedor " + EspProveedor);
            X_I_OrderMC omc = new X_I_OrderMC(this.getCtx(), 0, this.get_TrxName());
            omc.setDocumentNo(Codigo);
            omc.setBPartnerValue(Rut2);
            omc.setDescription(Descripcion);
            omc.setLineDescription(EspProveedor);
            omc.setPriceActual(PrecioNeto);
            omc.setProductName(Producto);
            omc.save();
            ++i;
        }
        int c_order_id = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT max(C_Order_ID) from c_order where documentno like '%" + Codigo + "%'"));
        MOrder ord = new MOrder(this.getCtx(), c_order_id, this.get_TrxName());
        ord.set_CustomColumn("ProveedorCC", Rut2);
        ord.set_CustomColumn("DescriptionCC", Descripcion);
        int c_bpartner_id = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT max(c_bpartner_id) from c_bpartner where value like '" + Rut2 + "'"));
        if (c_bpartner_id > 0) {
            ord.setC_BPartner_ID(c_bpartner_id);
        }
        ord.save();
        String sql = "SELECT priceactual, productname, linedescription from i_ordermc where  documentno like '%" + Codigo + "%'";
        CPreparedStatement ps = DB.prepareStatement((String)sql, (String)ord.get_TrxName());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            BigDecimal precioactual = rs.getBigDecimal("priceactual");
            String sqlline = "SELECT max(c_orderline_id) from c_orderline where c_order_id = " + ord.get_ID() + " and " + " priceentered = " + precioactual;
            int c_orderline = DB.getSQLValue((String)this.get_TrxName(), (String)sqlline);
            if (c_orderline <= 0) continue;
            MOrderLine ordl = new MOrderLine(this.getCtx(), c_orderline, this.get_TrxName());
            ordl.set_CustomColumn("LineDescriptionCC", EspProveedor);
            ordl.set_CustomColumn("PriceActualCC", PrecioNeto);
            ordl.set_CustomColumn("ProductNameCC", Producto);
            ordl.save();
        }
        return "";
    }
}

