/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportCashJournal
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private String p_DosStatus = "";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DocStatus")) {
                this.p_DosStatus = para[i].getParameterAsString();
            } else {
                this.log.info("ImportAsset.prepare - Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_Cash  WHERE I_IsImported='Y' ").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        }
        sql = new StringBuffer("UPDATE I_Cash SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), CreatedBy = COALESCE (CreatedBy, 0), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = NULL, I_IsImported = 'N'  WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuffer("UPDATE I_Cash o SET AD_Org_ID=(SELECT MAX(AD_Org_ID) FROM AD_Org org WHERE o.OrgValue=org.Value AND o.AD_Client_ID=org.AD_Client_ID)  WHERE AD_Org_ID IS NULL AND OrgValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set org from Value=" + no);
        sql = new StringBuffer("UPDATE I_Cash o SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp WHERE o.BPartnerValue=bp.Value AND o.AD_Client_ID=bp.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set bp from Value=" + no);
        sql = new StringBuffer("UPDATE I_Cash SET I_ErrorMsg=I_ErrorMsg||'ERR=Invalid BP,'  WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuffer("UPDATE I_Cash o  SET C_Invoice_ID=(SELECT MAX(C_Invoice_ID) FROM C_Invoice i  WHERE o.C_BPartner_ID=i.C_BPartner_ID AND o.documentnoinvoice=i.documentno  AND i.Issotrx='N' AND o.AD_Client_ID=i.AD_Client_ID)  WHERE C_Invoice_ID IS NULL AND C_BPartner_ID IS NOT NULL AND documentnoinvoice IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuffer("UPDATE I_Cash o SET C_Charge_ID=(SELECT MAX(C_Charge_ID) FROM C_Charge bp WHERE o.chargename=bp.name AND o.AD_Client_ID=bp.AD_Client_ID)  WHERE C_Charge_ID IS NULL AND chargename IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuffer("UPDATE I_Cash o  SET C_BPartnerPayment_ID =(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp WHERE o.BPartnerValuePay=bp.Value AND o.AD_Client_ID=bp.AD_Client_ID)  WHERE C_BPartnerPayment_ID IS NULL AND BPartnerValuePay IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuffer("UPDATE I_Cash o  SET C_Payment_ID=(SELECT MAX(C_Payment_ID) FROM C_Payment p  WHERE o.C_BPartnerPayment_ID=p.C_BPartner_ID AND o.documentnopayment=p.documentno  AND o.AD_Client_ID=p.AD_Client_ID)  WHERE C_Payment_ID IS NULL AND C_BPartnerPayment_ID IS NOT NULL AND documentnopayment IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuffer("SELECT * FROM I_Cash  WHERE I_IsImported= 'N' AND  (C_Invoice_ID > 0 OR C_Charge_ID > 0 OR C_Payment_ID > 0)").append(clientCheck).append(" Order By c_cashbook_id");
        int ID_cashOld = 0;
        MCash cash = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (ID_cashOld != rs.getInt("c_cashbook_id")) {
                        if (cash != null && this.p_DosStatus != null && this.p_DosStatus.compareTo("CO") == 0) {
                            cash.processIt("CO");
                            cash.saveEx(this.get_TrxName());
                        }
                        cash = new MCash(this.getCtx(), 0, this.get_TrxName());
                        cash.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                        cash.setC_CashBook_ID(rs.getInt("C_CashBook_ID"));
                        cash.setDescription(rs.getString("Description"));
                        cash.setStatementDate(rs.getTimestamp("StatementDate"));
                        cash.setDateAcct(rs.getTimestamp("DateAcct"));
                        cash.save(this.get_TrxName());
                        ID_cashOld = rs.getInt("c_cashbook_id");
                    }
                    if (cash == null) continue;
                    MCashLine cLine = new MCashLine(cash);
                    cLine.set_CustomColumn("C_Bpartner_ID", rs.getInt("C_Bpartner_ID"));
                    cLine.setC_Cash_ID(cash.get_ID());
                    cLine.setDescription(rs.getString("DescriptionLine"));
                    cLine.setCashType(rs.getString("CashType"));
                    cLine.setC_Currency_ID(228);
                    cLine.setAmount(rs.getBigDecimal("Amount"));
                    if (rs.getInt("C_Invoice_ID") > 0) {
                        cLine.setC_Invoice_ID(rs.getInt("C_Invoice_ID"));
                    }
                    if (rs.getInt("C_Charge_ID") > 0) {
                        cLine.setC_Charge_ID(rs.getInt("C_Charge_ID"));
                    }
                    if (rs.getInt("C_Payment_ID") > 0) {
                        MPayment pay = new MPayment(this.getCtx(), rs.getInt("C_Payment_ID"), this.get_TrxName());
                        cLine.setC_Payment_ID(rs.getInt("C_Payment_ID"));
                        cLine.setC_BankAccount_ID(pay.getC_BankAccount_ID());
                        cLine.set_CustomColumn("C_BPartner_ID", pay.getC_BPartner_ID());
                        cLine.set_CustomColumn("TenderType", pay.getTenderType());
                    }
                    if (!cLine.save(this.get_TrxName())) continue;
                    DB.executeUpdate((String)("UPDATE I_Cash SET C_Cash_ID=" + cash.get_ID() + ", C_CashLine_ID=" + cLine.get_ID() + "," + " Processed='Y', I_IsImported='Y' WHERE I_Cash_ID=" + rs.getInt("I_Cash_ID")), (String)this.get_TrxName());
                }
                if (cash != null && cash.getDocStatus().compareTo("CO") != 0 && this.p_DosStatus != null && this.p_DosStatus.compareTo("CO") == 0) {
                    cash.processIt("CO");
                    cash.saveEx(this.get_TrxName());
                }
            }
            catch (SQLException e) {
                throw new Exception("ImportCashJournal.doIt:" + e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        pstmt = null;
        sql = new StringBuffer("UPDATE I_Cash SET I_IsImported='N' WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.commitEx();
        return "";
    }
}

