/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportDTEMInOutCGProvectis
extends SvrProcess {
    private Properties m_ctx;
    private int p_M_InOut_ID = 0;

    protected void prepare() {
        this.p_M_InOut_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MInOut inOut = new MInOut(this.m_ctx, this.p_M_InOut_ID, this.get_TrxName());
        String msg = this.CreateXMLCG(inOut);
        return msg;
    }

    public String CreateXMLCG(MInOut inOut) {
        MDocType doc = new MDocType(inOut.getCtx(), inOut.getC_DocType_ID(), inOut.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "DTE-" + inOut.getDocumentNo());
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(inOut.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(inOut.getMovementDate().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            Element TipoDespacho = document.createElement("TipoDespacho");
            Text TDespacho = document.createTextNode("2");
            TipoDespacho.appendChild(TDespacho);
            IdDoc2.appendChild(TipoDespacho);
            String IndTrl = null;
            try {
                IndTrl = inOut.get_ValueAsString("IndTraslado");
            }
            catch (Exception e) {
                IndTrl = null;
            }
            if (IndTrl != null && IndTrl.length() > 0) {
                Element IndTraslado = document.createElement("IndTraslado");
                Text iTraslado = document.createTextNode(IndTrl);
                IndTraslado.appendChild(iTraslado);
                IdDoc2.appendChild(IndTraslado);
            }
            if (inOut.getC_Order_ID() > 0) {
                MOrder order = new MOrder(inOut.getCtx(), inOut.getC_Order_ID(), inOut.get_TrxName());
                MPaymentTerm pterm = new MPaymentTerm(inOut.getCtx(), order.getC_PaymentTerm_ID(), inOut.get_TrxName());
                Element PayTerm = document.createElement("TermPagoGlosa");
                Text term = document.createTextNode(pterm.getName());
                PayTerm.appendChild(term);
                IdDoc2.appendChild(PayTerm);
            }
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get((Properties)inOut.getCtx(), (int)inOut.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor2.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(inOut.getCtx(), inOut.getC_BPartner_ID(), inOut.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(inOut.getCtx(), inOut.getC_BPartner_Location_ID(), inOut.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor2.appendChild(GiroRecep);
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(inOut.getAD_User_ID() > 0 ? inOut.getAD_User().getName() : " ");
            ContactoRecep.appendChild(contacto);
            Receptor2.appendChild(ContactoRecep);
            Element CorreoRecep = document.createElement("CorreoRecep");
            Text corrRecep = document.createTextNode(inOut.getAD_User().getEMail() == null ? " " : inOut.getAD_User().getEMail());
            CorreoRecep.appendChild(corrRecep);
            Receptor2.appendChild(CorreoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(bloc.getLocation(true).getAddress3() == null ? " " : bloc.getLocation(true).getAddress3());
            CmnaRecep.appendChild(Cmna);
            Receptor2.appendChild(CmnaRecep);
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(inOut.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            Element transporte = document.createElement("Transporte");
            Encabezado2.appendChild(transporte);
            Element DirDest = document.createElement("DirDest");
            Text dirdest = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirDest.appendChild(dirdest);
            transporte.appendChild(DirDest);
            Element CmnaDest = document.createElement("CmnaDest");
            Text CmnaDestTxt = document.createTextNode(bloc.getLocation(true).getAddress3() == null ? " " : bloc.getLocation(true).getAddress3());
            CmnaDest.appendChild(CmnaDestTxt);
            transporte.appendChild(CmnaDest);
            Element CiudadDest = document.createElement("CiudadDest");
            Text regDest = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(inOut.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadDest.appendChild(regDest);
            transporte.appendChild(CiudadDest);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountGrandT = Env.ZERO;
            BigDecimal priceT = Env.ZERO;
            BigDecimal taxAmt = Env.ZERO;
            if (inOut.getC_Order_ID() > 0) {
                MInOutLine[] iLines2 = inOut.getLines();
                int a2 = 0;
                while (a2 < iLines2.length) {
                    priceT = Env.ZERO;
                    taxAmt = Env.ZERO;
                    MInOutLine iLine = iLines2[a2];
                    String nameCg = iLine.get_ValueAsString("ProductNameCG");
                    if (nameCg != null && nameCg != "" && nameCg != " ") {
                        priceT = (BigDecimal)iLine.get_Value("PriceEntered_CG");
                        BigDecimal qtyGC = (BigDecimal)iLine.get_Value("QtyGC");
                        priceT = priceT.multiply(qtyGC);
                        if (iLine.getC_OrderLine().getC_Tax_ID() > 0 && iLine.getC_OrderLine().getC_Tax().getRate().compareTo(Env.ZERO) > 0) {
                            taxAmt = priceT.multiply(iLine.getC_OrderLine().getC_Tax().getRate());
                            taxAmt = taxAmt.divide(Env.ONEHUNDRED);
                        }
                        priceT = priceT.add(taxAmt);
                        amountGrandT = amountGrandT.add(priceT);
                    }
                    ++a2;
                }
            }
            Element TasaIVA = document.createElement("TasaIVA");
            Text tiva = document.createTextNode("19");
            TasaIVA.appendChild(tiva);
            Totales2.appendChild(TasaIVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(amountGrandT.setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            MInOutLine[] iLines = inOut.getLines();
            int indLine = 1;
            int i = 0;
            while (i < iLines.length) {
                String nameCg;
                MInOutLine iLine = iLines[i];
                if ((iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) && (nameCg = iLine.get_ValueAsString("ProductNameCG")) != null && nameCg != "" && nameCg != " ") {
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(indLine));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = nameCg;
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    String descCG = iLine.get_ValueAsString("DescriptionCG");
                    if (descCG == null) {
                        descCG = " ";
                    }
                    Element DscItem = document.createElement("DscItem");
                    Text desc = document.createTextNode(descCG == null ? " " : descCG);
                    DscItem.appendChild(desc);
                    Detalle2.appendChild(DscItem);
                    BigDecimal mtoItem = Env.ZERO;
                    BigDecimal prcRefMnt = Env.ZERO;
                    BigDecimal qtyGC = Env.ZERO;
                    if (iLine.getC_OrderLine_ID() > 0) {
                        prcRefMnt = (BigDecimal)iLine.get_Value("PriceEntered_CG");
                        qtyGC = (BigDecimal)iLine.get_Value("QtyGC");
                        mtoItem = prcRefMnt.multiply(qtyGC);
                    }
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(qtyGC.setScale(0, 4).toString());
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    Element PrcRef = document.createElement("PrcItem");
                    Text PrcRefTxt = document.createTextNode(prcRefMnt.setScale(0, 4).toString());
                    PrcRef.appendChild(PrcRefTxt);
                    Detalle2.appendChild(PrcRef);
                    Element MtoItem = document.createElement("MontoItem");
                    Text MtoTxt = document.createTextNode(mtoItem.setScale(0, 4).toString());
                    MtoItem.appendChild(MtoTxt);
                    Detalle2.appendChild(MtoItem);
                    ++indLine;
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (inOut.getPOReference() != null && inOut.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = inOut.getPOReference();
                fechareferencia = inOut.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (tipo_Ref > 0) {
                Element Referencia2 = document.createElement("Referencia");
                Documento2.appendChild(Referencia2);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("1");
                NroLinRef.appendChild(Nro);
                Referencia2.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia2.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia2.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia2.appendChild(FchRef);
                String CodRefTxt = null;
                try {
                    CodRefTxt = inOut.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef = document.createElement("CodRef");
                    Text codref = document.createTextNode(inOut.get_ValueAsString("CodRef") == null ? "0" : inOut.get_ValueAsString("CodRef"));
                    CodRef.appendChild(codref);
                    Referencia2.appendChild(CodRef);
                }
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            Documento2.appendChild(Firma);
            Element Observacion = document.createElement("Observacion");
            Text ObservacionTxt = document.createTextNode(inOut.getDescription() == null ? " " : inOut.getDescription());
            Observacion.appendChild(ObservacionTxt);
            Documento2.appendChild(Observacion);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, inOut.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML CG PROVECTIS Generated";
    }
}

