/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import DocumentoDTE.SiiDte.DTEDefType;
import DocumentoDTE.SiiDte.DTEType;
import DocumentoDTE.SiiDte.DTE_Choice;
import DocumentoDTE.SiiDte.Detalle;
import DocumentoDTE.SiiDte.DineroPorcentajeType;
import DocumentoDTE.SiiDte.Documento;
import DocumentoDTE.SiiDte.DscRcgGlobal;
import DocumentoDTE.SiiDte.DscRcgGlobal_TpoMov;
import DocumentoDTE.SiiDte.Emisor;
import DocumentoDTE.SiiDte.Encabezado;
import DocumentoDTE.SiiDte.IdDoc;
import DocumentoDTE.SiiDte.IdDoc_FmaPago;
import DocumentoDTE.SiiDte.MntPagos;
import DocumentoDTE.SiiDte.Receptor;
import DocumentoDTE.SiiDte.Referencia;
import DocumentoDTE.SiiDte.Referencia_CodRef;
import DocumentoDTE.SiiDte.Totales;
import com.liquid_technologies.ltxmllib12.DateTime;
import com.liquid_technologies.ltxmllib12.DateTimeType;
import com.liquid_technologies.ltxmllib12.exceptions.LtException;
import dteboxcliente.ResultadoEnvioDocumento;
import dteboxcliente.Servicio;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.X_C_Province;
import org.compiere.process.DocAction;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ExportDTEInvoiceFOLArtilecGDE
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;
    public String urlPdf = "";

    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = "";
        msg = this.CreateXMLCG(inv);
        return msg;
    }

    public String CreateXMLCG(MInvoice invoice) {
        String error = "";
        String ted = "";
        String pdf417 = "";
        try {
            DocAction refdoc;
            DTEDefType dte = new DTEDefType();
            dte.setDTE_Choice(new DTE_Choice());
            MOrg company = MOrg.get((Properties)invoice.getCtx(), (int)invoice.getAD_Org_ID());
            dte.getDTE_Choice().setDocumento(new Documento());
            Documento doc = dte.getDTE_Choice().getDocumento();
            doc.setEncabezado(new Encabezado());
            IdDoc idDoc = new IdDoc();
            idDoc.setTipoDTE(DTEType.n33);
            idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(invoice.getDocumentNo())));
            Timestamp fchemis = invoice.getDateInvoiced();
            idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateInvoiced())));
            String dateReturn = "";
            dateReturn = this.ConverDateToString(fchemis);
            idDoc.setFmaPago(IdDoc_FmaPago.n1);
            doc.getEncabezado().setIdDoc(idDoc);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS((String)invoice.get_TrxName(), (String)"SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", (Object[])new Object[]{invoice.get_ID()});
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue((String)invoice.get_TrxName(), (String)("SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID()));
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            idDoc.setFchVenc(new DateTime(DateTimeType.date, this.ConverDateToString(fchVencCal)));
            doc.getEncabezado().setIdDoc(idDoc);
            MntPagos mntPago = new MntPagos();
            mntPago.setFchPago(new DateTime(DateTimeType.date, this.ConverDateToString(invoice.getDateInvoiced())));
            mntPago.setMntPago(invoice.getGrandTotal().toBigInteger());
            String GlosaP = DB.getSQLValueString((String)invoice.get_TrxName(), (String)("SELECT MAX(rlt.name)  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID)  WHERE AD_Reference_ID=195  AND rlt.AD_Language='es_MX' AND rl.value = '" + invoice.getPaymentRule() + "'"), (Object[])new Object[0]);
            String GlosaPFull = invoice.getC_PaymentTerm().getName();
            if (GlosaP != null && GlosaP.trim().length() > 0) {
                GlosaPFull = String.valueOf(GlosaPFull) + "-" + GlosaP;
            }
            mntPago.setGlosaPagos(GlosaPFull);
            idDoc.getMntPagos().add(mntPago);
            doc.getEncabezado().setIdDoc(idDoc);
            Emisor emisor = new Emisor();
            emisor.setRUTEmisor("76129486-5");
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            emisor.setRznSoc(nameRzn);
            String giroEmisStr = (String)company.get_Value("Giro");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            emisor.setGiroEmis(giroEmisStr);
            emisor.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)company.get_Value("Acteco"))));
            emisor.setDirOrigen((String)company.get_Value("Address1"));
            emisor.setCmnaOrigen((String)company.get_Value("Comuna"));
            emisor.setCiudadOrigen((String)company.get_Value("City"));
            if (invoice.getSalesRep_ID() > 0) {
                emisor.setCdgVendedor(invoice.getSalesRep().getName());
            }
            doc.getEncabezado().setEmisor(emisor);
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Receptor receptor = new Receptor();
            receptor.setRUTRecep(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            receptor.setRznSocRecep(RznSocRecepStr);
            String dirRecepStr = bloc.get_ValueAsString("Address1");
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setDirRecep(dirRecepStr);
            String CmnaRecepStr = null;
            if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                MCity dCity = new MCity(invoice.getCtx(), bloc.get_ValueAsInt("C_City_ID"), invoice.get_TrxName());
                CmnaRecepStr = dCity.getName();
            }
            receptor.setCmnaRecep(CmnaRecepStr);
            String ciudadTxt = "";
            if (bloc.get_ValueAsInt("C_Province_ID") > 0) {
                X_C_Province prov = new X_C_Province(invoice.getCtx(), bloc.get_ValueAsInt("C_Province_ID"), invoice.get_TrxName());
                ciudadTxt = prov.getName();
            }
            receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
            receptor.setGiroRecep((String)BP.get_Value("Giro"));
            doc.getEncabezado().setReceptor(receptor);
            BigDecimal amountex = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            Totales totales = new Totales();
            totales.setMntTotal(invoice.getGrandTotal().toBigInteger());
            totales.setMntNeto(amountNeto.toBigInteger());
            totales.setMntExe(amountex.toBigInteger());
            if (amountNeto.signum() > 0) {
                totales.setTasaIVA(BigDecimal.valueOf(19L));
            }
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            totales.setIVA(ivaamt.toBigInteger());
            doc.getEncabezado().setTotales(totales);
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            int lineDiscount = 0;
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    String pname;
                    if (iLine.getTaxAmt().compareTo(Env.ZERO) >= 0) {
                        Detalle det = new Detalle();
                        det.setNroLinDet(BigInteger.valueOf(++lineInvoice));
                        pname = "";
                        if (iLine.getProduct() != null) {
                            pname = String.valueOf(iLine.getProduct().getValue()) + "-" + iLine.getProduct().getName();
                            if (iLine.getM_Product().getUPC() != null && iLine.getM_Product().getUPC().trim().length() > 0) {
                                pname = String.valueOf(pname) + iLine.getM_Product().getUPC();
                            }
                        } else {
                            pname = iLine.getC_Charge().getName();
                        }
                        pname = pname.replace("'", "");
                        pname = pname.replace("\"", "");
                        det.setNmbItem(pname);
                        det.setQtyItem(iLine.getQtyInvoiced());
                        det.setPrcItem(iLine.getPriceActual().setScale(0, 4));
                        det.setMontoItem(iLine.getLineNetAmt().setScale(0, 4).toBigInteger());
                        if (iLine.getDescription() != null && iLine.getDescription() != "" && invoice.getC_DocType().getDocBaseType().compareTo("ARC") != 0) {
                            det.setDscItem(iLine.getDescription() == null ? " " : iLine.getDescription());
                        }
                        String unmdItemStr = "";
                        unmdItemStr = iLine.getM_Product_ID() > 0 ? iLine.getM_Product().getC_UOM().getUOMSymbol() : "UN";
                        if (unmdItemStr == null) {
                            unmdItemStr = "UN";
                        }
                        det.setUnmdItem(unmdItemStr);
                        doc.getDetalle().add(det);
                    } else {
                        DscRcgGlobal dscRcgGlobal = new DscRcgGlobal();
                        dscRcgGlobal.setNroLinDR(BigInteger.valueOf(++lineDiscount));
                        dscRcgGlobal.setTpoMov(DscRcgGlobal_TpoMov.D);
                        dscRcgGlobal.setTpoValor(DineroPorcentajeType.Dollar);
                        dscRcgGlobal.setValorDR(iLine.getLineNetAmt().abs().setScale(0, 4));
                        pname = "";
                        if (iLine.getProduct() != null) {
                            pname = String.valueOf(iLine.getProduct().getValue()) + "-" + iLine.getProduct().getName();
                            if (iLine.getM_Product().getUPC() != null && iLine.getM_Product().getUPC().trim().length() > 0) {
                                pname = String.valueOf(pname) + iLine.getM_Product().getUPC();
                            }
                        } else {
                            pname = iLine.getC_Charge().getName();
                        }
                        pname = pname.replace("'", "");
                        pname = pname.replace("\"", "");
                        dscRcgGlobal.setGlosaDR(pname);
                        doc.getDscRcgGlobal().add(dscRcgGlobal);
                    }
                }
                ++i;
            }
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (invoice.get_ValueAsInt("C_RefDoc_ID") > 0) {
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), refdoc.getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getDateInvoiced());
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0 && invoice.getC_DocType().getDocBaseType().compareTo("ARC") != 0) {
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = this.ConverDateToString(invoice.getDateOrdered());
                tipo_Ref = 2;
            }
            if (invoice.get_Value("C_RefInOut_ID") != null && (Integer)invoice.get_Value("C_RefInOut_ID") > 0) {
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = this.ConverDateToString(refdoc.getMovementDate());
                tipo_Ref = 3;
            }
            int indice = 0;
            if (tipo_Ref > 0) {
                ++indice;
                Referencia reference = new Referencia();
                try {
                    reference.setNroLinRef(BigInteger.valueOf(1L));
                    reference.setTpoDocRef(tiporeferencia);
                    reference.setFolioRef(folioreferencia);
                    reference.setFchRef(new DateTime(DateTimeType.date, fechareferencia));
                    reference.setCodRef(Referencia_CodRef.n1);
                    doc.getReferencia().add(reference);
                }
                catch (LtException e) {
                    e.printStackTrace();
                }
            }
            String ambiente = "T";
            String fechaResolucion = "2010-01-01";
            int numeroResolucion = 10;
            int tipoPdf417 = 1;
            String apiURL = "http://200.6.99.206/api/Core.svc/core";
            String apiAuth = "2a84137d-a654-4f46-b873-2be446dadba7";
            Servicio servicio = new Servicio(apiURL, apiAuth);
            ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
            dte.toXml();
            this.log.config("dte " + dte.toXml());
            this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
            if (resultado.getResultadoServicio().getEstado() == 0) {
                ted = resultado.getTED();
                pdf417 = resultado.getPDF417();
            } else {
                error = resultado.getResultadoServicio().getDescripcion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return error;
    }

    public String ConverDateToString(Timestamp fecha) {
        String dateReturn = "";
        this.log.config("month" + fecha.getMonth() + 1);
        this.log.config("day" + fecha.getDate());
        int month = fecha.getMonth() + 1;
        int day = fecha.getDate();
        dateReturn = fecha.getMonth() + 1 < 10 && fecha.getDate() < 10 ? String.valueOf(fecha.getYear() + 1900) + "-0" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : (fecha.getMonth() + 1 < 10 && fecha.getDate() >= 10 ? String.valueOf(fecha.getYear() + 1900) + "-0" + (fecha.getMonth() + 1) + "-" + fecha.getDate() : (fecha.getMonth() + 1 >= 10 && fecha.getDate() < 10 ? String.valueOf(fecha.getYear() + 1900) + "-" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : String.valueOf(fecha.getYear() + 1900) + "-" + (fecha.getMonth() + 1) + "-" + fecha.getDate()));
        return dateReturn;
    }
}

