/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBWarehouseRequest
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBWarehouseRequest.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_Requisition", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)((Object)po)).getC_DocType().getDocBaseType().equals("RRC")) {
            MRequisitionLine[] lines = req.getLines();
            MInventory inv = null;
            MWarehouse wh = MWarehouse.get((Properties)req.getCtx(), (int)req.getM_Warehouse_ID(), (String)req.get_TrxName());
            int i = 0;
            while (i < lines.length) {
                MRequisitionLine line = lines[i];
                if (line.getM_Product_ID() > 0) {
                    if (inv == null) {
                        inv = new MInventory(req.getCtx(), 0, req.get_TrxName());
                        inv.setAD_Org_ID(req.getAD_Org_ID());
                        inv.setM_Warehouse_ID(req.getM_Warehouse_ID());
                        int countdocid = DB.getSQLValue((String)po.get_TrxName(), (String)"SELECT count(1) from c_doctype where  c_doctype_id = 2000115 and docbasetype = 'MMI'");
                        if (countdocid == 1) {
                            inv.setC_DocType_ID(2000115);
                        } else {
                            inv.setC_DocType_ID(1000023);
                        }
                        inv.setDescription("Generado automaticamente desde solicitud " + req.getDocumentNo());
                        inv.save();
                        try {
                            inv.set_CustomColumn("M_Requisition_ID", (Object)req.get_ID());
                            inv.save();
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "No se pudo asignar la variable M_Requisition_ID en M_Inventory", (Throwable)e);
                        }
                    }
                    MInventoryLine il = new MInventoryLine(req.getCtx(), 0, req.get_TrxName());
                    il.setM_Inventory_ID(inv.getM_Inventory_ID());
                    il.setAD_Org_ID(line.getAD_Org_ID());
                    il.setM_Product_ID(line.getM_Product_ID());
                    il.setM_Locator_ID(wh.getDefaultLocator().getM_Locator_ID());
                    il.setQtyInternalUse(line.getQty());
                    int ID_Charge = -1;
                    try {
                        ID_Charge = req.get_ValueAsInt("C_Charge_ID");
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", (Throwable)e);
                        ID_Charge = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID((Properties)po.getCtx())));
                    }
                    if (ID_Charge <= 0) {
                        ID_Charge = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID((Properties)po.getCtx())));
                    }
                    if (ID_Charge > 0) {
                        il.setC_Charge_ID(req.get_ValueAsInt("C_Charge_ID"));
                    } else {
                        il.setC_Charge_ID(2000000);
                    }
                    il.save();
                }
                ++i;
            }
            if (inv != null) {
                try {
                    req.set_CustomColumn("M_Inventory_ID", inv.getM_Inventory_ID());
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", (Throwable)e);
                }
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

