/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModelOFBVoidCash
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBVoidCash.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Cash", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 2 && po.get_Table_ID() == MCash.Table_ID) {
            MCash cash = (MCash)((Object)po);
            MCashLine[] lines = cash.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MCashLine line = lines[i];
                if (line.getC_Payment_ID() > 0 && (line.getC_Payment().getDocStatus().compareTo(DOCSTATUS_Completed) == 0 || line.getC_Payment().getDocStatus().compareTo("CL") == 0)) {
                    return "ERROR: Existe pago completo asociado.";
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

