/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import org.compiere.model.MClient;
import org.compiere.model.MProduction;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.model.X_M_ProductionPlan;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModelOFBUpQtyProduction
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBUpQtyProduction.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_ProductionLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_M_ProductionLine.Table_ID) {
            X_M_ProductionLine line = (X_M_ProductionLine)po;
            try {
                X_M_ProductionPlan pPlan = new X_M_ProductionPlan(po.getCtx(), line.getM_ProductionPlan_ID(), po.get_TrxName());
                MProduction prod = new MProduction(po.getCtx(), pPlan.getM_Production_ID(), po.get_TrxName());
                if (!prod.isProcessed() && line.getMovementQty().compareTo(Env.ZERO) != 0) {
                    line.set_CustomColumn("QtyRef", (Object)line.getMovementQty());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

