/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModelOFBInvoiceRoundValues
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBInvoiceRoundValues.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MInvoiceLine iLine;
        BigDecimal newAmt;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoice inv = (MInvoice)((Object)po);
            MInvoiceLine[] lines = inv.getLines(false);
            int i = 0;
            while (i < lines.length) {
                BigDecimal newAmtTotal;
                MInvoiceLine iLine2 = lines[i];
                BigDecimal newAmt2 = iLine2.getTaxAmt().setScale(iLine2.getC_Invoice().getC_Currency().getStdPrecision(), 6);
                if (newAmt2.compareTo(iLine2.getTaxAmt()) != 0) {
                    DB.executeUpdate((String)("UPDATE C_InvoiceLine SET TaxAmt = " + newAmt2 + " WHERE C_InvoiceLine_ID = " + iLine2.get_ID()), (String)po.get_TrxName());
                }
                if ((newAmtTotal = iLine2.getLineTotalAmt().setScale(iLine2.getC_Invoice().getC_Currency().getStdPrecision(), 6)).compareTo(iLine2.getLineTotalAmt()) != 0) {
                    DB.executeUpdate((String)("UPDATE C_InvoiceLine SET LineTotalAmt = " + newAmtTotal + " WHERE C_InvoiceLine_ID = " + iLine2.get_ID()), (String)po.get_TrxName());
                }
                ++i;
            }
        }
        if (type == 5 && po.get_Table_ID() == MInvoiceLine.Table_ID && (newAmt = (iLine = (MInvoiceLine)((Object)po)).getTaxAmt().setScale(iLine.getC_Invoice().getC_Currency().getStdPrecision(), 6)).compareTo(iLine.getTaxAmt()) != 0) {
            DB.executeUpdate((String)("UPDATE C_InvoiceLine SET TaxAmt = " + newAmt + " WHERE C_InvoiceLine_ID = " + iLine.get_ID()), (String)po.get_TrxName());
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

