/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBAsignacion
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBAsignacion.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_AllocationHdr", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MAllocationLine aLine;
        ResultSet rs;
        CPreparedStatement pstmt2;
        MInvoice inv;
        MAllocationLine line;
        int i;
        BigDecimal sumAmtAllocation;
        BigDecimal amountAlloLine;
        BigDecimal amountinvoice;
        String sql;
        MAllocationLine[] lines;
        MAllocationHdr allo;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MAllocationHdr.Table_ID) {
            allo = (MAllocationHdr)((Object)po);
            lines = allo.getLines(false);
            sql = "SELECT C_AllocationLine_ID FROM C_AllocationLine al INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID = a.C_AllocationHdr_ID)  WHERE a.DocStatus IN ('CO','CL') AND al.C_Invoice_ID =?";
            amountinvoice = Env.ZERO;
            amountAlloLine = Env.ZERO;
            sumAmtAllocation = Env.ZERO;
            i = 0;
            while (i < lines.length) {
                amountinvoice = Env.ZERO;
                sumAmtAllocation = Env.ZERO;
                amountAlloLine = Env.ZERO;
                line = lines[i];
                if (line.getC_Invoice_ID() > 0) {
                    inv = new MInvoice(po.getCtx(), line.getC_Invoice_ID(), po.get_TrxName());
                    amountinvoice = inv.getC_Currency_ID() != 228 ? MConversionRate.convert(po.getCtx(), inv.getGrandTotal(), inv.getC_Currency_ID(), 228, inv.getDateAcct(), inv.getC_ConversionType_ID(), inv.getAD_Client_ID(), inv.getAD_Org_ID()) : inv.getGrandTotal();
                    try {
                        pstmt2 = DB.prepareStatement((String)sql, null);
                        pstmt2.setInt(1, inv.get_ID());
                        rs = pstmt2.executeQuery();
                        while (rs.next()) {
                            aLine = new MAllocationLine(po.getCtx(), rs.getInt("C_AllocationLine_ID"), po.get_TrxName());
                            amountAlloLine = aLine.getC_AllocationHdr().getC_Currency_ID() != 228 ? MConversionRate.convert(po.getCtx(), aLine.getAmount(), aLine.getC_AllocationHdr().getC_Currency_ID(), 228, aLine.getC_AllocationHdr().getDateAcct(), inv.getC_ConversionType_ID(), aLine.getAD_Client_ID(), aLine.getAD_Org_ID()) : aLine.getAmount();
                            sumAmtAllocation = amountAlloLine;
                        }
                        if (sumAmtAllocation.abs().compareTo(amountinvoice.abs()) >= 0) {
                            inv.setIsPaid(true);
                            inv.saveEx(po.get_TrxName());
                        }
                    }
                    catch (Exception pstmt2) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if (timing == 10 && po.get_Table_ID() == MAllocationHdr.Table_ID) {
            allo = (MAllocationHdr)((Object)po);
            lines = allo.getLines(false);
            sql = "SELECT C_AllocationLine_ID FROM C_AllocationLine al INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID = a.C_AllocationHdr_ID)  WHERE a.DocStatus IN ('CO','CL') AND al.C_Invoice_ID =?";
            amountinvoice = Env.ZERO;
            amountAlloLine = Env.ZERO;
            sumAmtAllocation = Env.ZERO;
            i = 0;
            while (i < lines.length) {
                amountinvoice = Env.ZERO;
                sumAmtAllocation = Env.ZERO;
                amountAlloLine = Env.ZERO;
                line = lines[i];
                if (line.getC_Invoice_ID() > 0) {
                    inv = new MInvoice(po.getCtx(), line.getC_Invoice_ID(), po.get_TrxName());
                    amountinvoice = inv.getC_Currency_ID() != 228 ? MConversionRate.convert(po.getCtx(), inv.getGrandTotal(), inv.getC_Currency_ID(), 228, inv.getDateAcct(), inv.getC_ConversionType_ID(), inv.getAD_Client_ID(), inv.getAD_Org_ID()) : inv.getGrandTotal();
                    try {
                        pstmt2 = DB.prepareStatement((String)sql, null);
                        pstmt2.setInt(1, inv.get_ID());
                        rs = pstmt2.executeQuery();
                        while (rs.next()) {
                            aLine = new MAllocationLine(po.getCtx(), rs.getInt("C_AllocationLine_ID"), po.get_TrxName());
                            amountAlloLine = aLine.getC_AllocationHdr().getC_Currency_ID() != 228 ? MConversionRate.convert(po.getCtx(), aLine.getAmount(), aLine.getC_AllocationHdr().getC_Currency_ID(), 228, aLine.getC_AllocationHdr().getDateAcct(), inv.getC_ConversionType_ID(), aLine.getAD_Client_ID(), aLine.getAD_Org_ID()) : aLine.getAmount();
                            sumAmtAllocation = amountAlloLine;
                        }
                        if (sumAmtAllocation.abs().compareTo(amountinvoice.abs()) < 0) {
                            inv.setIsPaid(false);
                            inv.saveEx(po.get_TrxName());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

