/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.acct.FactLine;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBAcctAllocation
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBAcctAllocation.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("Fact_Acct", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        FactLine fLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4) && po.get_Table_ID() == FactLine.Table_ID && (fLine = (FactLine)((Object)po)).getAD_Table_ID() == MAllocationHdr.Table_ID) {
            String sqlTo = "SELECT IntercompanyDueTo_Acct FROM C_AcctSchema_GL WHERE C_AcctSchema_ID=?";
            String sqlFrom = "SELECT IntercompanyDueFrom_Acct FROM C_AcctSchema_GL WHERE C_AcctSchema_ID=?";
            int ID_CombTo = DB.getSQLValue((String)fLine.get_TrxName(), (String)sqlTo, (int)MClientInfo.get((Properties)fLine.getCtx(), (int)fLine.getAD_Client_ID()).getC_AcctSchema1_ID());
            int ID_CombFrom = DB.getSQLValue((String)fLine.get_TrxName(), (String)sqlFrom, (int)MClientInfo.get((Properties)fLine.getCtx(), (int)fLine.getAD_Client_ID()).getC_AcctSchema1_ID());
            int ID_acctTo = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT account_id FROM c_validcombination where c_validcombination_id = " + ID_CombTo));
            int ID_acctFrom = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT account_id FROM c_validcombination where c_validcombination_id = " + ID_CombFrom));
            if (fLine.getAccount_ID() == ID_acctTo || fLine.getAccount_ID() == ID_acctFrom) {
                if (fLine.getAmtAcctDr().compareTo(Env.ZERO) > 0) {
                    BigDecimal sum = DB.getSQLValueBD((String)fLine.get_TrxName(), (String)("SELECT SUM(AmtAcctDr) FROM Fact_Acct WHERE Record_ID=" + fLine.getRecord_ID() + " AND AD_Table_ID=" + fLine.getAD_Table_ID() + " AND Account_id NOT IN (" + ID_acctTo + "," + ID_acctFrom + ")"), (Object[])new Object[0]);
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctDr=" + sum + ", AmtSourceDr=" + sum + " WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                } else if (fLine.getAmtAcctCr().compareTo(Env.ZERO) > 0) {
                    BigDecimal sum = DB.getSQLValueBD((String)fLine.get_TrxName(), (String)("SELECT SUM(AmtAcctCr) FROM Fact_Acct WHERE Record_ID=" + fLine.getRecord_ID() + " AND AD_Table_ID=" + fLine.getAD_Table_ID() + " AND Account_id NOT IN (" + ID_acctTo + "," + ID_acctFrom + ")"), (Object[])new Object[0]);
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET AmtAcctCr=" + sum + ", AmtSourceDr=" + sum + " WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

