/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModCopiaCamposInventory
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCopiaCamposInventory.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_InventoryLine", (ModelValidator)this);
        engine.addModelChange("M_Inventory", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == MInventoryLine.Table_ID) {
            MInventoryLine mml = (MInventoryLine)po;
            try {
                BigDecimal qtyCount = mml.getQtyCount();
                if (qtyCount != null) {
                    DB.executeUpdate((String)("UPDATE M_InventoryLine SET QtySuggested=" + qtyCount + ",QtyReal=" + qtyCount + " " + " WHERE M_InventoryLine_ID = " + mml.get_ID()), (String)po.get_TrxName());
                }
            }
            catch (Exception e) {
                log.severe("" + e);
            }
        }
        if (type == 2 && po.get_Table_ID() == MInventory.Table_ID && po.is_ValueChanged("Procesar")) {
            MInventory inv = (MInventory)po;
            int id_role = Env.getAD_Role_ID((Properties)po.getCtx());
            String msg = "";
            if (inv.getDocStatus().compareToIgnoreCase("DR") == 0) {
                DB.executeUpdate((String)("UPDATE M_Inventory SET DocStatus='L1' WHERE M_Inventory_ID = " + inv.get_ID()), (String)po.get_TrxName());
                msg = "Procesado";
            } else if (inv.getDocStatus().compareToIgnoreCase("L1") == 0) {
                if (id_role != 1000022 && id_role != 1000021 && id_role != 1000012) {
                    return "Rol sin privilegios suficientes";
                }
                DB.executeUpdate((String)("UPDATE M_Inventory SET DocStatus='L2' WHERE M_Inventory_ID = " + inv.get_ID()), (String)po.get_TrxName());
                msg = "Procesado";
            } else if (inv.getDocStatus().compareToIgnoreCase("L2") == 0) {
                if (id_role != 1000021 && id_role != 1000012) {
                    return "Rol sin privilegios suficientes";
                }
                DB.executeUpdate((String)("UPDATE M_Inventory SET DocStatus='L3' WHERE M_Inventory_ID = " + inv.get_ID()), (String)po.get_TrxName());
                msg = "Procesado";
            } else if (inv.getDocStatus().compareToIgnoreCase("L3") == 0) {
                if (id_role != 1000012) {
                    return "Rol sin privilegios suficientes";
                }
                int idReqRe = 0;
                try {
                    idReqRe = inv.get_ValueAsInt("M_Requisition_ID");
                }
                catch (Exception e) {
                    log.severe("No se pudo setear campo M_Requisition_ID");
                    idReqRe = 0;
                }
                if (idReqRe > 0) {
                    msg = "Procesado. Solicitud ya relacionada ";
                } else {
                    MRequisition req = new MRequisition(po.getCtx(), 0, po.get_TrxName());
                    int idDocType = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(C_DocType_ID) FROM C_DocType WHERE docbasetype = 'POR'  AND IsActive = 'Y' AND AD_Client_ID = " + inv.getAD_Client_ID()));
                    if (idDocType > 0) {
                        req.setC_DocType_ID(idDocType);
                    } else {
                        req.setC_DocType_ID(1000018);
                    }
                    req.setAD_Org_ID(inv.getAD_Org_ID());
                    int idPriceList = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(M_PriceList_ID) FROM M_PriceList WHERE IsActive = 'Y' AND issopricelist = 'N' AND isdefault = 'Y' AND AD_Client_ID = " + inv.getAD_Client_ID()));
                    if (idPriceList > 0) {
                        req.setM_PriceList_ID(idPriceList);
                    } else {
                        req.setC_DocType_ID(1000001);
                    }
                    int idUser = 0;
                    try {
                        idUser = inv.get_ValueAsInt("AD_User_ID");
                    }
                    catch (Exception e) {
                        log.severe("No se pudo setear variable AD_User_ID");
                        idUser = 0;
                    }
                    if (idUser > 0) {
                        req.setAD_User_ID(idUser);
                    } else {
                        req.setAD_User_ID(100);
                    }
                    req.setM_Warehouse_ID(inv.getM_Warehouse_ID());
                    req.save();
                    MInventoryLine[] invLines = inv.getLines(false);
                    int i = 0;
                    while (i < invLines.length) {
                        MInventoryLine iLine = invLines[i];
                        MRequisitionLine reqLine = new MRequisitionLine(req);
                        reqLine.setAD_Org_ID(req.getAD_Org_ID());
                        reqLine.setM_Product_ID(iLine.getM_Product_ID());
                        BigDecimal qtyReal = (BigDecimal)iLine.get_Value("qtyReal");
                        reqLine.setQty(qtyReal);
                        reqLine.save();
                        try {
                            reqLine.set_CustomColumn("M_InventoryLine_ID", (Object)iLine.get_ID());
                            reqLine.save();
                        }
                        catch (Exception e) {
                            log.severe("No se pudo setear campo M_InventoryLine_ID");
                        }
                        ++i;
                    }
                    DB.executeUpdate((String)("UPDATE M_Inventory SET M_requisition_ID=" + req.get_ID() + " WHERE M_Inventory_ID = " + inv.get_ID()), (String)po.get_TrxName());
                    msg = "Procesado. Solicitud Creada";
                }
                DB.executeUpdate((String)("UPDATE M_Inventory SET DocStatus='CO',Processed='Y' WHERE M_Inventory_ID = " + inv.get_ID()), (String)po.get_TrxName());
            }
            DB.executeUpdate((String)("UPDATE M_Inventory SET Procesar='N' WHERE M_Inventory_ID = " + inv.get_ID()), (String)po.get_TrxName());
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

