/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProject;
import org.compiere.model.X_DM_Document;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutDMDocument
extends CalloutEngine {
    public String ProjectAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int Pj_ID = (Integer)mTab.getValue("C_Project_ID");
        String type = (String)mTab.getValue("DM_DocumentType");
        if (type.equals("PM") || type.equals("02")) {
            MProject pj = new MProject(ctx, Pj_ID, null);
            mTab.setValue("Amt", (Object)pj.getCommittedAmt());
        }
        return "";
    }

    public String AsignacionAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int As_ID = (Integer)mTab.getValue("DM_DocumentRef_ID");
        X_DM_Document As = new X_DM_Document(ctx, As_ID, null);
        mTab.setValue("Amt", (Object)As.getAmt());
        return "";
    }

    public String ProjectSchedule(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int cc_ID = (Integer)value;
        BigDecimal amt = new BigDecimal("0.0");
        amt = DB.getSQLValueBD(null, (String)"select SUM(Amt) from PM_ProjectPay where c_projectschedule_id = ? ", (int)cc_ID);
        mTab.setValue("PayAmt", (Object)amt);
        int document_id = DB.getSQLValue(null, (String)"select DM_Document_ID from C_ProjectSchedule where c_projectschedule_id = ?", (int)cc_ID);
        if (document_id > 0) {
            int bp_id = DB.getSQLValue(null, (String)"select c_bpartnerp_id from DM_Document where DM_Document_id = ?", (int)document_id);
            if (bp_id > 0) {
                mTab.setValue("C_BPartner_ID", (Object)bp_id);
            }
            X_DM_Document com = new X_DM_Document(ctx, document_id, null);
            mTab.setValue("AcumAnticipo", (Object)((BigDecimal)com.get_Value("AcumAnticipo")));
            mTab.setValue("AcumRetencion", (Object)((BigDecimal)com.get_Value("AcumRetencion")));
            mTab.setValue("AcumReajusteO", (Object)((BigDecimal)com.get_Value("AcumReajusteO")));
            mTab.setValue("AcumReajusteA", (Object)((BigDecimal)com.get_Value("AcumReajusteA")));
            mTab.setValue("AcumDevR", (Object)((BigDecimal)com.get_Value("AcumDevR")));
            mTab.setValue("AcumDevA", (Object)((BigDecimal)com.get_Value("AcumDevA")));
            mTab.setValue("AcumMultas", (Object)((BigDecimal)com.get_Value("AcumMultas")));
            mTab.setValue("AcumOtrasR", (Object)((BigDecimal)com.get_Value("AcumOtrasR")));
            mTab.setValue("AcumDevOtrR", (Object)((BigDecimal)com.get_Value("AcumDevOtrR")));
            mTab.setValue("AmtDate", (Object)((BigDecimal)com.get_Value("AmtDate")));
            mTab.setValue("DM_DocumentC", (Object)document_id);
        }
        return "";
    }

    public String PayTypeAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        BigDecimal amt = (BigDecimal)value;
        String payType = (String)mTab.getValue("Pay_Type");
        if ((payType.startsWith("D") || payType.startsWith("R")) && amt.signum() > 0) {
            mTab.setValue("Amt", (Object)Env.ZERO);
            mTab.fireDataStatusEEvent("Error", "el monto debe ser negativo", false);
        }
        return "";
    }

    public String ProjectInvoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Integer C_Invoice_ID = (Integer)value;
        String sql = "SELECT  invoiceOpen(C_Invoice_ID, null) FROM C_Invoice WHERE C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Invoice_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("Amt", (Object)rs.getBigDecimal(1));
                    String sqldbt = "select docbasetype from C_DocType cdt inner join C_Invoice ci on (ci.C_DocType_ID = cdt.C_DocType_ID) where ci.C_Invoice_ID = ?";
                    String dtB = DB.getSQLValueString(null, (String)sqldbt, (int)C_Invoice_ID);
                    if (dtB.equals("APB")) {
                        String sqlbh = "select coalesce(sum(abs(taxamt)),0) from C_InvoiceTax where C_Invoice_ID=? and C_Tax_ID=1000002";
                        BigDecimal montoBH = DB.getSQLValueBD(null, (String)sqlbh, (int)C_Invoice_ID);
                        mTab.setValue("ReferenceAmount", (Object)montoBH);
                    } else {
                        mTab.setValue("ReferenceAmount", (Object)new BigDecimal("0.0"));
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return "";
    }

    public String ProjectDM_Document(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Integer DM_Document_ID = (Integer)value;
        X_DM_Document doc = new X_DM_Document(ctx, DM_Document_ID, null);
        mTab.setValue("Amt", (Object)doc.getAmt());
        return "";
    }

    public String Signature1(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        boolean Signature = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
        if (Signature) {
            int UserID;
            if (mTab.getValue("UpdatedBySignature1") == null) {
                UserID = 0;
            } else {
                String user = mTab.getValue("UpdatedBySignature1").toString();
                UserID = Integer.parseInt(user);
            }
            if (UserID > 0) {
                mTab.setValue("UpdatedBySignature1Ref_ID", (Object)Env.getAD_User_ID((Properties)Env.getCtx()));
            } else {
                mTab.setValue("UpdatedBySignature1", (Object)Env.getAD_User_ID((Properties)Env.getCtx()));
            }
            mTab.setValue("UpdatedSignature1", (Object)new Timestamp(System.currentTimeMillis()));
        }
        return "";
    }

    public String Signature2(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        boolean Signature = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
        if (Signature) {
            mTab.setValue("UpdatedSignature2", (Object)new Timestamp(System.currentTimeMillis()));
            mTab.setValue("UpdatedBySignature2", (Object)Env.getAD_User_ID((Properties)Env.getCtx()));
        }
        return "";
    }

    public String Signature3(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        boolean Signature = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
        if (Signature) {
            mTab.setValue("UpdatedSignature3", (Object)new Timestamp(System.currentTimeMillis()));
            mTab.setValue("UpdatedBySignature3", (Object)Env.getAD_User_ID((Properties)Env.getCtx()));
        }
        return "";
    }

    public String Signature4(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        boolean Signature = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
        if (Signature) {
            mTab.setValue("UpdatedSignature4", (Object)new Timestamp(System.currentTimeMillis()));
            mTab.setValue("UpdatedBySignature4", (Object)Env.getAD_User_ID((Properties)Env.getCtx()));
        }
        return "";
    }

    public String EndDateCompromiso02(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        if (mTab.get_ValueAsString("DM_DocumentType").equals("02")) {
            Calendar startCal = Calendar.getInstance();
            Date fi = (Date)mTab.getValue("DateStart");
            BigDecimal qtyDays = (BigDecimal)mTab.getValue("NumberDays");
            int qty = qtyDays.intValue();
            startCal.setTime(fi);
            startCal.add(5, qty);
            Date ff = startCal.getTime();
            Timestamp cff = new Timestamp(ff.getTime());
            mTab.setValue("DateEnd", (Object)cff);
        }
        return "";
    }
}

