/*
 * Decompiled with CFR 0.152.
 */
package org.mop.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAsset;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.X_A_Asset_Use;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessCreateAssetOld
extends SvrProcess {
    private int p_ID_Invoice = 0;

    protected void prepare() {
        this.p_ID_Invoice = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_ID_Invoice > 0) {
            MInvoice inv = new MInvoice(this.getCtx(), this.p_ID_Invoice, this.get_TrxName());
            MDocType dType = new MDocType(this.getCtx(), inv.getC_DocTypeTarget_ID(), this.get_TrxName());
            if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("ALT") == 0) {
                this.createAsset(inv, dType);
                inv.setDocStatus("CO");
                inv.setProcessed(true);
            } else if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("TRA") == 0) {
                this.transferAsset(inv, dType);
                inv.setDocStatus("CO");
                inv.setProcessed(true);
            } else if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("MOD") == 0) {
                this.updateAsset(inv, dType);
                inv.setDocStatus("CO");
                inv.setProcessed(true);
            } else if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("BAJ") == 0 && dType.get_ID() == 2000159) {
                inv.setDocStatus("IP");
            } else if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("BAJ") == 0) {
                this.degradeAsset(inv, dType);
                inv.setDocStatus("CO");
                inv.setProcessed(true);
            } else if (inv.getDocStatus().compareTo("IP") == 0 && dType.get_ValueAsString("Type1").compareTo("BAJ") == 0) {
                this.degradeAsset(inv, dType);
                inv.setDocStatus("CO");
                inv.setProcessed(true);
            }
            inv.saveEx();
        }
        return "Procesado";
    }

    public void createAsset(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int group_ID = 0;
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (this.isAsset(iLine) && iLine.isActive() && iLine.get_ValueAsString("A_CapvsExp").equals("Cap")) {
                group_ID = iLine.get_ValueAsInt("A_Asset_Group_Ref2_ID");
                if (group_ID <= 0 && (group_ID = DB.getSQLValue((String)inv.get_TrxName(), (String)"select a_asset_group_id from a_asset_group where isdefault='Y'")) <= 0) {
                    throw new AdempiereException("no default asset group. Linea:" + iLine.getLine() / 10);
                }
                DB.executeUpdate((String)("UPDATE C_InvoiceLine SET A_Asset_Group_ID = " + group_ID + " WHERE C_InvoiceLine_ID = " + iLine.get_ID()), (String)this.get_TrxName());
                BigDecimal qtyAsset = iLine.getQtyEntered();
                MAsset asset = new MAsset(inv.getCtx(), 0, inv.get_TrxName());
                asset.setName(iLine.getDescription());
                asset.setAD_Org_ID(iLine.getAD_Org_ID());
                asset.setAssetServiceDate(inv.getDateInvoiced());
                asset.setQty(qtyAsset);
                asset.setA_Asset_Group_ID(group_ID);
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    asset.setAD_User_ID(iLine.get_ValueAsInt("AD_user_ID"));
                }
                asset.set_CustomColumn("Brand", iLine.get_ValueAsString("Brand"));
                asset.set_CustomColumn("Model", iLine.get_ValueAsString("Model"));
                asset.set_CustomColumn("SerNo", iLine.get_ValueAsString("SerNo"));
                asset.set_CustomColumn("Color", iLine.get_ValueAsString("Color"));
                if (iLine.get_ValueAsString("AssetStatus") != null && iLine.get_ValueAsString("AssetStatus").trim().length() > 0) {
                    asset.set_CustomColumn("AssetStatus", iLine.get_ValueAsString("AssetStatus"));
                }
                asset.set_CustomColumn("A_Parent_Asset_ID", iLine.get_ValueAsInt("A_Parent_Asset_ID"));
                if (iLine.get_ValueAsString("Type1") != null && iLine.get_ValueAsString("Type1").trim().length() > 0) {
                    asset.set_CustomColumn("Type1", iLine.get_ValueAsString("Type1"));
                }
                asset.set_CustomColumn("Rol", iLine.get_ValueAsString("Rol"));
                asset.set_CustomColumn("GroundSurface", (BigDecimal)iLine.get_Value("GroundSurface"));
                asset.set_CustomColumn("EdificationSurface", (BigDecimal)iLine.get_Value("EdificationSurface"));
                asset.set_CustomColumn("Engine", iLine.get_ValueAsString("Engine"));
                asset.set_CustomColumn("Chassis", iLine.get_ValueAsString("Chassis"));
                asset.set_CustomColumn("LicensePlate", iLine.get_ValueAsString("LicensePlate"));
                asset.set_CustomColumn("Digito", iLine.get_ValueAsString("Digito"));
                asset.set_CustomColumn("Sigla", iLine.get_ValueAsString("Sigla"));
                asset.set_CustomColumn("Fojas", iLine.get_ValueAsString("Fojas"));
                asset.set_CustomColumn("RegistrationNumber", iLine.get_ValueAsString("RegistrationNumber"));
                asset.set_CustomColumn("Year", iLine.get_ValueAsString("Year"));
                asset.set_CustomColumn("Inmueble", iLine.get_ValueAsString("Inmueble"));
                if (iLine.get_ValueAsInt("C_Region_ID") > 0) {
                    asset.set_CustomColumn("C_Region_ID", iLine.get_ValueAsInt("C_Region_ID"));
                }
                if (iLine.get_ValueAsInt("C_Province_ID") > 0) {
                    asset.set_CustomColumn("C_Province_ID", iLine.get_ValueAsInt("C_Province_ID"));
                }
                if (iLine.get_ValueAsInt("C_City_ID") > 0) {
                    asset.set_CustomColumn("C_City_ID", iLine.get_ValueAsString("C_City_ID"));
                }
                if (iLine.get_ValueAsString("DocDestination") != null && iLine.get_ValueAsString("DocDestination").trim().length() > 0) {
                    asset.set_CustomColumn("DocDestination", iLine.get_ValueAsString("DocDestination"));
                }
                asset.set_CustomColumn("DocNumber", iLine.get_ValueAsString("DocNumber"));
                asset.set_CustomColumn("Conservador", iLine.get_ValueAsString("Conservador"));
                asset.set_CustomColumn("Notaria", iLine.get_ValueAsString("Notaria"));
                asset.set_CustomColumn("N_Fecha_ValeVista", iLine.get_ValueAsString("N_Fecha_ValeVista"));
                asset.set_CustomColumn("Vlr_ValeVista", (BigDecimal)iLine.get_Value("Vlr_ValeVista"));
                asset.set_CustomColumn("Fecha_Subasta", (Timestamp)iLine.get_Value("Fecha_Subasta"));
                asset.set_CustomColumn("Vlr_Subasta", (BigDecimal)iLine.get_Value("Vlr_Subasta"));
                asset.set_CustomColumn("Lot", iLine.get_ValueAsString("Lot"));
                asset.set_CustomColumn("Martillero", iLine.get_ValueAsString("Martillero"));
                asset.set_CustomColumn("ParentAsset", iLine.get_ValueAsString("ParentAsset"));
                if (iLine.get_ValueAsInt("A_Asset_Group_Ref_ID") > 0) {
                    asset.set_CustomColumn("A_Asset_Group_Ref_ID", iLine.get_ValueAsInt("A_Asset_Group_Ref_ID"));
                }
                if (dType.get_ID() == 2000158) {
                    asset.set_CustomColumn("AssetSituation", "COM");
                } else {
                    asset.set_CustomColumn("AssetSituation", "ALT");
                }
                asset.set_CustomColumn("GrandTotal", iLine.getLineTotalAmt());
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    asset.set_CustomColumn("S_Resource_ID", iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    asset.set_CustomColumn("S_ResourceRef_ID", iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                asset.saveEx();
                iLine.set_CustomColumn("A_Asset_ID", asset.getA_Asset_ID());
                iLine.save();
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                assetuse.setDescription("ALTA DE ACTIVO");
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                assetuse.save();
            }
            ++lineIndex;
        }
    }

    private boolean isAsset(MInvoiceLine sLine) {
        if (sLine.getC_Charge_ID() > 0 && sLine.getC_Charge().getC_ChargeType_ID() > 0 && sLine.getC_Charge().getC_ChargeType().getValue().equals("TCAF")) {
            return true;
        }
        return sLine.getM_Product_ID() > 0 && sLine.getM_Product().getM_Product_Category().getA_Asset_Group_ID() > 0;
    }

    public void degradeAsset(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (iLine.getA_Asset_ID() > 0 && iLine.isActive()) {
                MAsset asset = new MAsset(this.getCtx(), iLine.getA_Asset_ID(), this.get_TrxName());
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                assetuse.setDescription("BAJA DE ACTIVO");
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                assetuse.save();
                asset.set_CustomColumn("AssetSituation", "BAJ");
                asset.set_CustomColumn("GrandTotal", Env.ONE);
                asset.saveEx();
            }
            ++lineIndex;
        }
    }

    public void transferAsset(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (iLine.getA_Asset_ID() > 0 && iLine.isActive()) {
                MAsset asset = new MAsset(this.getCtx(), iLine.getA_Asset_ID(), this.get_TrxName());
                asset.setAD_Org_ID(iLine.getAD_Org_ID());
                asset.setAD_User_ID(iLine.get_ValueAsInt("AD_User_ID"));
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    asset.set_CustomColumn("S_Resource_ID", iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    asset.set_CustomColumn("S_ResourceRef_ID", iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                asset.saveEx(this.get_TrxName());
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                assetuse.setDescription("TRASPASO DE ACTIVO");
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                assetuse.save();
            }
            ++lineIndex;
        }
    }

    public void updateAsset(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (iLine.getA_Asset_ID() > 0 && iLine.isActive()) {
                BigDecimal amtDiff;
                MAsset asset = new MAsset(this.getCtx(), iLine.getA_Asset_ID(), this.get_TrxName());
                asset.setName(iLine.getDescription());
                asset.setAD_Org_ID(iLine.getAD_Org_ID());
                if (dType.get_ID() == 2000167) {
                    amtDiff = (BigDecimal)iLine.get_Value("PriceEffective");
                    if (amtDiff == null) {
                        amtDiff = Env.ZERO;
                    }
                    if (amtDiff.compareTo(Env.ZERO) != 0) {
                        asset.set_CustomColumn("GrandTotal", iLine.getPriceEntered().add(amtDiff));
                        asset.saveEx();
                    }
                } else if (dType.get_ID() == 2000168) {
                    amtDiff = (BigDecimal)iLine.get_Value("PriceEffective");
                    if (amtDiff == null) {
                        amtDiff = Env.ZERO;
                    }
                    if (amtDiff.compareTo(Env.ZERO) != 0) {
                        asset.set_CustomColumn("GrandTotal", iLine.getPriceEntered().subtract(amtDiff));
                        asset.saveEx();
                    }
                } else {
                    if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                        asset.setAD_User_ID(iLine.get_ValueAsInt("AD_user_ID"));
                    }
                    asset.set_CustomColumn("Brand", iLine.get_ValueAsString("Brand"));
                    asset.set_CustomColumn("Model", iLine.get_ValueAsString("Model"));
                    asset.set_CustomColumn("SerNo", iLine.get_ValueAsString("SerNo"));
                    asset.set_CustomColumn("Color", iLine.get_ValueAsString("Color"));
                    if (iLine.get_ValueAsString("AssetStatus") != null && iLine.get_ValueAsString("AssetStatus").trim().length() > 0) {
                        asset.set_CustomColumn("AssetStatus", iLine.get_ValueAsString("AssetStatus"));
                    }
                    asset.set_CustomColumn("A_Parent_Asset_ID", iLine.get_ValueAsInt("A_Parent_Asset_ID"));
                    if (iLine.get_ValueAsString("Type1") != null && iLine.get_ValueAsString("Type1").trim().length() > 0) {
                        asset.set_CustomColumn("Type1", iLine.get_ValueAsString("Type1"));
                    }
                    asset.set_CustomColumn("Rol", iLine.get_ValueAsString("Rol"));
                    asset.set_CustomColumn("GroundSurface", (BigDecimal)iLine.get_Value("GroundSurface"));
                    asset.set_CustomColumn("EdificationSurface", (BigDecimal)iLine.get_Value("EdificationSurface"));
                    asset.set_CustomColumn("Engine", iLine.get_ValueAsString("Engine"));
                    asset.set_CustomColumn("Chassis", iLine.get_ValueAsString("Chassis"));
                    asset.set_CustomColumn("LicensePlate", iLine.get_ValueAsString("LicensePlate"));
                    asset.set_CustomColumn("Digito", iLine.get_ValueAsString("Digito"));
                    asset.set_CustomColumn("Sigla", iLine.get_ValueAsString("Sigla"));
                    asset.set_CustomColumn("Fojas", iLine.get_ValueAsString("Fojas"));
                    asset.set_CustomColumn("RegistrationNumber", iLine.get_ValueAsString("RegistrationNumber"));
                    asset.set_CustomColumn("Year", iLine.get_ValueAsString("Year"));
                    asset.set_CustomColumn("Inmueble", iLine.get_ValueAsString("Inmueble"));
                    if (iLine.get_ValueAsInt("C_Region_ID") > 0) {
                        asset.set_CustomColumn("C_Region_ID", iLine.get_ValueAsInt("C_Region_ID"));
                    }
                    if (iLine.get_ValueAsInt("C_Province_ID") > 0) {
                        asset.set_CustomColumn("C_Province_ID", iLine.get_ValueAsInt("C_Province_ID"));
                    }
                    if (iLine.get_ValueAsInt("C_City_ID") > 0) {
                        asset.set_CustomColumn("C_City_ID", iLine.get_ValueAsString("C_City_ID"));
                    }
                    if (iLine.get_ValueAsString("DocDestination") != null && iLine.get_ValueAsString("DocDestination").trim().length() > 0) {
                        asset.set_CustomColumn("DocDestination", iLine.get_ValueAsString("DocDestination"));
                    }
                    asset.set_CustomColumn("DocNumber", iLine.get_ValueAsString("DocNumber"));
                    asset.set_CustomColumn("Conservador", iLine.get_ValueAsString("Conservador"));
                    asset.set_CustomColumn("Notaria", iLine.get_ValueAsString("Notaria"));
                    asset.set_CustomColumn("N_Fecha_ValeVista", iLine.get_ValueAsString("N_Fecha_ValeVista"));
                    asset.set_CustomColumn("Vlr_ValeVista", (BigDecimal)iLine.get_Value("Vlr_ValeVista"));
                    asset.set_CustomColumn("Fecha_Subasta", (Timestamp)iLine.get_Value("Fecha_Subasta"));
                    asset.set_CustomColumn("Vlr_Subasta", (BigDecimal)iLine.get_Value("Vlr_Subasta"));
                    asset.set_CustomColumn("Lot", iLine.get_ValueAsString("Lot"));
                    asset.set_CustomColumn("Martillero", iLine.get_ValueAsString("Martillero"));
                    asset.set_CustomColumn("DocNumber2", iLine.get_ValueAsString("DocNumber2"));
                    asset.set_CustomColumn("ParentAsset", iLine.get_ValueAsString("ParentAsset"));
                    if (iLine.get_ValueAsInt("A_Asset_Group_Ref_ID") > 0) {
                        asset.set_CustomColumn("A_Asset_Group_Ref_ID", iLine.get_ValueAsInt("A_Asset_Group_Ref_ID"));
                    }
                    if (dType.get_ID() == 2000169) {
                        asset.set_CustomColumn("AssetSituation", "ALT");
                        int ID_ILine = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT C_InvoiceLine_ID FROM C_InvoiceLine cil  INNER JOIN C_Invoice ci ON (cil.C_Invoice_ID = ci.C_Invoice_ID) WHERE cil.C_InvoiceLine_ID <> " + iLine.get_ID() + " AND cil.A_Asset_ID = ? AND PriceEntered > 1 " + " ORDER BY DateInvoiced DESC, cil.created DESC"), (int)asset.get_ID());
                        if (ID_ILine > 0) {
                            MInvoiceLine iLineOld = new MInvoiceLine(this.getCtx(), ID_ILine, this.get_TrxName());
                            asset.set_CustomColumn("GrandTotal", iLineOld.getPriceEntered());
                        }
                    } else if (iLine.get_ValueAsString("AssetSituation") != null && iLine.get_ValueAsString("AssetSituation").trim().length() > 0) {
                        asset.set_CustomColumn("AssetSituation", iLine.get_ValueAsString("AssetSituation"));
                    }
                    asset.saveEx();
                }
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                assetuse.setDescription("MODIFICACI\u00d3N DE ACTIVO");
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                assetuse.save();
            }
            ++lineIndex;
        }
    }
}

