/*
 * Decompiled with CFR 0.152.
 */
package org.mop.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MAsset;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class ModMOPInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMOPInvoice.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (!(type != 1 && type != 2 || po.get_Table_ID() != MInvoice.Table_ID || (inv = (MInvoice)((Object)po)).getDocStatus().compareTo("DR") != 0 && inv.getDocStatus().compareTo("IN") != 0 && inv.getDocStatus().compareTo("IP") != 0)) {
            Calendar calInv = Calendar.getInstance();
            calInv.setTimeInMillis(inv.getDateInvoiced().getTime());
            calInv.set(11, 0);
            calInv.set(12, 0);
            calInv.set(13, 0);
            calInv.set(14, 0);
            Timestamp timeInv = new Timestamp(calInv.getTimeInMillis());
            Timestamp today = DateUtils.today();
            if (timeInv.compareTo(today) > 0) {
                return "Error: Fecha de documento no puede ser mayor a hoy";
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoiceLine.Table_ID) {
            MInvoiceLine iLine = (MInvoiceLine)((Object)po);
            MInvoice inv2 = new MInvoice(po.getCtx(), iLine.getC_Invoice_ID(), po.get_TrxName());
            MDocType dType = new MDocType(po.getCtx(), inv2.getC_DocTypeTarget_ID(), po.get_TrxName());
            if (inv2.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("BAJ") == 0 && iLine.getA_Asset_ID() > 0 && iLine.is_ValueChanged("A_Asset_ID")) {
                MAsset asset = new MAsset(po.getCtx(), iLine.getA_Asset_ID(), po.get_TrxName());
                iLine.setDescription(asset.getName());
                iLine.setPrice((BigDecimal)asset.get_Value("GrandTotal"));
                if (asset.getAD_User_ID() > 0) {
                    iLine.set_CustomColumn("AD_User_ID", asset.getAD_User_ID());
                }
                iLine.set_CustomColumn("Brand", asset.get_ValueAsString("Brand"));
                iLine.set_CustomColumn("Model", asset.get_ValueAsString("Model"));
                iLine.set_CustomColumn("SerNo", asset.get_ValueAsString("SerNo"));
                iLine.set_CustomColumn("Color", asset.get_ValueAsString("Color"));
                if (asset.get_ValueAsString("AssetStatus") != null && asset.get_ValueAsString("AssetStatus").trim().length() > 0) {
                    iLine.set_CustomColumn("AssetStatus", asset.get_ValueAsString("AssetStatus"));
                }
                iLine.set_CustomColumn("A_Parent_Asset_ID", asset.get_ValueAsInt("A_Parent_Asset_ID"));
                if (asset.get_ValueAsString("Type1") != null && asset.get_ValueAsString("Type1").trim().length() > 0) {
                    iLine.set_CustomColumn("Type1", asset.get_ValueAsString("Type1"));
                }
                iLine.set_CustomColumn("Rol", asset.get_ValueAsString("Rol"));
                iLine.set_CustomColumn("GroundSurface", (BigDecimal)asset.get_Value("GroundSurface"));
                iLine.set_CustomColumn("EdificationSurface", (BigDecimal)asset.get_Value("EdificationSurface"));
                iLine.set_CustomColumn("Engine", asset.get_ValueAsString("Engine"));
                iLine.set_CustomColumn("Chassis", asset.get_ValueAsString("Chassis"));
                iLine.set_CustomColumn("LicensePlate", asset.get_ValueAsString("LicensePlate"));
                iLine.set_CustomColumn("Digito", asset.get_ValueAsString("Digito"));
                iLine.set_CustomColumn("Sigla", asset.get_ValueAsString("Sigla"));
                iLine.set_CustomColumn("Fojas", asset.get_ValueAsString("Fojas"));
                iLine.set_CustomColumn("RegistrationNumber", asset.get_ValueAsString("RegistrationNumber"));
                iLine.set_CustomColumn("Year", asset.get_ValueAsString("Year"));
                if (asset.get_ValueAsString("Inmueble") != null && asset.get_ValueAsString("Inmueble").trim().length() > 0) {
                    iLine.set_CustomColumn("Inmueble", asset.get_ValueAsString("Inmueble"));
                }
                if (asset.get_ValueAsInt("C_Region_ID") > 0) {
                    iLine.set_CustomColumn("C_Region_ID", asset.get_ValueAsInt("C_Region_ID"));
                }
                if (asset.get_ValueAsInt("C_Province_ID") > 0) {
                    iLine.set_CustomColumn("C_Province_ID", asset.get_ValueAsInt("C_Province_ID"));
                }
                if (asset.get_ValueAsInt("C_City_ID") > 0) {
                    iLine.set_CustomColumn("C_City_ID", asset.get_ValueAsString("C_City_ID"));
                }
                if (asset.get_ValueAsString("DocDestination") != null && asset.get_ValueAsString("DocDestination").trim().length() > 0) {
                    iLine.set_CustomColumn("DocDestination", asset.get_ValueAsString("DocDestination"));
                }
                iLine.set_CustomColumn("DocNumber", asset.get_ValueAsString("DocNumber"));
                iLine.set_CustomColumn("Notaria", asset.get_ValueAsString("Notaria"));
                iLine.set_CustomColumn("N_Fecha_ValeVista", asset.get_ValueAsString("N_Fecha_ValeVista"));
                BigDecimal valevista = (BigDecimal)iLine.get_Value("Vlr_ValeVista");
                if (valevista != null && valevista.compareTo(Env.ZERO) <= 0) {
                    iLine.set_CustomColumn("Vlr_ValeVista", (BigDecimal)asset.get_Value("Vlr_ValeVista"));
                }
                iLine.set_CustomColumn("DocNumber2", asset.get_ValueAsString("DocNumber2"));
                asset.set_CustomColumn("ParentAsset", iLine.get_ValueAsString("ParentAsset"));
                iLine.set_CustomColumn("AssetSituation", asset.get_ValueAsString("AssetSituation"));
                iLine.set_CustomColumn("A_Asset_Group_Ref2_ID", asset.getA_Asset_Group_ID());
                iLine.set_CustomColumn("A_Asset_Group_Ref_ID", asset.get_ValueAsInt("A_Asset_Group_Ref_ID"));
                iLine.set_CustomColumn("A_Asset_Group_Ref3_ID", asset.get_ValueAsInt("A_Asset_Group_Ref2_ID"));
                if (asset.get_ValueAsInt("S_Resource_ID") > 0) {
                    iLine.set_CustomColumn("S_Resource_ID", asset.get_ValueAsInt("S_Resource_ID"));
                }
                if (asset.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    iLine.set_CustomColumn("S_ResourceRef_ID", asset.get_ValueAsInt("S_ResourceRef_ID"));
                }
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == MInvoice.Table_ID && po.is_ValueChanged("DocStatus")) {
            inv = (MInvoice)((Object)po);
            MDocType dType = new MDocType(po.getCtx(), inv.getC_DocTypeTarget_ID(), po.get_TrxName());
            if (inv.getDocStatus().compareTo("CO") == 0) {
                int cantLine;
                if (dType.get_ValueAsString("Type1").compareTo("ALT") == 0 && (cantLine = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1) FROM C_InvoiceLine WHERE IsActive = 'Y' AND C_Invoice_ID = " + inv.get_ID()))) != inv.get_ValueAsInt("ValidCantLine")) {
                    String msgError = "Error en campo: Cantidad de activos no coresponde con lineas";
                    String nameField = DB.getSQLValueString((String)po.get_TrxName(), (String)"SELECT name FROM AD_Field_Trl  WHERE AD_Field_ID=2003920 AND AD_Language='es_MX'", (Object[])new Object[0]);
                    if (nameField != null && nameField.trim().length() > 0) {
                        msgError = "Error en campo " + nameField + ": Cantidad de activos no coresponde con lineas";
                    }
                    DB.executeUpdate((String)("UPDATE C_Invoice SET ErrorMsg = '" + msgError + "' WHERE C_Invoice_ID =" + inv.get_ID()), (String)po.get_TrxName());
                }
                if (dType.get_ValueAsString("Type1").compareTo("BAJ") == 0) {
                    MInvoiceLine[] lines = inv.getLines(false);
                    int lineIndex = 0;
                    while (lineIndex < lines.length) {
                        MInvoiceLine iLine = lines[lineIndex];
                        if (inv.getC_DocTypeTarget_ID() == 2000159) {
                            BigDecimal Vlr_Subasta = (BigDecimal)iLine.get_Value("Vlr_Subasta");
                            if (Vlr_Subasta == null) {
                                Vlr_Subasta = Env.ZERO;
                            }
                            if (Vlr_Subasta.compareTo(Env.ZERO) <= 0) {
                                DB.executeUpdate((String)("UPDATE C_Invoice SET ErrorMsg = 'Todos los activos deben tener valor de subasta. Linea:" + iLine.getLine() / 10 + "' WHERE C_Invoice_ID =" + inv.get_ID()), (String)po.get_TrxName());
                            }
                        }
                        ++lineIndex;
                    }
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

