/*
 * Decompiled with CFR 0.152.
 */
package org.minsal.model;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModWarehouseMovement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModWarehouseMovement.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_Requisition", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)((Object)po)).getC_DocType().getDocBaseType().equals("RMV")) {
            MRequisitionLine[] lines = req.getLines();
            MMovement mov = null;
            Object inv = null;
            MWarehouse whfrom = MWarehouse.get((Properties)req.getCtx(), (int)req.getM_Warehouse_ID(), (String)req.get_TrxName());
            MWarehouse whto = MWarehouse.get((Properties)req.getCtx(), (int)req.get_ValueAsInt("M_WarehouseSource_ID"));
            MLocator locfrom = MLocator.get(req.getCtx(), req.get_ValueAsInt("M_Locator_ID"));
            MLocator locto = MLocator.get(req.getCtx(), req.get_ValueAsInt("M_LocatorTo_ID"));
            int i = 0;
            while (i < lines.length) {
                MRequisitionLine line = lines[i];
                if (line.getM_Product_ID() > 0) {
                    if (mov == null) {
                        mov = new MMovement(req.getCtx(), 0, req.get_TrxName());
                        mov.setAD_Org_ID(req.getAD_Org_ID());
                        mov.setMovementDate(req.getDateDoc());
                        mov.setDescription("Generado automaticamente desde solicitud " + req.getDocumentNo());
                        mov.save();
                        try {
                            mov.set_CustomColumn("M_Requisition_ID", req.get_ID());
                            mov.save();
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "No se pudo asignar la vvariable M_Requisition_ID en M_Movement ", (Throwable)e);
                        }
                        mov.save();
                    }
                    MMovementLine mline = new MMovementLine(req.getCtx(), 0, req.get_TrxName());
                    mline.setM_Movement_ID(mov.getM_Movement_ID());
                    mline.setAD_Org_ID(mov.getAD_Org_ID());
                    mline.setM_Product_ID(line.getM_Product_ID());
                    mline.setMovementQty(line.getQty());
                    mline.setM_Locator_ID(locfrom.get_ID());
                    mline.setM_LocatorTo_ID(locto.get_ID());
                    if (line.getM_Product().getM_AttributeSet_ID() > 0) {
                        int attributesetinstance = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT coalesce(max(m_attributesetinstance_id),0)  FROM m_attributesetinstance where m_attributeset_Id = " + line.getM_Product().getM_AttributeSet_ID() + " AND " + " Guaranteedate in (SELECT min(guaranteedate) from m_attributesetinstance where guaranteedate > now() AND " + " m_attributesetinstance_id in (select coalesce(m_attributesetinstance_id,0) from m_Transaction " + " WHERE m_product_id = " + line.getM_Product_ID() + ") ) AND " + " M_attributesetinstance_id in (select coalesce(m_Attributesetinstance_id,0) from m_Transaction " + " where m_product_id = " + line.getM_Product_ID() + ")"));
                        mline.setM_AttributeSetInstance_ID(attributesetinstance);
                    }
                    mline.setDescription(line.getDescription());
                    mline.set_CustomColumn("M_RequisitionLine_ID", (Object)line.getM_RequisitionLine_ID());
                    mline.save();
                }
                ++i;
            }
            if (mov != null) {
                try {
                    req.set_CustomColumn("M_Movement_ID", mov.getM_Movement_ID());
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", (Throwable)e);
                }
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

