/*
 * Decompiled with CFR 0.152.
 */
package org.minsal.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINSALValidateAmtInvoiceLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINSALValidateAmtInvoiceLine.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type != 1 && type != 2 || po.get_Table_ID() != MInvoiceLine.Table_ID) return null;
        MInvoiceLine iLine = (MInvoiceLine)((Object)po);
        MInvoice inv = new MInvoice(po.getCtx(), iLine.getC_Invoice_ID(), po.get_TrxName());
        MDocType dType = new MDocType(po.getCtx(), inv.getC_DocTypeTarget_ID(), po.get_TrxName());
        if (inv.getDocStatus().compareTo("DR") != 0 || dType.get_ValueAsString("Type1").compareTo("ALT") != 0) return null;
        if (dType.getName().toLowerCase().contains("alta por adq")) {
            int group = iLine.get_ValueAsInt("A_Asset_Group_Ref_ID");
            MAssetGroup mag = new MAssetGroup(po.getCtx(), group, po.get_TrxName());
            if (mag.get_ValueAsString("Value").compareTo("42") == 0 || mag.get_ValueAsString("Value").compareTo("44") == 0) {
                int id_utm = DB.getSQLValue((String)po.get_TrxName(), (String)"SELECT MAX(C_Currency_ID) FROM C_Currency WHERE Description like 'UTM' ");
                BigDecimal totalAmtLineCLP = iLine.getPriceEntered();
                if (id_utm <= 0) return null;
                BigDecimal amt30UTMclp = MConversionRate.convert(po.getCtx(), new BigDecimal("30.0"), id_utm, inv.getC_Currency_ID(), (Timestamp)inv.get_Value("DateDoc"), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
                if (inv.getC_Currency_ID() != 228) {
                    totalAmtLineCLP = MConversionRate.convert(po.getCtx(), iLine.getPriceEntered(), inv.getC_Currency_ID(), 228, (Timestamp)inv.get_Value("DateDoc"), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
                }
                try {
                    if (totalAmtLineCLP.compareTo(amt30UTMclp) >= 0) return null;
                    return "ERROR! Los bienes de los grupos 42 y 44 deben tener un valor mayor a 30UTM en las altas por adquisici\u00f3n";
                }
                catch (Exception e) {
                    log.config("No se pudo hacer comparaci\u00f3n con moneda UTM" + e.toString());
                    return "No se pudo hacer comparaci\u00f3n con moneda UTM. Recuerde ingresar la tasa de cambio";
                }
            }
            if (mag.get_ValueAsString("Value").compareTo("36") == 0) {
                BigDecimal totalAmtLineCLP = iLine.getPriceEntered();
                if (totalAmtLineCLP.compareTo(Env.ONE) >= 0) return null;
                return "El valor del bien debe ser mayor a 1 peso";
            }
            int id_utm = DB.getSQLValue((String)po.get_TrxName(), (String)"SELECT MAX(C_Currency_ID) FROM C_Currency WHERE Description like 'UTM' ");
            BigDecimal totalAmtLineCLP = iLine.getPriceEntered();
            if (id_utm <= 0) return null;
            BigDecimal amt1UTMclp = MConversionRate.convert(po.getCtx(), new BigDecimal("1.0"), id_utm, inv.getC_Currency_ID(), (Timestamp)inv.get_Value("DateDoc"), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
            if (inv.getC_Currency_ID() != 228) {
                totalAmtLineCLP = MConversionRate.convert(po.getCtx(), iLine.getPriceEntered(), inv.getC_Currency_ID(), 228, (Timestamp)inv.get_Value("DateDoc"), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
            }
            try {
                if (totalAmtLineCLP.compareTo(amt1UTMclp) >= 0) return null;
                return "ERROR! Los bienes deben tener un valor mayor a 1UTM en las altas por adquisici\u00f3n";
            }
            catch (Exception e) {
                log.config("No se pudo hacer comparaci\u00f3n con moneda UTM" + e.toString());
                return null;
            }
        } else {
            BigDecimal totalAmtLineCLP = iLine.getPriceEntered();
            if (totalAmtLineCLP.compareTo(Env.ONE) >= 0) return null;
            return "El valor del bien debe ser mayor a 1 peso";
        }
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

