/*
 * Decompiled with CFR 0.152.
 */
package org.minsal.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModFillPriceReceipHeader
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModFillPriceReceipHeader.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("M_InOutLine", (ModelValidator)this);
        engine.addModelChange("M_InOut", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MInOutLine minl;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInOutLine.Table_ID) {
            minl = (MInOutLine)((Object)po);
            BigDecimal price = Env.ZERO;
            BigDecimal taxAmt = Env.ZERO;
            if (minl.getC_OrderLine_ID() > 0) {
                price = minl.getC_OrderLine().getPriceEntered();
                minl.set_CustomColumn("PriceEntered", price);
                taxAmt = minl.getC_OrderLine().getC_Tax().getRate().divide(Env.ONEHUNDRED);
                taxAmt = taxAmt.multiply(price);
                taxAmt = taxAmt.multiply(minl.getQtyEntered()).setScale(0, RoundingMode.HALF_EVEN);
                minl.set_CustomColumn("C_Tax_ID", minl.getC_OrderLine().getC_Tax_ID());
            } else {
                price = (BigDecimal)minl.get_Value("PriceEntered");
                if (minl.get_ValueAsInt("C_Tax_ID") > 0) {
                    MTax tax = new MTax(po.getCtx(), minl.get_ValueAsInt("C_Tax_ID"), po.get_TrxName());
                    taxAmt = tax.getRate().divide(Env.ONEHUNDRED);
                    taxAmt = taxAmt.multiply(price);
                    taxAmt = taxAmt.multiply(minl.getQtyEntered()).setScale(0, RoundingMode.HALF_EVEN);
                }
            }
            if (price == null) {
                price = Env.ZERO;
            }
            minl.set_CustomColumn("TaxAmt", taxAmt);
            minl.set_CustomColumn("LineNetAmt", price.multiply(minl.getQtyEntered()));
        }
        if ((type == 5 || type == 4 || type == 6) && po.get_Table_ID() == MInOutLine.Table_ID) {
            BigDecimal taxAmt;
            BigDecimal grandTotal;
            minl = (MInOutLine)((Object)po);
            MInOut io = new MInOut(po.getCtx(), minl.getM_InOut_ID(), po.get_TrxName());
            BigDecimal LineNetAmt = DB.getSQLValueBD((String)po.get_TrxName(), (String)(" SELECT COALESCE(SUM(LineNetAmt),0)  FROM M_InOutLine WHERE M_InOut_ID = " + io.get_ID()), (Object[])new Object[0]);
            if (LineNetAmt != null) {
                io.set_CustomColumn("LineNetAmt", LineNetAmt);
            }
            if ((grandTotal = DB.getSQLValueBD((String)po.get_TrxName(), (String)(" SELECT COALESCE(SUM(LineNetAmt+TaxAmt),0)  FROM M_InOutLine WHERE M_InOut_ID = " + io.get_ID()), (Object[])new Object[0])) != null) {
                io.set_CustomColumn("GrandTotal", grandTotal);
            }
            if ((taxAmt = DB.getSQLValueBD((String)po.get_TrxName(), (String)(" SELECT COALESCE(SUM(TaxAmt),0)  FROM M_InOutLine WHERE M_InOut_ID = " + io.get_ID()), (Object[])new Object[0])) != null) {
                io.set_CustomColumn("TaxAmt", taxAmt);
            }
            io.saveEx(po.get_TrxName());
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

