/*
 * Decompiled with CFR 0.152.
 */
package org.minju.process;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.X_HR_AdministrativeRequests;
import org.compiere.model.X_HR_AttendanceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class ProcessAdministrativeRequest
extends SvrProcess {
    private int p_AdmRequest_ID = 0;
    private String p_Action = "PR";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_AdmRequest_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_AdmRequest_ID > 0) {
            X_HR_AdministrativeRequests req = new X_HR_AdministrativeRequests(this.getCtx(), this.p_AdmRequest_ID, this.get_TrxName());
            String newStatus = "DR";
            String newAction = "DR";
            this.log.config("paction " + this.p_Action);
            if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "SS";
                newAction = "SS";
            } else if (req.getDocStatus().compareTo("SS") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AP";
                newAction = "AP";
            } else if (req.getDocStatus().compareTo("AP") == 0 && this.p_Action.compareTo("CO") == 0 && req.getRequestType().compareTo("CMT") != 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("AP") == 0 && this.p_Action.compareTo("CO") == 0 && req.getRequestType().compareTo("CMT") == 0) {
                newStatus = "AD";
                newAction = "AD";
            } else if (req.getDocStatus().compareTo("AD") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("RJ") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("SS") == 0 && this.p_Action.compareTo("RJ") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AP") == 0 && this.p_Action.compareTo("RJ") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AD") == 0 && this.p_Action.compareTo("RJ") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("CO") != 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "VO";
                newAction = "VO";
            }
            int cant = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_Document_Action_Access daa INNER JOIN AD_Ref_List rl ON (daa.AD_Ref_List_ID = rl.AD_Ref_List_ID)  WHERE value = '" + newAction + "' AND AD_Role_ID = " + Env.getAD_Role_ID((Properties)this.getCtx()) + " AND C_DocType_ID = " + req.get_ValueAsInt("C_DocType_ID")));
            this.log.config("cantidad" + cant);
            if (cant > 0) {
                int BPartner;
                if (newAction.compareTo("CO") != 0) {
                    BPartner = req.getC_BPartner_ID();
                    int HR_Employee = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT max(HR_Employee_ID)  FROM HR_Employee WHERE C_BPartner_ID = " + BPartner + " and" + " IsActive='Y'"));
                    this.log.config("HR_Employee " + HR_Employee);
                    if (this.p_Action.compareTo("RJ") == 0 && req.get_Value("Comments") == null) {
                        throw new AdempiereException("Debe ingresar un motivo de rechazo");
                    }
                    if (newAction.compareTo("SS") == 0 && req.getRequestType().compareTo("SVC") == 0) {
                        String sqldays = "SELECT VacationDay from HR_Employee where HR_Employee_ID = ?";
                        BigDecimal DaysLeft = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays, (int)HR_Employee);
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("days left" + DaysLeft);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq = "SELECT Days from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                        if (DaysLeft.compareTo(DaysReq) < 0) {
                            throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                        }
                    }
                    req.setDocStatus(newStatus);
                    if (newAction.compareTo("VO") == 0) {
                        req.setProcessed(true);
                    }
                    req.save();
                } else if (newAction.compareTo("CO") == 0) {
                    BigDecimal DaysReq;
                    String sqldaysreq;
                    BigDecimal DaysLeft;
                    String sqldays;
                    BPartner = req.getC_BPartner_ID();
                    int HR_Employee = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT max(HR_Employee_ID)  FROM HR_Employee WHERE C_BPartner_ID = " + BPartner + " and" + " IsActive='Y'"));
                    this.log.config("HR_Employee " + HR_Employee);
                    if (req.getRequestType().compareTo("PAD") == 0) {
                        sqldays = "SELECT AdministrativeDay from HR_Employee where HR_Employee_ID = ?";
                        DaysLeft = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays, (int)HR_Employee);
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("days left" + DaysLeft);
                        this.log.config("partner = " + BPartner);
                        sqldaysreq = "SELECT count(1) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? AND  AdmType like 'DIA'";
                        DaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                        String sqlmiddaysreq = "SELECT count(1) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? AND  AdmType in ('MAN','TAR')";
                        BigDecimal MidDaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlmiddaysreq, (int)req.get_ID());
                        MidDaysReq = MidDaysReq.divide(new BigDecimal("2"));
                        BigDecimal suma = MidDaysReq.add(DaysReq);
                        if (DaysLeft.compareTo(suma) >= 0) {
                            DB.executeUpdate((String)("Update HR_Employee set AdministrativeDay = AdministrativeDay - " + suma + " WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        } else {
                            throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                        }
                    }
                    if (req.getRequestType().compareTo("SVC") == 0) {
                        sqldays = "SELECT VacationDay from HR_Employee where HR_Employee_ID = ?";
                        DaysLeft = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays, (int)HR_Employee);
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("days left" + DaysLeft);
                        this.log.config("partner = " + BPartner);
                        sqldaysreq = "SELECT Days from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        DaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                        if (DaysLeft.compareTo(DaysReq) >= 0) {
                            DB.executeUpdate((String)("Update HR_Employee set VacationDay = VacationDay - " + DaysReq + " WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        } else {
                            throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                        }
                    }
                    if (req.getRequestType().compareTo("SVT") == 0) {
                        String sqlyear = "Select extract (year from datedoc) from hr_administrativerequests where hr_administrativerequests_id = ?";
                        BigDecimal yeardoc = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlyear, (int)req.get_ID());
                        String sqlcount = "SELECT count(1) from hr_administrativerequests where requesttype = 'SVT' and datedoc  between '" + yeardoc + "-01-01' and '" + yeardoc + "-12-31' and c_bpartner_id = " + BPartner;
                        int contador = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcount);
                        if (contador > 1) {
                            throw new AdempiereException("Ya tiene una solicitud de traspaso para el a\u00f1o indicado");
                        }
                        String sqldays2 = "SELECT coalesce(VacationDay,0) from HR_Employee where HR_Employee_ID = ?";
                        BigDecimal DaysLeft2 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays2, (int)HR_Employee);
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("days left" + DaysLeft2);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq2 = "SELECT coalesce(Days,0) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq2 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq2, (int)req.get_ID());
                        if (DaysLeft2.compareTo(DaysReq2) >= 0) {
                            DB.executeUpdate((String)("Update HR_Employee set VacationDay = " + DaysReq2 + " + VacationDayInitial WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        } else {
                            throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                        }
                    }
                    if (req.getRequestType().compareTo("COM") == 0) {
                        String sqlhours = "SELECT HoursAvailable from HR_Employee where HR_Employee_ID = ?";
                        BigDecimal HoursAvailable = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlhours, (int)HR_Employee);
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("days left" + HoursAvailable);
                        this.log.config("partner = " + BPartner);
                        String sqlhoursreq = "SELECT SUM(hours) from HR_AdministrativeRequestsL where IsActive = 'Y' AND HR_AdministrativeRequests_ID = ? ";
                        BigDecimal HoursReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlhoursreq, (int)req.get_ID());
                        if (HoursAvailable.compareTo(HoursReq) >= 0) {
                            DB.executeUpdate((String)("Update HR_Employee set HoursUsed  = HoursUsed + " + HoursReq + " WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                            DB.executeUpdate((String)("Update HR_Employee set HoursAvailable = HoursEarned - HoursUsed WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        } else {
                            throw new AdempiereException("Debe revisar la cantidad de horas solicitadas.");
                        }
                    }
                    if (req.getRequestType().compareTo("CAP") == 0) {
                        int yearReq = DateUtils.today().getYear() + 1900;
                        int yearAD = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(C_Year_ID) FROM C_Year WHERE FiscalYear = '" + yearReq + "'"));
                        int ID_Cab = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(HR_Attendance_ID) FROM HR_Attendance WHERE C_Year_ID = " + yearAD));
                        if (ID_Cab > 0) {
                            String sql = "SELECT * FROM HR_AdministrativeRequestsL WHERE HR_AdministrativeRequests_ID = " + req.get_ID();
                            CPreparedStatement pstmt = null;
                            ResultSet rs = null;
                            try {
                                try {
                                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                                    rs = pstmt.executeQuery();
                                    while (rs.next()) {
                                        X_HR_AttendanceLine line = new X_HR_AttendanceLine(this.getCtx(), 0, this.get_TrxName());
                                        line.setC_BPartner_ID(req.getC_BPartner_ID());
                                        line.setHR_Attendance_ID(ID_Cab);
                                        line.setDateTrx(rs.getTimestamp("DateRequired"));
                                        line.setRequestType(rs.getString("AttType"));
                                        line.save();
                                    }
                                    rs.close();
                                    pstmt.close();
                                    pstmt = null;
                                }
                                catch (SQLException e) {
                                    throw new DBException((Exception)e, sql);
                                }
                            }
                            catch (Throwable throwable) {
                                DB.close(rs, pstmt);
                                rs = null;
                                pstmt = null;
                                throw throwable;
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                        }
                    }
                    if (req.getRequestType().compareTo("PPM") == 0) {
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq3 = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq3 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq3, (int)req.get_ID());
                        this.log.config("days = " + DaysReq3);
                        if (DaysReq3.compareTo(new BigDecimal("5.0")) > 0) {
                            throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 5 dias.");
                        }
                    }
                    if (req.getRequestType().compareTo("PAT") == 0) {
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq4 = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq4 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq4, (int)req.get_ID());
                        this.log.config("days = " + DaysReq4);
                        if (DaysReq4.compareTo(new BigDecimal("5.0")) > 0) {
                            throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 5 dias.");
                        }
                    }
                    if (req.getRequestType().compareTo("SHT") == 0) {
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq5 = "SELECT SUM(hours) from HR_AdministrativeRequestsL where IsActive = 'Y' AND HR_AdministrativeRequests_ID = ? ";
                        BigDecimal HoursReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq5, (int)req.get_ID());
                        this.log.config("Hours = " + HoursReq);
                        if (HoursReq.compareTo(Env.ZERO) > 0) {
                            DB.executeUpdate((String)("Update HR_Employee set HoursEarned  = HoursEarned + " + HoursReq + " WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                            DB.executeUpdate((String)("Update HR_Employee set HoursAvailable = HoursEarned - HoursUsed WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        }
                    }
                    if (req.getRequestType().compareTo("FAL") == 0) {
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq6 = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq5 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq6, (int)req.get_ID());
                        this.log.config("days = " + DaysReq5);
                        if (req.get_ValueAsString("RequestType2").compareTo("01") == 0 && DaysReq5.compareTo(new BigDecimal("7.0")) > 0) {
                            throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 7 dias.");
                        }
                        if (req.get_ValueAsString("RequestType2").compareTo("02") == 0 && DaysReq5.compareTo(new BigDecimal("3.0")) > 0) {
                            throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 3 dias.");
                        }
                    }
                    req.setDocStatus("CO");
                    req.setProcessed(true);
                    req.save();
                }
                if (newStatus.compareTo("SS") == 0) {
                    this.log.config("Correo Enviado solicitud administrativa: " + req.get_ID());
                    CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                    cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    cst.setInt(2, 36);
                    cst.setString(3, "-");
                    cst.setInt(4, req.get_ID());
                    cst.execute();
                } else if (newStatus.compareTo("AP") == 0) {
                    this.log.config("Correo Enviado solicitud administrativa: " + req.get_ID());
                    CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                    cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    cst.setInt(2, 37);
                    cst.setString(3, "-");
                    cst.setInt(4, req.get_ID());
                    cst.execute();
                } else if (newStatus.compareTo("CO") == 0) {
                    this.log.config("Correo Enviado solicitud administrativa: " + req.get_ID());
                    CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                    cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    cst.setInt(2, 38);
                    cst.setString(3, "-");
                    cst.setInt(4, req.get_ID());
                    cst.execute();
                } else if (newStatus.compareTo("DR") == 0) {
                    this.log.config("Correo Enviado solicitud administrativa: " + req.get_ID());
                    CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                    cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    cst.setInt(2, 39);
                    cst.setString(3, "-");
                    cst.setInt(4, req.get_ID());
                    cst.execute();
                }
            } else {
                throw new AdempiereException("Error: Permisos de rol insuficientes");
            }
        }
        return "Procesado";
    }
}

