/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_RH_MedicalLicenses;
import org.compiere.model.X_RH_MedicalLicensesLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUValidateAmtRecover
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUValidateAmtRecover.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("RH_MedicalLicenses", (ModelValidator)this);
        engine.addModelChange("RH_MedicalLicensesLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_RH_MedicalLicensesLine.Table_ID) {
            X_RH_MedicalLicensesLine line = (X_RH_MedicalLicensesLine)po;
            int id_license = line.getRH_MedicalLicenses_ID();
            X_RH_MedicalLicenses rh = new X_RH_MedicalLicenses(po.getCtx(), id_license, po.get_TrxName());
            if (rh.getDocStatus().compareTo("RE") == 0) {
                String sqlDE = "SELECT count(1) FROM rh_medicallicensesline WHERE RH_MedicalLicenses_ID = " + id_license + " " + " AND PaymentType like 'DE'";
                int countDE = DB.getSQLValue((String)po.get_TrxName(), (String)sqlDE);
                String sqlIN = "SELECT count(1) FROM rh_medicallicensesline WHERE RH_MedicalLicenses_ID = " + id_license + " " + " AND PaymentType like 'IN'";
                int countIN = DB.getSQLValue((String)po.get_TrxName(), (String)sqlIN);
                if (countIN > 0 && countDE > 0) {
                    String sqldifde = "SELECT coalesce(sum(amount2),0) FROM rh_medicallicensesline WHERE  PaymentType like 'DE' AND RH_MedicalLicenses_ID = ?";
                    String sqldifin = "SELECT coalesce(sum(amount2),0) FROM rh_medicallicensesline WHERE  PaymentType like 'IN' and RH_MedicalLicenses_ID = ?";
                    log.config("sql dif " + sqldifde);
                    log.config("sql dif " + sqldifin);
                    BigDecimal de = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqldifde, (int)id_license);
                    BigDecimal in = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqldifin, (int)id_license);
                    BigDecimal diff = de.subtract(in);
                    if (diff.compareTo(Env.ZERO) == 0) {
                        rh.setDocStatus("CO");
                        rh.setProcessed(true);
                        rh.save();
                    }
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

