/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUValidStockShipment
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUValidStockShipment.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MInOut inOut;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MInOut.Table_ID && (inOut = (MInOut)((Object)po)).isSOTrx()) {
            MInOutLine[] lines = inOut.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInOutLine line = lines[i];
                if (line.getM_Product().isStocked() && line.getM_Product().getProductType().compareTo("I") == 0 && line.getMovementQty().compareTo(Env.ZERO) > 0) {
                    BigDecimal qtyOnHand = DB.getSQLValueBD((String)po.get_TrxName(), (String)" SELECT bomqtyonhand(mp.M_Product_ID,?,0) FROM M_Product mp WHERE M_Product_ID = ?", (Object[])new Object[]{inOut.getM_Warehouse_ID(), line.getM_Product_ID()});
                    if (line.getMovementQty().compareTo(qtyOnHand) > 0) {
                        return "ERROR: Stock Insuficiente de producto. Linea " + line.getLine() + ". Producto " + line.getM_Product().getName();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

