/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUValidCompleteOrderBugdet
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUValidCompleteOrderBugdet.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order = (MOrder)((Object)po);
            MOrderLine[] lines = order.getLines(true, null);
            int i = 0;
            while (i < lines.length) {
                MOrderLine line = lines[i];
                int ID_ReqLine = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(M_RequisitionLine_ID)  FROM M_RequisitionLine rl  INNER JOIN M_Requisition mr on (rl.M_Requisition_ID = mr.M_Requisition_ID)  WHERE rl.C_OrderLine_ID = " + line.get_ID() + " AND rl.IsActive = 'Y' " + " AND mr.IsActive = 'Y' AND mr.DocStatus NOT IN ('VO')"));
                if (ID_ReqLine > 0) {
                    MRequisitionLine rLine = new MRequisitionLine(po.getCtx(), ID_ReqLine, po.get_TrxName());
                    BigDecimal totalAmt = null;
                    if (line.getC_Tax().getRate().compareTo(Env.ZERO) > 0) {
                        totalAmt = line.getLineNetAmt().multiply(line.getC_Tax().getRate());
                        totalAmt = totalAmt.divide(Env.ONEHUNDRED);
                    }
                    if ((totalAmt = totalAmt != null ? totalAmt.add(line.getLineNetAmt()) : line.getLineNetAmt()).compareTo(rLine.getLineNetAmt()) > 0) {
                        DB.executeUpdate((String)("UPDATE C_Order set Comments3 = 'Revisar valor presupuestado versus valor de linea " + line.getLine() + "' WHERE C_Order_ID = " + order.get_ID()), (String)po.get_TrxName());
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

