/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUValidCompleteCash
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUValidCompleteCash.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Cash", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MCash.Table_ID) {
            MCash cash = (MCash)((Object)po);
            MCashLine[] lines = cash.getLines(false);
            BigDecimal amtUTM = DB.getSQLValueBD((String)po.get_TrxName(), (String)"SELECT  multiplyrate FROM C_Conversion_Rate cr  INNER JOIN C_Currency cu ON (cr.C_Currency_ID = cu.C_Currency_ID)  INNER JOIN C_Currency cu2 ON (cr.C_Currency_ID_to = cu2.C_Currency_ID)  WHERE cu.Iso_Code = 'UTM' AND cu2.Iso_Code = 'CLP'  AND ? BETWEEN validfrom AND validto", (Object[])new Object[]{cash.getDateAcct()});
            if (amtUTM == null || amtUTM.compareTo(Env.ZERO) <= 0) {
                return "Error: Debe ingresar valor UTM ";
            }
            int i = 0;
            while (i < lines.length) {
                MCashLine line = lines[i];
                if (line.getAmount().compareTo(amtUTM) > 0) {
                    return "Error: Linea " + line.getLine() + " supera monto de UTM";
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

