/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_ProjectSchedule;
import org.compiere.model.X_PM_ProjectPay;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModMINJUUpdateAmtProjectSchedule
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUUpdateAmtProjectSchedule.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("PM_ProjectPay", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_PM_ProjectPay.Table_ID) {
            X_PM_ProjectPay pp = (X_PM_ProjectPay)po;
            X_C_ProjectSchedule ps = new X_C_ProjectSchedule(po.getCtx(), pp.getC_ProjectSchedule_ID(), po.get_TrxName());
            String sqlamountliq = "SELECT coalesce(sum(amt),0) FROM PM_ProjectPay WHERE C_ProjectSchedule_ID = ? AND  pay_type in ('D1','D2','R1','RH')";
            String sqlamountbud = "SELECT coalesce(sum(amt),0) FROM PM_ProjectPay WHERE  C_ProjectSchedule_ID = ? AND  pay_type in ('FA','RT')";
            BigDecimal amountliq = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlamountliq, (int)pp.getC_ProjectSchedule_ID());
            BigDecimal amountbud = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlamountbud, (int)pp.getC_ProjectSchedule_ID());
            String sqlamountanticipo = "SELECT coalesce(sum(amt),0) FROM PM_ProjectPay WHERE  C_ProjectSchedule_ID = ? AND  pay_type in ('AT')";
            BigDecimal amountanticipo = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlamountanticipo, (int)pp.getC_ProjectSchedule_ID());
            BigDecimal liquidoapago = amountbud.subtract(amountliq);
            liquidoapago = liquidoapago.add(amountanticipo);
            ps.set_CustomColumn("Amount2", liquidoapago);
            ps.setDueAmt(amountbud);
            ps.saveEx();
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

