/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MProjectLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_SubProjectOFB;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModMINJUProjectAmt
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUProjectAmt.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Project", (ModelValidator)this);
        engine.addModelChange("C_SubProjectOFB", (ModelValidator)this);
        engine.addModelChange("C_ProjectLine", (ModelValidator)this);
        engine.addModelChange("C_ProjectSchedule", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_C_SubProjectOFB.Table_ID) {
            X_C_SubProjectOFB spro = (X_C_SubProjectOFB)po;
            if (spro.getC_Phase_ID2().compareTo("FPI") == 0) {
                MProjectLine prol = new MProjectLine(po.getCtx(), spro.getC_ProjectLine_ID(), po.get_TrxName());
                String act = spro.getActivitiesList();
                if (act.compareTo("001") == 0) {
                    prol.set_CustomColumn("PlannedAmtLine", (Object)spro.getAmtApproval());
                    prol.save();
                } else if (act.compareTo("002") == 0) {
                    prol.set_CustomColumn("BudgetAmt", (Object)spro.getAmtApproval());
                    prol.save();
                } else if (act.compareTo("003") == 0) {
                    prol.set_CustomColumn("CommittedAmt", (Object)prol.getCommittedAmt().add(spro.getAmtApproval()));
                    prol.save();
                } else if (act.compareTo("004") == 0) {
                    prol.set_CustomColumn("CommitedAmt", (Object)prol.getCommittedAmt().subtract(spro.getAmtApproval()));
                    prol.save();
                }
            }
            MProjectLine prol2 = new MProjectLine(po.getCtx(), spro.getC_ProjectLine_ID(), po.get_TrxName());
            String sqltask = "SELECT task_list from c_subprojectofb where c_subprojectofb_id = ?";
            String task = DB.getSQLValueString((String)po.get_TrxName(), (String)sqltask, (int)spro.get_ID());
            if (task != null && task.startsWith("P")) {
                prol2.set_CustomColumn("CommitedAmt", (Object)prol2.getCommittedAmt().add(spro.getAmtApproval()));
                prol2.save();
            } else if (task != null && task.startsWith("E")) {
                int amountex = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT coalesce(ExecutedAmt,0) from c_projectline where c_projectline_id = " + spro.getC_ProjectLine_ID()));
                BigDecimal amountbd = new BigDecimal(amountex);
                prol2.set_CustomColumn("ExecutedAmt", (Object)amountbd.add(spro.getAmtApproval()));
                prol2.save();
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == MProjectLine.Table_ID) {
            MProjectLine prol = (MProjectLine)po;
            DB.executeUpdate((String)("Update c_project set PlannedAmt = (select coalesce(sum(plannedamtline),0) from c_projectline where c_project_id = " + prol.getC_Project_ID() + ") where c_project_id =  " + prol.getC_Project_ID()), (String)prol.get_TrxName());
            DB.executeUpdate((String)("Update c_project set BudgetAmt = (select coalesce(sum(BudgetAmt),0) from c_projectline where c_project_id = " + prol.getC_Project_ID() + ") where c_project_id =  " + prol.getC_Project_ID()), (String)prol.get_TrxName());
            DB.executeUpdate((String)("Update c_project set CommittedAmt = (select coalesce(sum(CommittedAmt),0) from c_projectline where c_project_id = " + prol.getC_Project_ID() + ") where c_project_id =  " + prol.getC_Project_ID()), (String)prol.get_TrxName());
            DB.executeUpdate((String)("Update c_project set ExecutedAmt = (select coalesce(sum(ExecutedAmt),0) from c_projectline where c_project_id = " + prol.getC_Project_ID() + ") where c_project_id =  " + prol.getC_Project_ID()), (String)prol.get_TrxName());
            DB.executeUpdate((String)("Update c_project set PaidAmt = (select coalesce(sum(PaidAmt),0) from c_projectline where c_project_id = " + prol.getC_Project_ID() + ") where c_project_id =  " + prol.getC_Project_ID()), (String)prol.get_TrxName());
            DB.executeUpdate((String)("Update c_project set OtherExpenses = (select coalesce(sum(OtherExpenses),0) from c_projectline where c_project_id = " + prol.getC_Project_ID() + ") where c_project_id =  " + prol.getC_Project_ID()), (String)prol.get_TrxName());
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == 2000045) {
            int projectline_id = po.get_ValueAsInt("C_ProjectLine_ID");
            log.config("projectline id " + projectline_id);
            int sumpaid = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT sum(dueamt) from c_projectschedule where isactive='Y' and C_ProjectLine_ID = " + projectline_id));
            BigDecimal valor = new BigDecimal(sumpaid);
            MProjectLine prol = new MProjectLine(po.getCtx(), projectline_id, po.get_TrxName());
            prol.set_CustomColumn("PaidAmt", (Object)valor);
            prol.save();
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

