/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_MP_Indicator;
import org.compiere.model.X_MP_IndicatorDetail;
import org.compiere.model.X_MP_Response;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUCreateResponseLines
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUCreateResponseLines.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("MP_IndicatorDetail", (ModelValidator)this);
        engine.addModelChange("MP_Response", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        int indicator_id;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == X_MP_IndicatorDetail.Table_ID) {
            X_MP_IndicatorDetail ind = (X_MP_IndicatorDetail)po;
            indicator_id = ind.getMP_Indicator_ID();
            X_MP_Indicator i = new X_MP_Indicator(po.getCtx(), indicator_id, po.get_TrxName());
            CPreparedStatement pstmt = null;
            String sql = "SELECT mp_planification_id, c_period_id from mp_planification where mp_indicator_id = " + indicator_id;
            pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_Response resp = new X_MP_Response(po.getCtx(), 0, po.get_TrxName());
                resp.set_CustomColumn("C_Period_ID", rs.getInt("C_Period_ID"));
                resp.set_CustomColumn("VarARef", indicator_id);
                resp.set_CustomColumn("VarBRef", indicator_id);
                resp.setAD_Org_ID(ind.getAD_Org_ID());
                resp.set_CustomColumn("MP_IndicatorDetail_ID", ind.get_ID());
                resp.set_CustomColumn("Obtained", Env.ZERO);
                resp.save();
            }
        }
        if (type == 5 && po.get_Table_ID() == X_MP_Response.Table_ID) {
            X_MP_Response resp = (X_MP_Response)po;
            indicator_id = DB.getSQLValue((String)po.get_TrxName(), (String)("select mp_indicator_id from mp_indicatordetail where mp_indicatordetail_id = " + resp.getMP_IndicatorDetail_ID()));
            int indicatordetail_id = resp.getMP_IndicatorDetail_ID();
            int factor = 0;
            factor = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT coalesce(factor,1) from mp_indicator where mp_indicator_id in (select mp_indicator_id from mp_indicatordetail where mp_indicatordetail_id = " + resp.getMP_IndicatorDetail_ID() + ") "));
            log.config("factor es " + factor);
            String varbresp = "SELECT varbresponse from mp_response where mp_response_id = ?";
            BigDecimal varbresponse = DB.getSQLValueBD((String)po.get_TrxName(), (String)varbresp, (int)resp.get_ID());
            String sqlintype = "SELECT c.indicatortype from mp_indicator c where c.mp_indicator_id = ?";
            String indicatortype = DB.getSQLValueString((String)po.get_TrxName(), (String)sqlintype, (int)indicator_id);
            String vararespint = "SELECT vararesponseint from mp_Response where mp_response_id = " + resp.get_ID();
            int varaInt = DB.getSQLValue((String)po.get_TrxName(), (String)vararespint);
            String varbrespint = "SELECT varbresponseint from mp_Response where mp_response_id = " + resp.get_ID();
            int varbInt = DB.getSQLValue((String)po.get_TrxName(), (String)varbrespint);
            if (indicatortype.compareTo("02") == 0) {
                varbresponse = new BigDecimal(varbInt);
            }
            if (varbresponse.compareTo(Env.ZERO) == 0) {
                if (!resp.get_Value("Obtained").equals(Env.ZERO)) {
                    resp.set_CustomColumn("Obtained", Env.ZERO);
                    if (indicatortype.compareTo("02") == 0) {
                        DB.executeUpdate((String)("UPDATE mp_response set vararesponse = " + varaInt + ", varbresponse = " + varbInt + " where mp_response_id = " + resp.get_ID()), (String)po.get_TrxName());
                    }
                    resp.save();
                }
            } else if (varbresponse.compareTo(Env.ZERO) > 0) {
                String vararesp = "SELECT vararesponse from mp_response where mp_response_id = ?";
                BigDecimal vararesponse = Env.ZERO;
                boolean flag = false;
                if (indicatortype.compareTo("02") == 0) {
                    vararesponse = new BigDecimal(varaInt);
                    flag = true;
                } else {
                    vararesponse = DB.getSQLValueBD((String)po.get_TrxName(), (String)vararesp, (int)resp.get_ID());
                    flag = false;
                }
                BigDecimal b2 = vararesponse.divide(varbresponse, 6, RoundingMode.HALF_UP);
                BigDecimal ActualResult = Env.ZERO;
                ActualResult = b2.multiply(BigDecimal.valueOf(factor));
                ActualResult = ActualResult.setScale(2, RoundingMode.DOWN);
                if (resp.get_Value("Obtained") == null || !resp.get_Value("Obtained").equals(ActualResult)) {
                    log.config("Obtained es " + ActualResult);
                    resp.set_CustomColumn("Obtained", ActualResult);
                    if (flag) {
                        DB.executeUpdate((String)("UPDATE mp_response set vararesponse = " + varaInt + ", varbresponse = " + varbInt + " where mp_response_id = " + resp.get_ID()), (String)po.get_TrxName());
                    }
                    resp.save();
                }
            }
            Calendar fecha = Calendar.getInstance();
            int mes = fecha.get(2) + 1;
            int year = fecha.get(1);
            String sqlanno = "SELECT coalesce(sum(expectedresult),1) from mp_planification where mp_indicator_id = " + indicator_id + " and c_period_id in (select c_period_id from c_period where extract(month from startdate) <= " + mes + " and extract(year from startdate) = ?)";
            log.config("sqlanno = " + sqlanno);
            BigDecimal CumulatedResultPlan = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlanno, (int)year);
            log.config("planificado acumulado " + CumulatedResultPlan);
            log.config("mes " + mes);
            String sqlactual = "SELECT coalesce(vararesponse,0) from mp_response where mp_indicatordetail_id = " + indicatordetail_id + " and c_period_id in " + " (select max(c_period_id) from mp_Response where mp_indicatordetail_id = ?)";
            log.config("sql actual " + sqlactual);
            String sqlactualsuma = "SELECT coalesce(sum(vararesponse),0) from  mp_response where mp_indicatordetail_id = ?";
            BigDecimal CumulatedResultActual = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlactual, (int)indicatordetail_id);
            log.config("Obtenido acumulado " + CumulatedResultActual);
            BigDecimal CumulatedResultActualsuma = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlactualsuma, (int)indicatordetail_id);
            log.config("Obtenido acumulado " + CumulatedResultActualsuma);
            BigDecimal CumulatedResultActuala = CumulatedResultActual;
            BigDecimal CumulatedResultActualasuma = CumulatedResultActualsuma;
            String sqlactualb = "SELECT coalesce(varbresponse,0) from mp_response where mp_indicatordetail_id = " + indicatordetail_id + " and c_period_id in " + " (select max(c_period_id) from mp_Response where mp_indicatordetail_id = ? and varbresponse > 0)";
            log.config("sql actual varb = " + sqlactualb);
            BigDecimal CumulatedResultActualb = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlactualb, (int)indicatordetail_id);
            String sqlactualbsuma = "SELECT coalesce(sum(varbresponse),0) from mp_Response where mp_indicatordetail_id = ?";
            BigDecimal CumulatedResultActualbsuma = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlactualbsuma, (int)indicatordetail_id);
            log.config("sql actual varb = " + sqlactualbsuma);
            if (CumulatedResultActualb == null || CumulatedResultActualb.compareTo(Env.ZERO) <= 0) {
                CumulatedResultActualb = Env.ONE;
            }
            CumulatedResultActual = CumulatedResultActual.divide(CumulatedResultActualb, 2, RoundingMode.HALF_UP);
            CumulatedResultActual = CumulatedResultActual.multiply(BigDecimal.valueOf(factor));
            if (CumulatedResultActualbsuma == null || CumulatedResultActualbsuma.compareTo(Env.ZERO) <= 0) {
                CumulatedResultActualbsuma = Env.ONE;
            }
            CumulatedResultActualsuma = CumulatedResultActualsuma.divide(CumulatedResultActualbsuma, 6, RoundingMode.HALF_UP);
            CumulatedResultActualsuma = CumulatedResultActualsuma.multiply(BigDecimal.valueOf(factor));
            CumulatedResultActualsuma = CumulatedResultActualsuma.setScale(2, RoundingMode.DOWN);
            BigDecimal Cumulated = CumulatedResultActual.divide(CumulatedResultPlan, 2, RoundingMode.HALF_UP);
            BigDecimal Cumulatedsuma = CumulatedResultActualsuma.divide(CumulatedResultPlan, 2, RoundingMode.HALF_UP);
            X_MP_IndicatorDetail i = new X_MP_IndicatorDetail(po.getCtx(), resp.getMP_IndicatorDetail_ID(), po.get_TrxName());
            String sqlintype2 = "SELECT c.indicatortype from mp_indicator c where c.mp_indicator_id = ?";
            String intype = DB.getSQLValueString((String)po.get_TrxName(), (String)sqlintype2, (int)indicator_id);
            if (intype.compareTo("01") == 0) {
                if (Cumulated.compareTo(Env.ZERO) >= 0) {
                    i.set_CustomColumn("CumulatedAmt", CumulatedResultActualsuma);
                    i.save();
                }
            } else if (intype.compareTo("02") == 0 && Cumulatedsuma.compareTo(Env.ZERO) >= 0) {
                i.set_CustomColumn("CumulatedAmt", CumulatedResultActualsuma);
                i.save();
            }
            String sqlanno2 = "SELECT coalesce(sum(expectedresult),1) from mp_planification where mp_indicator_id = " + indicator_id + " and c_period_id in (select c_period_id from c_period where extract(month from startdate) = " + mes + " and extract(year from startdate) = ?)";
            log.config("sqlanno2 = " + sqlanno2);
            BigDecimal CumulatedResultPlan2 = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlanno2, (int)year);
            log.config("planificado acumulado " + CumulatedResultPlan2);
            log.config("mes " + mes);
            String sqlactual2 = "SELECT coalesce(sum(obtained),0) from mp_response where mp_indicatordetail_id = " + resp.getMP_IndicatorDetail_ID() + " and c_period_id in (select c_period_id from c_period where extract(month from startdate) = " + mes + " and extract(year from startdate)= ?)";
            log.config("sql actual " + sqlactual2);
            BigDecimal CumulatedResultActual2 = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlactual2, (int)year);
            log.config("Obtenido acumulado " + CumulatedResultActual2);
            BigDecimal Cumulated2 = CumulatedResultActual2.divide(CumulatedResultPlan2, 2, RoundingMode.HALF_UP).multiply(Env.ONEHUNDRED);
            if (Cumulated.compareTo(Env.ZERO) > 0) {
                i.set_CustomColumn("ActualAmt", Cumulated2);
                i.save();
            }
            String sqlmeta = "SELECT coalesce(max(b.expectedresult),1) from mp_planification b where b.mp_indicator_id = ?";
            BigDecimal meta = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlmeta, (int)indicator_id);
            String sqlamt3 = "Select case when (select c.indicatortype from mp_indicator c where c.mp_indicator_id = " + indicator_id + ") like '01' " + "then a.cumulatedamt/(select coalesce(max(b.expectedresult),1) " + "from mp_planification b where b.mp_indicator_id = " + indicator_id + ") " + "else ((select coalesce(max(b.expectedresult),1) from mp_planification b " + "where b.mp_indicator_id = " + indicator_id + ")/coalesce((case when a.cumulatedamt is null then 1 when a.cumulatedamt = 0 then 1 else a.cumulatedamt end),1)) " + "end from mp_indicatordetail a where " + "a.mp_indicatordetail_id = ?";
            log.config("sqlamt3 " + sqlamt3);
            log.config("indicatordetail_id " + indicatordetail_id);
            BigDecimal AnualResult = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlamt3, (int)indicatordetail_id);
            log.config("Anual Result" + AnualResult);
            BigDecimal Ponderator = Env.ZERO;
            if (intype.compareTo("01") == 0) {
                Ponderator = AnualResult.compareTo(Env.ONEHUNDRED) == 1 ? i.getweighting() : AnualResult.multiply(i.getweighting()).divide(Env.ONEHUNDRED);
            } else if (intype.compareTo("02") == 0) {
                Ponderator = AnualResult.compareTo(Env.ONE) <= 0 ? AnualResult.multiply(i.getweighting()).divide(Env.ONEHUNDRED) : i.getweighting();
            }
            Ponderator = Ponderator.setScale(3, RoundingMode.HALF_UP);
            log.config("ponderator es " + Ponderator);
            X_MP_Indicator ind = new X_MP_Indicator(po.getCtx(), i.getMP_Indicator_ID(), po.get_TrxName());
            BigDecimal Factor = (BigDecimal)ind.get_Value("Factor");
            if (Factor == null) {
                Factor = Env.ZERO;
            }
            BigDecimal porcentajecump = Env.ZERO;
            if (intype.compareTo("01") == 0) {
                if (CumulatedResultActualsuma.compareTo(Env.ZERO) == 0) {
                    porcentajecump = Env.ZERO;
                } else if (CumulatedResultActualsuma.compareTo(meta) > 0) {
                    porcentajecump = i.getweighting();
                } else {
                    porcentajecump = CumulatedResultActualsuma;
                    porcentajecump = meta.compareTo(Env.ZERO) <= 0 ? porcentajecump.divide(Env.ONE) : porcentajecump.divide(meta, 3, RoundingMode.HALF_UP);
                    porcentajecump = porcentajecump.multiply(i.getweighting());
                }
            } else if (intype.compareTo("02") == 0) {
                if (CumulatedResultActualsuma.compareTo(Env.ZERO) == 0) {
                    porcentajecump = Env.ZERO;
                } else if (CumulatedResultActualsuma.compareTo(meta) < 0) {
                    porcentajecump = i.getweighting();
                } else {
                    porcentajecump = meta;
                    porcentajecump = CumulatedResultActualsuma.compareTo(Env.ZERO) == 0 ? porcentajecump.divide(Env.ONE) : porcentajecump.divide(CumulatedResultActualsuma, 3, RoundingMode.HALF_UP);
                    porcentajecump = porcentajecump.multiply(i.getweighting());
                }
            }
            porcentajecump = porcentajecump.setScale(2, RoundingMode.DOWN);
            i.set_CustomColumn("Amt", porcentajecump);
            i.save();
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

