/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModMINJUCashCreateOrUpdatePayment
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUCashCreateOrUpdatePayment.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Cash", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MCash cash;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == MCash.Table_ID && po.is_ValueChanged("DocStatus") && (cash = (MCash)((Object)po)).getDocStatus().compareTo("CO") == 0) {
            String sql = "SELECT count(1) from C_CashLine where CashType = 'T' AND C_Cash_ID = " + cash.get_ID();
            int counter = DB.getSQLValue((String)po.get_TrxName(), (String)sql);
            if (counter == 0) {
                MPayment pay = new MPayment(po.getCtx(), 0, po.get_TrxName());
                pay.setAD_Org_ID(cash.getAD_Org_ID());
                String documentNo = cash.getDocumentNo();
                String documentNo2 = cash.get_Value("DocumentNo").toString();
                pay.setDocumentNo(documentNo2);
                pay.setR_PnRef(documentNo2);
                pay.set_ValueNoCheck("TrxType", "X");
                pay.set_ValueNoCheck("TenderType", "X");
                pay.setC_CashBook_ID(cash.getC_CashBook_ID());
                int bankaccount = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT max(c_bankaccountref_id) from c_Cashline where c_Cash_id = " + cash.get_ID()));
                pay.setC_BankAccount_ID(bankaccount);
                pay.setC_DocType_ID(true);
                pay.setDateTrx(cash.getStatementDate());
                pay.setDateAcct(cash.getDateAcct());
                pay.setAmount(cash.getC_Currency_ID(), cash.getStatementDifference());
                pay.setDescription(cash.getDescription());
                pay.setDocStatus("CL");
                pay.setDocAction("--");
                pay.setPosted(true);
                pay.setIsAllocated(true);
                pay.setProcessed(true);
                pay.setDocStatus("CO");
                int cbpartner = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT coalesce(c_bpartner_id,0) from ad_user where ad_user_id = " + cash.getCreatedBy()));
                if (cbpartner <= 0) {
                    cbpartner = DB.getSQLValue((String)po.get_TrxName(), (String)"SELECT max(c_bpartner_id) from c_bpartner where lower(name) like '%ministerio%justicia%'");
                }
                pay.setC_BPartner_ID(cbpartner);
                pay.setTrxType("S");
                pay.setTenderType("K");
                pay.set_CustomColumn("BudgetReference", cash.get_Value("BudgetReference").toString());
                pay.set_CustomColumn("CodeBudget", cash.get_Value("CodeBudget").toString());
                pay.save();
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

