/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUCashAdvanceAmount
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUCashAdvanceAmount.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_CashLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MCashLine.Table_ID) {
            MCashLine cashline = (MCashLine)((Object)po);
            MCash cash = new MCash(po.getCtx(), cashline.getC_Cash_ID(), po.get_TrxName());
            log.config("cashline " + cashline.getCashType());
            if (cashline.getCashType().compareTo("T") == 0) {
                String sqlobtainutm = "SELECT coalesce(MultiplyRate,0) FROM C_Conversion_Rate WHERE C_Currency_ID = ?  AND ValidFrom <= '" + cash.getStatementDate() + "' AND ValidTo >= '" + cash.getStatementDate() + "'";
                int utmid = 2000001;
                log.config("sqlobtainutm " + sqlobtainutm);
                BigDecimal utmvalue = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlobtainutm, (int)utmid);
                if (utmvalue.compareTo(Env.ZERO) > 0) {
                    BigDecimal utmtop = utmvalue.multiply(new BigDecimal(15));
                    String sqlsumadvance = "SELECT coalesce(sum(abs(amount)),0) from c_Cashline where  c_cash_id = ? AND cashtype = 'T' AND c_cashline_id != " + cashline.get_ID();
                    BigDecimal utmamt = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlsumadvance, (int)cash.get_ID());
                    BigDecimal amountactual = cashline.getAmount();
                    if (amountactual.compareTo(Env.ZERO) < 0) {
                        amountactual = amountactual.negate();
                    }
                    if ((utmamt = utmamt.add(amountactual)).compareTo(utmtop) > 0) {
                        throw new AdempiereException("El monto de anticipo no puede ser superior a 15 UTM");
                    }
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

