/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.model.X_RH_MedicalLicenses;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutMedLicenses
extends CalloutEngine {
    public String EndDate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        BigDecimal newnumber;
        if (value == null) {
            return "";
        }
        Date fi = (Date)mTab.getValue("datestartrequest");
        BigDecimal qtyDays = (BigDecimal)mTab.getValue("Days");
        int qty = qtyDays.intValue();
        String LicenseType = (String)mTab.getValue("LicenseType");
        String Charac = (String)mTab.getValue("Characteristics");
        if (LicenseType.compareToIgnoreCase("MT") == 0 && Charac.compareToIgnoreCase("02") == 0) {
            qty = 126;
            newnumber = new BigDecimal(qty);
            mTab.setValue("Days", (Object)newnumber);
        }
        if (LicenseType.compareToIgnoreCase("MT") == 0 && Charac.compareToIgnoreCase("01") == 0) {
            qty = 84;
            newnumber = new BigDecimal(qty);
            mTab.setValue("Days", (Object)newnumber);
        }
        if (fi != null || qtyDays != null) {
            Date ff = CalloutMedLicenses.calculateEndDate(fi, qty);
            Timestamp cff = new Timestamp(ff.getTime());
            mTab.setValue("DateEnd", (Object)cff);
        }
        return "";
    }

    public String SetOrg(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        MBPartner bPart;
        if (value == null) {
            return "";
        }
        int ID_BPartner = (Integer)value;
        if (ID_BPartner > 0 && (bPart = new MBPartner(ctx, ID_BPartner, null)).getAD_Org_ID() > 0) {
            mTab.setValue("AD_Org_ID", (Object)bPart.get_ValueAsInt("AD_OrgRef_ID"));
        }
        return "";
    }

    public static Date calculateEndDate(Date startDate, int duration) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int i = 1;
        while (i < duration) {
            startCal.add(5, 1);
            ++i;
        }
        return startCal.getTime();
    }

    public String noNegativeValue(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        BigDecimal num = (BigDecimal)value;
        if (num.compareTo(Env.ZERO) <= 0) {
            num = num.negate();
        }
        mTab.setValue(mField.getColumnName(), (Object)num);
        return "";
    }

    public String setValuesOfBPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        int ID_BPartner = (Integer)value;
        if (ID_BPartner > 0) {
            MBPartner bPart = new MBPartner(ctx, ID_BPartner, null);
            if (bPart.get_Value("JoinDateS") != null) {
                mTab.setValue("JoinDateS", bPart.get_Value("JoinDateS"));
            }
            if (bPart.get_Value("Suplencia") != null) {
                mTab.setValue("Substitute_ID", bPart.get_Value("Suplencia"));
            }
            if (bPart.get_Value("Gender") != null) {
                mTab.setValue("Gender", bPart.get_Value("Gender"));
            }
            if (bPart.get_Value("ISAPRE") != null) {
                mTab.setValue("ISAPRE", bPart.get_Value("ISAPRE"));
            }
            if (bPart.get_Value("AFP") != null) {
                mTab.setValue("AFP", bPart.get_Value("AFP"));
            }
            if (bPart.get_Value("Estate") != null) {
                mTab.setValue("Estate", bPart.get_Value("Estate"));
            }
            if (bPart.get_Value("Suplencia") != null) {
                mTab.setValue("Substitute_ID", bPart.get_Value("Suplencia"));
            }
        }
        return "";
    }

    public String setDays(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        String charac = (String)value;
        String LicenseType = "";
        LicenseType = (String)mTab.getValue("LicenseType");
        if (charac.compareToIgnoreCase("01") == 0) {
            if (LicenseType.compareToIgnoreCase("LicenseType") == 0) {
                mTab.setValue("days", (Object)84);
            }
        } else if (charac.compareToIgnoreCase("02") == 0 && LicenseType.compareToIgnoreCase("MT") == 0) {
            mTab.setValue("days", (Object)126);
        }
        return "";
    }

    public String findOldLicense(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        Date fi = (Date)mTab.getValue("datestartrequest");
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(fi);
        startCal.add(5, -1);
        Date ff = startCal.getTime();
        Timestamp cff = new Timestamp(ff.getTime());
        int idlicencia = 0;
        if (mTab.getValue("RH_MedicalLicenses_ID") != null) {
            idlicencia = (Integer)mTab.getValue("RH_MedicalLicenses_ID");
        }
        String sqlgetoldlicense = "SELECT coalesce(max(rh_medicallicenses_id),0) from rh_medicallicenses where c_bpartner_id = " + mTab.getValue("C_BPartner_ID") + "  AND dateend = '" + cff + "' AND rh_medicallicenses_id != " + idlicencia;
        this.log.config("oldlicense " + sqlgetoldlicense);
        int oldlicense = DB.getSQLValue((String)"RH_MedicalLicenses", (String)sqlgetoldlicense);
        if (oldlicense > 0) {
            X_RH_MedicalLicenses med = new X_RH_MedicalLicenses(ctx, oldlicense, null);
            mTab.fireDataStatusEEvent("\u00bfEs licencia de continuidad?", "Licencia (FOLIO " + med.getFolio() + ") vence el d\u00eda " + cff.toLocaleString().substring(0, 10) + ".", true);
        }
        return "";
    }
}

