/*
 * Decompiled with CFR 0.152.
 */
package org.junaeb.process;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.X_GL_BudgetControlLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessRequisition
extends SvrProcess {
    private int p_Requisition_ID = 0;
    private String p_Action = "PR";
    private String p_Message = "";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else if (name.equals("Message")) {
                this.p_Message = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_Requisition_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_Requisition_ID > 0) {
            String bidding;
            MRequisition req = new MRequisition(this.getCtx(), this.p_Requisition_ID, this.get_TrxName());
            String newStatus = "DR";
            String newAction = "DR";
            String modality = req.get_Value("Modality").toString();
            this.log.config("modality " + modality);
            this.log.config("paction " + this.p_Action);
            if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "SR";
                newAction = "SR";
            } else if (req.getDocStatus().compareTo("SR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AJ";
                newAction = "AJ";
            } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0 && (modality.compareTo("CAR") == 0 || modality.compareTo("MAR") == 0)) {
                newStatus = "AB";
                newAction = "AB";
            } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0 && (modality.compareTo("CAR") == 0 || modality.compareTo("MAR") == 0)) {
                newStatus = "GA";
                newAction = "GA";
            } else if (req.getDocStatus().compareTo("GA") == 0 && this.p_Action.compareTo("CO") == 0 && (modality.compareTo("CAR") == 0 || modality.compareTo("MAR") == 0)) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "AB";
                newAction = "AB";
            } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QA";
                newAction = "QA";
            } else if (req.getDocStatus().compareTo("QA") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QB";
                newAction = "QB";
            } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "AL";
                newAction = "AL";
            } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QC";
                newAction = "QC";
            } else if (req.getDocStatus().compareTo("QC") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QD";
                newAction = "QD";
            } else if (req.getDocStatus().compareTo("QD") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "AX";
                newAction = "AX";
            } else if (req.getDocStatus().compareTo("AX") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QE";
                newAction = "QE";
            } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QF";
                newAction = "QF";
            } else if (req.getDocStatus().compareTo("QF") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "Q8";
                newAction = "Q8";
            } else if (req.getDocStatus().compareTo("Q8") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QH";
                newAction = "QH";
            } else if (req.getDocStatus().compareTo("QH") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QO";
                newAction = "QO";
            } else if (req.getDocStatus().compareTo("QO") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QI";
                newAction = "QI";
            } else if (req.getDocStatus().compareTo("QI") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QJ";
                newAction = "QJ";
            } else if (req.getDocStatus().compareTo("QJ") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QK";
                newAction = "QK";
            } else if (req.getDocStatus().compareTo("QK") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QL";
                newAction = "QL";
            } else if (req.getDocStatus().compareTo("QL") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "Q9";
                newAction = "Q9";
            } else if (req.getDocStatus().compareTo("Q9") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "Q0";
                newAction = "Q0";
            } else if (req.getDocStatus().compareTo("Q0") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QN";
                newAction = "QN";
            } else if (req.getDocStatus().compareTo("QN") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QU";
                newAction = "QU";
            } else if (req.getDocStatus().compareTo("QU") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QP";
                newAction = "QP";
            } else if (req.getDocStatus().compareTo("QP") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QQ";
                newAction = "QQ";
            } else if (req.getDocStatus().compareTo("QQ") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QR";
                newAction = "QR";
            } else if (req.getDocStatus().compareTo("QR") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QS";
                newAction = "QS";
            } else if (req.getDocStatus().compareTo("QS") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "AM";
                newAction = "AM";
            } else if (req.getDocStatus().compareTo("AM") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "QT";
                newAction = "QT";
            } else if (req.getDocStatus().compareTo("QT") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("GC") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (modality.compareTo("LIB") == 0) {
                bidding = req.get_Value("bidding_types").toString();
                if (bidding.compareTo("L1") == 0) {
                    if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "GA";
                        newAction = "GA";
                    } else if (req.getDocStatus().compareTo("GA") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "PP";
                        newAction = "PP";
                    } else if (req.getDocStatus().compareTo("PP") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AB";
                        newAction = "AB";
                    } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QV";
                        newAction = "QV";
                    } else if (req.getDocStatus().compareTo("QV") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AR";
                        newAction = "AR";
                    } else if (req.getDocStatus().compareTo("AR") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QB";
                        newAction = "QB";
                    } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AL";
                        newAction = "AL";
                    } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AA";
                        newAction = "AA";
                    } else if (req.getDocStatus().compareTo("AA") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QE";
                        newAction = "QE";
                    } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QW";
                        newAction = "QW";
                    } else if (req.getDocStatus().compareTo("QW") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q5";
                        newAction = "Q5";
                    } else if (req.getDocStatus().compareTo("Q5") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QG";
                        newAction = "QG";
                    } else if (req.getDocStatus().compareTo("QG") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QY";
                        newAction = "QY";
                    } else if (req.getDocStatus().compareTo("QY") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q6";
                        newAction = "Q6";
                    } else if (req.getDocStatus().compareTo("Q6") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QH";
                        newAction = "QH";
                    } else if (req.getDocStatus().compareTo("QH") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QO";
                        newAction = "QO";
                    } else if (req.getDocStatus().compareTo("QO") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q1";
                        newAction = "Q1";
                    } else if (req.getDocStatus().compareTo("Q1") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QL";
                        newAction = "QL";
                    } else if (req.getDocStatus().compareTo("QL") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "CO";
                        newAction = "CO";
                    }
                } else if (bidding.compareTo("LE") == 0) {
                    if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AB";
                        newAction = "AB";
                    } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QA";
                        newAction = "QA";
                    } else if (req.getDocStatus().compareTo("QA") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QB";
                        newAction = "QB";
                    } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AL";
                        newAction = "AL";
                    } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QC";
                        newAction = "QC";
                    } else if (req.getDocStatus().compareTo("QC") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QD";
                        newAction = "QD";
                    } else if (req.getDocStatus().compareTo("QD") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AX";
                        newAction = "AX";
                    } else if (req.getDocStatus().compareTo("AX") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QE";
                        newAction = "QE";
                    } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q2";
                        newAction = "Q2";
                    } else if (req.getDocStatus().compareTo("Q2") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QG";
                        newAction = "QG";
                    } else if (req.getDocStatus().compareTo("QG") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QH";
                        newAction = "QH";
                    } else if (req.getDocStatus().compareTo("QH") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QO";
                        newAction = "QO";
                    } else if (req.getDocStatus().compareTo("QO") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q3";
                        newAction = "Q3";
                    } else if (req.getDocStatus().compareTo("Q3") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QJ";
                        newAction = "QJ";
                    } else if (req.getDocStatus().compareTo("QJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QK";
                        newAction = "QK";
                    } else if (req.getDocStatus().compareTo("QK") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QL";
                        newAction = "QL";
                    } else if (req.getDocStatus().compareTo("QL") == 0 && this.p_Action.compareTo("CO") == 0) {
                        if (req.get_ValueAsBoolean("GenerateContract")) {
                            newStatus = "Q7";
                            newAction = "Q7";
                        } else if (!req.get_ValueAsBoolean("GenerateContract")) {
                            newStatus = "CO";
                            newAction = "CO";
                        }
                    } else if (req.getDocStatus().compareTo("Q7") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QM";
                        newAction = "QM";
                    } else if (req.getDocStatus().compareTo("QM") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QN";
                        newAction = "QN";
                    } else if (req.getDocStatus().compareTo("QN") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QU";
                        newAction = "QU";
                    } else if (req.getDocStatus().compareTo("QU") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QP";
                        newAction = "QP";
                    } else if (req.getDocStatus().compareTo("QP") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QQ";
                        newAction = "QQ";
                    } else if (req.getDocStatus().compareTo("QQ") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QR";
                        newAction = "QR";
                    } else if (req.getDocStatus().compareTo("QR") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QS";
                        newAction = "QS";
                    } else if (req.getDocStatus().compareTo("QS") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AM";
                        newAction = "AM";
                    } else if (req.getDocStatus().compareTo("AM") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QT";
                        newAction = "QT";
                    } else if (req.getDocStatus().compareTo("QT") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "CO";
                        newAction = "CO";
                    }
                } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "AB";
                    newAction = "AB";
                } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QA";
                    newAction = "QA";
                } else if (req.getDocStatus().compareTo("QA") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QB";
                    newAction = "QB";
                } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "AL";
                    newAction = "AL";
                } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QC";
                    newAction = "QC";
                } else if (req.getDocStatus().compareTo("QC") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QD";
                    newAction = "QD";
                } else if (req.getDocStatus().compareTo("QD") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "AX";
                    newAction = "AX";
                } else if (req.getDocStatus().compareTo("AX") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QE";
                    newAction = "QE";
                } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "Q2";
                    newAction = "Q2";
                } else if (req.getDocStatus().compareTo("Q2") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QG";
                    newAction = "QG";
                } else if (req.getDocStatus().compareTo("QG") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QH";
                    newAction = "QH";
                } else if (req.getDocStatus().compareTo("QH") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QO";
                    newAction = "QO";
                } else if (req.getDocStatus().compareTo("QO") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "Q3";
                    newAction = "Q3";
                } else if (req.getDocStatus().compareTo("Q3") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QJ";
                    newAction = "QJ";
                } else if (req.getDocStatus().compareTo("QJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QK";
                    newAction = "QK";
                } else if (req.getDocStatus().compareTo("QK") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QL";
                    newAction = "QL";
                } else if (req.getDocStatus().compareTo("QL") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "Q7";
                    newAction = "Q7";
                } else if (req.getDocStatus().compareTo("Q7") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QM";
                    newAction = "QM";
                } else if (req.getDocStatus().compareTo("QM") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QN";
                    newAction = "QN";
                } else if (req.getDocStatus().compareTo("QN") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QU";
                    newAction = "QU";
                } else if (req.getDocStatus().compareTo("QU") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QP";
                    newAction = "QP";
                } else if (req.getDocStatus().compareTo("QP") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QQ";
                    newAction = "QQ";
                } else if (req.getDocStatus().compareTo("QQ") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QR";
                    newAction = "QR";
                } else if (req.getDocStatus().compareTo("QR") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QS";
                    newAction = "QS";
                } else if (req.getDocStatus().compareTo("QS") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "AM";
                    newAction = "AM";
                } else if (req.getDocStatus().compareTo("AM") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QT";
                    newAction = "QT";
                } else if (req.getDocStatus().compareTo("QT") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "CO";
                    newAction = "CO";
                }
            } else if (modality.compareTo("LIC") == 0) {
                bidding = req.get_Value("bidding_types1").toString();
                if (bidding.compareTo("E2") == 0) {
                    if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "GA";
                        newAction = "GA";
                    } else if (req.getDocStatus().compareTo("GA") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "PP";
                        newAction = "PP";
                    } else if (req.getDocStatus().compareTo("PP") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AB";
                        newAction = "AB";
                    } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QV";
                        newAction = "QV";
                    } else if (req.getDocStatus().compareTo("QV") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AR";
                        newAction = "AR";
                    } else if (req.getDocStatus().compareTo("AR") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QB";
                        newAction = "QB";
                    } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AL";
                        newAction = "AL";
                    } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AA";
                        newAction = "AA";
                    } else if (req.getDocStatus().compareTo("AA") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QE";
                        newAction = "QE";
                    } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QW";
                        newAction = "QW";
                    } else if (req.getDocStatus().compareTo("QW") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q5";
                        newAction = "Q5";
                    } else if (req.getDocStatus().compareTo("Q5") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QG";
                        newAction = "QG";
                    } else if (req.getDocStatus().compareTo("QG") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QY";
                        newAction = "QY";
                    } else if (req.getDocStatus().compareTo("QY") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q6";
                        newAction = "Q6";
                    } else if (req.getDocStatus().compareTo("Q6") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QH";
                        newAction = "QH";
                    } else if (req.getDocStatus().compareTo("QH") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QO";
                        newAction = "QO";
                    } else if (req.getDocStatus().compareTo("QO") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q1";
                        newAction = "Q1";
                    } else if (req.getDocStatus().compareTo("Q1") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QL";
                        newAction = "QL";
                    } else if (req.getDocStatus().compareTo("QL") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "CO";
                        newAction = "CO";
                    }
                } else if (bidding.compareTo("CO") == 0) {
                    if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AB";
                        newAction = "AB";
                    } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QA";
                        newAction = "QA";
                    } else if (req.getDocStatus().compareTo("QA") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QB";
                        newAction = "QB";
                    } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AL";
                        newAction = "AL";
                    } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QC";
                        newAction = "QC";
                    } else if (req.getDocStatus().compareTo("QC") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QD";
                        newAction = "QD";
                    } else if (req.getDocStatus().compareTo("QD") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AX";
                        newAction = "AX";
                    } else if (req.getDocStatus().compareTo("AX") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QE";
                        newAction = "QE";
                    } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q2";
                        newAction = "Q2";
                    } else if (req.getDocStatus().compareTo("Q2") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QG";
                        newAction = "QG";
                    } else if (req.getDocStatus().compareTo("QG") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QH";
                        newAction = "QH";
                    } else if (req.getDocStatus().compareTo("QH") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QO";
                        newAction = "QO";
                    } else if (req.getDocStatus().compareTo("QO") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "Q3";
                        newAction = "Q3";
                    } else if (req.getDocStatus().compareTo("Q3") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QJ";
                        newAction = "QJ";
                    } else if (req.getDocStatus().compareTo("QJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QK";
                        newAction = "QK";
                    } else if (req.getDocStatus().compareTo("QK") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QL";
                        newAction = "QL";
                    } else if (req.getDocStatus().compareTo("QL") == 0 && this.p_Action.compareTo("CO") == 0) {
                        if (req.get_ValueAsBoolean("GenerateContract")) {
                            newStatus = "Q7";
                            newAction = "Q7";
                        } else if (!req.get_ValueAsBoolean("GenerateContract")) {
                            newStatus = "CO";
                            newAction = "CO";
                        }
                    } else if (req.getDocStatus().compareTo("Q7") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QM";
                        newAction = "QM";
                    } else if (req.getDocStatus().compareTo("QM") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QN";
                        newAction = "QN";
                    } else if (req.getDocStatus().compareTo("QN") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QU";
                        newAction = "QU";
                    } else if (req.getDocStatus().compareTo("QU") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QP";
                        newAction = "QP";
                    } else if (req.getDocStatus().compareTo("QP") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QQ";
                        newAction = "QQ";
                    } else if (req.getDocStatus().compareTo("QQ") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QR";
                        newAction = "QR";
                    } else if (req.getDocStatus().compareTo("QR") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QS";
                        newAction = "QS";
                    } else if (req.getDocStatus().compareTo("QS") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "AM";
                        newAction = "AM";
                    } else if (req.getDocStatus().compareTo("AM") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "QT";
                        newAction = "QT";
                    } else if (req.getDocStatus().compareTo("QT") == 0 && this.p_Action.compareTo("CO") == 0) {
                        newStatus = "CO";
                        newAction = "CO";
                    }
                } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "AB";
                    newAction = "AB";
                } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QA";
                    newAction = "QA";
                } else if (req.getDocStatus().compareTo("QA") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QB";
                    newAction = "QB";
                } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "AL";
                    newAction = "AL";
                } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QC";
                    newAction = "QC";
                } else if (req.getDocStatus().compareTo("QC") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QD";
                    newAction = "QD";
                } else if (req.getDocStatus().compareTo("QD") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "AX";
                    newAction = "AX";
                } else if (req.getDocStatus().compareTo("AX") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QE";
                    newAction = "QE";
                } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "Q2";
                    newAction = "Q2";
                } else if (req.getDocStatus().compareTo("Q2") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QG";
                    newAction = "QG";
                } else if (req.getDocStatus().compareTo("QG") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QH";
                    newAction = "QH";
                } else if (req.getDocStatus().compareTo("QH") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QO";
                    newAction = "QO";
                } else if (req.getDocStatus().compareTo("QO") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "Q3";
                    newAction = "Q3";
                } else if (req.getDocStatus().compareTo("Q3") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QJ";
                    newAction = "QJ";
                } else if (req.getDocStatus().compareTo("QJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QK";
                    newAction = "QK";
                } else if (req.getDocStatus().compareTo("QK") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QL";
                    newAction = "QL";
                } else if (req.getDocStatus().compareTo("QL") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "Q7";
                    newAction = "Q7";
                } else if (req.getDocStatus().compareTo("Q7") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QM";
                    newAction = "QM";
                } else if (req.getDocStatus().compareTo("QM") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QN";
                    newAction = "QN";
                } else if (req.getDocStatus().compareTo("QN") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QU";
                    newAction = "QU";
                } else if (req.getDocStatus().compareTo("QU") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QP";
                    newAction = "QP";
                } else if (req.getDocStatus().compareTo("QP") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QQ";
                    newAction = "QQ";
                } else if (req.getDocStatus().compareTo("QQ") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QR";
                    newAction = "QR";
                } else if (req.getDocStatus().compareTo("QR") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QS";
                    newAction = "QS";
                } else if (req.getDocStatus().compareTo("QS") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "AM";
                    newAction = "AM";
                } else if (req.getDocStatus().compareTo("AM") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "QT";
                    newAction = "QT";
                } else if (req.getDocStatus().compareTo("QT") == 0 && this.p_Action.compareTo("CO") == 0) {
                    newStatus = "CO";
                    newAction = "CO";
                }
            } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "AB";
                newAction = "AB";
            } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "QA";
                newAction = "QA";
            } else if (req.getDocStatus().compareTo("QA") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "QB";
                newAction = "QB";
            } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "AL";
                newAction = "AL";
            } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "QC";
                newAction = "QC";
            } else if (req.getDocStatus().compareTo("QC") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "QD";
                newAction = "QD";
            } else if (req.getDocStatus().compareTo("QD") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "AX";
                newAction = "AX";
            } else if (req.getDocStatus().compareTo("AX") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "QE";
                newAction = "QE";
            } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("DIR") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "AB";
                newAction = "AB";
            } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "GA";
                newAction = "GA";
            } else if (req.getDocStatus().compareTo("GA") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "PP";
                newAction = "PP";
            } else if (req.getDocStatus().compareTo("PP") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "QV";
                newAction = "QV";
            } else if (req.getDocStatus().compareTo("QV") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "AR";
                newAction = "AR";
            } else if (req.getDocStatus().compareTo("AR") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "QB";
                newAction = "QB";
            } else if (req.getDocStatus().compareTo("QB") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "AL";
                newAction = "AL";
            } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "Q4";
                newAction = "Q4";
            } else if (req.getDocStatus().compareTo("Q4") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "AA";
                newAction = "AA";
            } else if (req.getDocStatus().compareTo("AA") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "QE";
                newAction = "QE";
            } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("3ME") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("ME3") == 0) {
                newStatus = "AB";
                newAction = "AB";
            } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("ME3") == 0) {
                newStatus = "GA";
                newAction = "GA";
            } else if (req.getDocStatus().compareTo("GA") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("ME3") == 0) {
                newStatus = "PP";
                newAction = "PP";
            } else if (req.getDocStatus().compareTo("PP") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("ME3") == 0) {
                newStatus = "QV";
                newAction = "QV";
            } else if (req.getDocStatus().compareTo("QV") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("ME3") == 0) {
                newStatus = "AR";
                newAction = "AR";
            } else if (req.getDocStatus().compareTo("AR") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("ME3") == 0) {
                newStatus = "AA";
                newAction = "AA";
            } else if (req.getDocStatus().compareTo("AA") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("ME3") == 0) {
                newStatus = "QE";
                newAction = "QE";
            } else if (req.getDocStatus().compareTo("QE") == 0 && this.p_Action.compareTo("CO") == 0 && modality.compareTo("ME3") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("SR") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("GA") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AL") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AA") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AX") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("PP") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AM") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            }
            int cant = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_Document_Action_Access daa INNER JOIN AD_Ref_List rl ON (daa.AD_Ref_List_ID = rl.AD_Ref_List_ID)  WHERE value = '" + newAction + "' AND AD_Role_ID = " + Env.getAD_Role_ID((Properties)this.getCtx()) + " AND C_DocType_ID = " + req.getC_DocType_ID()));
            this.log.config("cantidad" + cant);
            if (cant > 0) {
                if (newAction.compareTo("CO") != 0) {
                    req.setDocStatus(newStatus);
                    if (newAction.compareTo("DR") == 0) {
                        int ID_Org_Original;
                        req.set_CustomColumn("Comments2", "*** Solicitud devuelta ***");
                        String prevmessage = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT comments3 from m_requisition where m_requisition_id = ? ", (int)req.get_ID());
                        if (prevmessage != null) {
                            req.set_CustomColumn("Comments3", String.valueOf(prevmessage) + " - " + this.p_Message);
                        } else {
                            req.set_CustomColumn("Comments3", this.p_Message);
                        }
                        String wf = req.get_ValueAsString("IsWorkflow");
                        this.log.config("isworkflow = " + wf);
                        if (wf.compareTo("true") == 0 && (ID_Org_Original = req.get_ValueAsInt("AD_OrgRef_ID")) > 0) {
                            req.setAD_Org_ID(ID_Org_Original);
                            DB.executeUpdate((String)("UPDATE m_requisitionline set ad_org_id = " + ID_Org_Original + " where m_requisition_id = " + req.get_ID()), (String)this.get_TrxName());
                        }
                        req.save();
                        CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                        cst.setInt(2, 8);
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                    } else if (newAction.compareTo("SR") == 0) {
                        String sqlatt = "select ad_attachment_id from ad_attachment where ad_table_id = 702 and record_id = " + req.get_ID();
                        CPreparedStatement pstmt = DB.prepareStatement((String)sqlatt, (String)this.get_TrxName());
                        ResultSet rs = pstmt.executeQuery();
                        int att = 0;
                        while (rs.next()) {
                            ++att;
                        }
                        if (att <= 0) {
                            throw new AdempiereException("No se ha encontrado adjuntos");
                        }
                        req.set_CustomColumn("Comments2", "");
                        int countlines = DB.getSQLValue((String)req.get_TrxName(), (String)("SELECT count(1) FROM m_requisitionline where m_requisition_id = " + req.get_ID()));
                        if (countlines == 0) {
                            throw new AdempiereException("La solicitud no tiene l\u00edneas");
                        }
                        String wf = req.get_ValueAsString("IsWorkflow");
                        this.log.config("isworkflow = " + wf);
                        if (wf.compareTo("true") == 0) {
                            int ID_Org = req.get_ValueAsInt("AD_OrgRef2_ID");
                            req.set_CustomColumn("AD_OrgRef_ID", req.getAD_Org_ID());
                            req.setAD_Org_ID(ID_Org);
                            DB.executeUpdate((String)("UPDATE m_requisitionline set ad_org_id = " + ID_Org + " where m_requisition_id = " + req.get_ID()), (String)this.get_TrxName());
                        }
                        req.save();
                        CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                        cst.setInt(2, 9);
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                    } else if (newAction.compareTo("AJ") == 0) {
                        req.set_CustomColumn("DateReturn", new Timestamp(System.currentTimeMillis()));
                        req.save();
                        CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                        cst.setInt(2, 10);
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                        MCurrency curreTo = new MCurrency(this.getCtx(), 228, this.get_TrxName());
                        BigDecimal MultiplyRate = null;
                        if (req.get_ValueAsInt("C_Currency_ID") != curreTo.get_ID()) {
                            if (MultiplyRate == null || MultiplyRate.signum() == 0) {
                                MultiplyRate = MConversionRate.getRate(req.get_ValueAsInt("C_Currency_ID"), curreTo.get_ID(), req.getDateDoc(), req.get_ValueAsInt("C_ConversionType_ID"), req.getAD_Client_ID(), req.getAD_Org_ID());
                            }
                            this.log.config("currency = " + req.get_ValueAsInt("C_Currency_ID") + " - To_Currency=" + curreTo.get_ID() + "- Date=" + req.getDateDoc() + "-Conversion=" + req.get_ValueAsInt("C_ConversionType_ID"));
                            if (MultiplyRate == null || MultiplyRate.compareTo(Env.ZERO) <= 0) {
                                throw new AdempiereUserError("Por favor definir el tipo de cambio", "Conversion Monetaria");
                            }
                        } else {
                            MultiplyRate = Env.ONE;
                        }
                        MRequisitionLine[] lines = req.getLines();
                        int i = 0;
                        while (i < lines.length) {
                            MRequisitionLine rLine = lines[i];
                            if (rLine.get_ValueAsInt("GL_BudgetControlLine_ID") > 0) {
                                X_GL_BudgetControlLine bcLine = new X_GL_BudgetControlLine(this.getCtx(), rLine.get_ValueAsInt("GL_BudgetControlLine_ID"), this.get_TrxName());
                                BigDecimal usedAmt = (BigDecimal)bcLine.get_Value("Amount2");
                                if (usedAmt == null) {
                                    usedAmt = Env.ZERO;
                                }
                                BigDecimal amtConvert = rLine.getLineNetAmt().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6);
                                if (rLine.get_ValueAsBoolean("IsTaxed")) {
                                    amtConvert = amtConvert.multiply(new BigDecimal("1.19"));
                                }
                                usedAmt = usedAmt.add(amtConvert);
                                bcLine.set_CustomColumn("Amount2", usedAmt);
                                bcLine.save();
                            }
                            ++i;
                        }
                    } else if (newAction.compareTo("AB") == 0) {
                        req.save();
                        CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                        cst.setInt(2, 11);
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                    } else if (newAction.compareTo("GA") == 0) {
                        req.save();
                        CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                        String hascontract = req.get_ValueAsString("HasContract");
                        this.log.config("hascontract = " + hascontract);
                        if (modality.compareTo("CAR") == 0 && hascontract.compareTo("true") == 0) {
                            cst.setInt(2, 40);
                        } else {
                            cst.setInt(2, 12);
                        }
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                    } else if (newAction.compareTo("AX") == 0 || newAction.compareTo("PP") == 0 || newAction.compareTo("AL") == 0 || newAction.compareTo("AA") == 0 || newAction.compareTo("AM") == 0) {
                        req.save();
                    } else {
                        req.save();
                    }
                } else if (newAction.compareTo("CO") == 0) {
                    req.setDocStatus("IP");
                    req.processIt("CO");
                    req.save();
                }
            } else {
                throw new AdempiereException("Error: Permisos de rol insuficientes");
            }
        }
        return "Procesado";
    }
}

