/*
 * Decompiled with CFR 0.152.
 */
package org.junaeb.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAsset;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.X_A_Asset_Use;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;

public class ProcessCreateAsset
extends SvrProcess {
    private int p_ID_Invoice = 0;

    protected void prepare() {
        this.p_ID_Invoice = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_ID_Invoice > 0) {
            MInvoice inv = new MInvoice(this.getCtx(), this.p_ID_Invoice, this.get_TrxName());
            MDocType dType = new MDocType(this.getCtx(), inv.getC_DocTypeTarget_ID(), this.get_TrxName());
            String sqlcount = "SELECT count(1) from c_invoiceline where c_invoice_id = " + inv.get_ID();
            int counter = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcount);
            if (counter <= 0) {
                inv.set_CustomColumn("ErrorMsg", "DEBE INGRESAR LINEAS DE DOCUMENTO");
                inv.save();
                return "";
            }
            inv.set_CustomColumn("ErrorMsg", "");
            if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("ALT") == 0) {
                int cantLine = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM C_InvoiceLine WHERE IsActive = 'Y' AND C_Invoice_ID = " + inv.get_ID()));
                String msgError = null;
                if (cantLine != inv.get_ValueAsInt("ValidCantLine")) {
                    msgError = "ERROR EN CAMPO: CANTIDAD DE ACTIVOS NO CORRESPONDE CON LINEAS";
                    String nameField = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT name FROM AD_Field_Trl  WHERE AD_Field_ID=2003920 AND AD_Language='es_MX'", (Object[])new Object[0]);
                    if (nameField != null && nameField.trim().length() > 0) {
                        msgError = "ERROR EN CAMPO " + nameField + ": CANTIDAD DE ACTIVOS NO CORRESPONDE CON LINEAS";
                    }
                }
                if (msgError != null && msgError.trim().length() > 0) {
                    inv.set_CustomColumn("ErrorMsg", msgError);
                } else {
                    this.createAsset(inv, dType);
                    inv.set_CustomColumn("ErrorMsg", "PROCESO DE ALTA COMPLETADO");
                    inv.setDocStatus("CO");
                    inv.setProcessed(true);
                }
            } else if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("TRA") == 0) {
                this.transferAsset(inv, dType);
                inv.setDocStatus("CO");
                inv.setProcessed(true);
            } else if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("MOD") == 0) {
                this.updateAsset(inv, dType);
                inv.setDocStatus("CO");
                inv.setProcessed(true);
            } else if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("BAJ") == 0 && dType.get_ID() == 1000004) {
                boolean flag = false;
                MInvoiceLine[] lines = inv.getLines(false);
                int lineIndex = 0;
                while (lineIndex < lines.length) {
                    String martillero;
                    String lote;
                    Timestamp dateStart;
                    MInvoiceLine iLine = lines[lineIndex];
                    BigDecimal Vlr_Subasta = (BigDecimal)iLine.get_Value("Vlr_Subasta");
                    if (Vlr_Subasta == null) {
                        Vlr_Subasta = Env.ZERO;
                    }
                    if (Vlr_Subasta.compareTo(Env.ZERO) <= 0) {
                        flag = true;
                    }
                    if ((dateStart = (Timestamp)iLine.get_Value("Fecha_Subasta")) == null) {
                        flag = true;
                    }
                    if ((lote = iLine.get_ValueAsString("Lot")) == null || lote == "") {
                        flag = true;
                    }
                    if ((martillero = iLine.get_ValueAsString("Martillero")) == null || martillero == "") {
                        flag = true;
                    }
                    ++lineIndex;
                }
                if (flag) {
                    this.degradeAssetInProcess(inv, dType);
                    inv.setDocStatus("IP");
                    String updateasset = "UPDATE a_Asset SET AssetSituation='ENP' WHERE A_Asset_ID in (SELECT A_Asset_ID from  C_InvoiceLine WHERE C_Invoice_ID = " + inv.getC_Invoice_ID() + ")";
                    DB.executeUpdate((String)updateasset, (String)inv.get_TrxName());
                } else if (!flag) {
                    inv.set_CustomColumn("ErrorMsg", "");
                    this.degradeAsset(inv, dType);
                    inv.setDocStatus("CO");
                    inv.setProcessed(true);
                }
            } else if (inv.getDocStatus().compareTo("DR") == 0 && dType.get_ValueAsString("Type1").compareTo("BAJ") == 0) {
                String msgError = null;
                MInvoiceLine[] lines = inv.getLines(false);
                int lineIndex = 0;
                while (lineIndex < lines.length) {
                    MInvoiceLine iLine = lines[lineIndex];
                    if (inv.getC_DocTypeTarget_ID() == 1000004) {
                        BigDecimal Vlr_Subasta = (BigDecimal)iLine.get_Value("Vlr_Subasta");
                        if (Vlr_Subasta == null) {
                            Vlr_Subasta = Env.ZERO;
                        }
                        if (Vlr_Subasta.compareTo(Env.ZERO) <= 0) {
                            msgError = "Todos los activos deben tener valor de subasta. Linea:" + iLine.getLine() / 10;
                            break;
                        }
                    }
                    ++lineIndex;
                }
                if (msgError != null && msgError.trim().length() > 0) {
                    inv.set_CustomColumn("ErrorMsg", msgError);
                } else {
                    this.degradeAsset(inv, dType);
                    inv.set_CustomColumn("ErrorMsg", "");
                    inv.setDocStatus("CO");
                    inv.setProcessed(true);
                }
            } else if (inv.getDocStatus().compareTo("IP") == 0 && dType.get_ValueAsString("Type1").compareTo("BAJ") == 0 && dType.get_ID() == 1000004) {
                String msgError = null;
                boolean flag = false;
                MInvoiceLine[] lines = inv.getLines(false);
                int lineIndex = 0;
                while (lineIndex < lines.length) {
                    String martillero;
                    String lote;
                    Timestamp dateStart;
                    MInvoiceLine iLine = lines[lineIndex];
                    BigDecimal Vlr_Subasta = (BigDecimal)iLine.get_Value("Vlr_Subasta");
                    if (Vlr_Subasta == null) {
                        Vlr_Subasta = Env.ZERO;
                    }
                    if (Vlr_Subasta.compareTo(Env.ZERO) <= 0) {
                        flag = true;
                    }
                    if ((dateStart = (Timestamp)iLine.get_Value("Fecha_Subasta")) == null) {
                        flag = true;
                    }
                    if ((lote = iLine.get_ValueAsString("Lot")) == null || lote == "") {
                        flag = true;
                    }
                    if ((martillero = iLine.get_ValueAsString("Martillero")) == null || martillero == "") {
                        flag = true;
                    }
                    ++lineIndex;
                }
                if (flag) {
                    msgError = "RECUERDE INGRESAR VALOR VALOR SUBASTA, FECHA SUBASTA, MARTILLERO Y LOTE";
                    inv.set_CustomColumn("ErrorMsg", msgError);
                } else if (!flag) {
                    inv.set_CustomColumn("ErrorMsg", "");
                    this.degradeAsset(inv, dType);
                    inv.setDocStatus("CO");
                    inv.setProcessed(true);
                }
            } else if (inv.getDocStatus().compareTo("IP") == 0 && dType.get_ValueAsString("Type1").compareTo("BAJ") == 0) {
                inv.set_CustomColumn("ErrorMsg", "");
                this.degradeAsset(inv, dType);
                inv.setDocStatus("CO");
                inv.setProcessed(true);
            }
            inv.saveEx();
        }
        return "Procesado";
    }

    public void createAsset(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int group_ID = 0;
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (this.isAsset(iLine) && iLine.isActive() && iLine.get_ValueAsString("A_CapvsExp").equals("Cap")) {
                group_ID = iLine.get_ValueAsInt("A_Asset_Group_Ref2_ID");
                if (group_ID <= 0 && (group_ID = DB.getSQLValue((String)inv.get_TrxName(), (String)"select a_asset_group_id from a_asset_group where isdefault='Y'")) <= 0) {
                    throw new AdempiereException("no default asset group. Linea:" + iLine.getLine() / 10);
                }
                DB.executeUpdate((String)("UPDATE C_InvoiceLine SET A_Asset_Group_ID = " + group_ID + " WHERE C_InvoiceLine_ID = " + iLine.get_ID()), (String)this.get_TrxName());
                BigDecimal qtyAsset = iLine.getQtyEntered();
                MAsset asset = new MAsset(inv.getCtx(), 0, inv.get_TrxName());
                asset.setName(iLine.getDescription());
                asset.setAD_Org_ID(iLine.getAD_Org_ID());
                asset.setAssetServiceDate(inv.getDateInvoiced());
                asset.setQty(qtyAsset);
                asset.setA_Asset_Group_ID(group_ID);
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    asset.setAD_User_ID(iLine.get_ValueAsInt("AD_user_ID"));
                }
                asset.set_CustomColumn("Brand", iLine.get_ValueAsString("Brand"));
                asset.set_CustomColumn("Model", iLine.get_ValueAsString("Model"));
                asset.set_CustomColumn("SerNo", iLine.get_ValueAsString("SerNo"));
                asset.set_CustomColumn("Color", iLine.get_ValueAsString("Color"));
                if (iLine.get_ValueAsString("AssetStatus") != null && iLine.get_ValueAsString("AssetStatus").trim().length() > 0) {
                    asset.set_CustomColumn("AssetStatus", iLine.get_ValueAsString("AssetStatus"));
                }
                asset.set_CustomColumn("A_Parent_Asset_ID", iLine.get_ValueAsInt("A_Parent_Asset_ID"));
                if (iLine.get_ValueAsString("Type1") != null && iLine.get_ValueAsString("Type1").trim().length() > 0) {
                    asset.set_CustomColumn("Type1", iLine.get_ValueAsString("Type1"));
                }
                asset.set_CustomColumn("Rol", iLine.get_ValueAsString("Rol"));
                asset.set_CustomColumn("GroundSurface", (BigDecimal)iLine.get_Value("GroundSurface"));
                asset.set_CustomColumn("EdificationSurface", (BigDecimal)iLine.get_Value("EdificationSurface"));
                asset.set_CustomColumn("Engine", iLine.get_ValueAsString("Engine"));
                asset.set_CustomColumn("Chassis", iLine.get_ValueAsString("Chassis"));
                asset.set_CustomColumn("LicensePlate", iLine.get_ValueAsString("LicensePlate"));
                asset.set_CustomColumn("Digito", iLine.get_ValueAsString("Digito"));
                asset.set_CustomColumn("Sigla", iLine.get_ValueAsString("Sigla"));
                asset.set_CustomColumn("Fojas", iLine.get_ValueAsString("Fojas"));
                asset.set_CustomColumn("RegistrationNumber", iLine.get_ValueAsString("RegistrationNumber"));
                asset.set_CustomColumn("Year", iLine.get_ValueAsString("Year"));
                if (iLine.get_ValueAsString("Inmueble") != null) {
                    asset.set_CustomColumn("Inmueble", iLine.get_ValueAsString("Inmueble"));
                }
                if (iLine.get_ValueAsInt("C_Region_ID") > 0) {
                    asset.set_CustomColumn("C_Region_ID", iLine.get_ValueAsInt("C_Region_ID"));
                }
                if (iLine.get_ValueAsInt("C_Province_ID") > 0) {
                    asset.set_CustomColumn("C_Province_ID", iLine.get_ValueAsInt("C_Province_ID"));
                }
                if (iLine.get_ValueAsInt("C_City_ID") > 0) {
                    asset.set_CustomColumn("C_City_ID", iLine.get_ValueAsString("C_City_ID"));
                }
                if (iLine.get_ValueAsString("DocDestination") != null && iLine.get_ValueAsString("DocDestination").trim().length() > 0) {
                    asset.set_CustomColumn("DocDestination", iLine.get_ValueAsString("DocDestination"));
                }
                asset.set_CustomColumn("DocNumber", iLine.get_ValueAsString("DocNumber"));
                asset.set_CustomColumn("Conservador", iLine.get_ValueAsString("Conservador"));
                asset.set_CustomColumn("Notaria", iLine.get_ValueAsString("Notaria"));
                asset.set_CustomColumn("N_Fecha_ValeVista", iLine.get_ValueAsString("N_Fecha_ValeVista"));
                asset.set_CustomColumn("Vlr_ValeVista", (BigDecimal)iLine.get_Value("Vlr_ValeVista"));
                asset.set_CustomColumn("Fecha_Subasta", (Timestamp)iLine.get_Value("Fecha_Subasta"));
                asset.set_CustomColumn("Vlr_Subasta", (BigDecimal)iLine.get_Value("Vlr_Subasta"));
                asset.set_CustomColumn("Lot", iLine.get_ValueAsString("Lot"));
                asset.set_CustomColumn("Martillero", iLine.get_ValueAsString("Martillero"));
                asset.set_CustomColumn("ParentAsset", iLine.get_ValueAsString("ParentAsset"));
                asset.set_CustomColumn("Date1", (Timestamp)iLine.get_Value("Date1"));
                asset.set_CustomColumn("ExpirationDate", (Timestamp)iLine.get_Value("ExpirationDate"));
                asset.set_CustomColumn("Renewable", iLine.get_ValueAsString("Renewable"));
                if (iLine.get_ValueAsInt("A_Asset_Group_Ref_ID") > 0) {
                    asset.set_CustomColumn("A_Asset_Group_Ref_ID", iLine.get_ValueAsInt("A_Asset_Group_Ref_ID"));
                }
                if (dType.get_ID() == 1000003) {
                    asset.set_CustomColumn("AssetSituation", "COM");
                } else {
                    asset.set_CustomColumn("AssetSituation", "ALT");
                }
                asset.set_CustomColumn("GrandTotal", iLine.getPriceEntered());
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    asset.set_CustomColumn("S_Resource_ID", iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    asset.set_CustomColumn("S_ResourceRef_ID", iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                asset.set_CustomColumn("A_Asset_Group_Ref2_ID", iLine.get_ValueAsInt("A_Asset_Group_Ref3_ID"));
                int id_utm = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Currency_ID) FROM C_Currency WHERE Description like 'UTM' ");
                BigDecimal totalAmtLineCLP = iLine.getPriceEntered();
                if (id_utm > 0) {
                    BigDecimal amt3UTMclp = MConversionRate.convert(this.getCtx(), new BigDecimal("3.0"), id_utm, inv.getC_Currency_ID(), (Timestamp)inv.get_Value("DateDoc"), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
                    if (inv.getC_Currency_ID() != 228) {
                        totalAmtLineCLP = MConversionRate.convert(this.getCtx(), iLine.getPriceEntered(), inv.getC_Currency_ID(), 228, (Timestamp)inv.get_Value("DateDoc"), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
                    }
                    try {
                        if (totalAmtLineCLP.compareTo(amt3UTMclp) >= 0) {
                            asset.setIsInPosession(true);
                        } else {
                            asset.setIsInPosession(false);
                        }
                    }
                    catch (Exception e) {
                        this.log.config("No se pudo hacer comparaci\u00f3n con moneda UTM" + e.toString());
                    }
                }
                asset.saveEx();
                iLine.set_CustomColumn("A_Asset_ID", asset.getA_Asset_ID());
                this.log.config("activo " + asset.getA_Asset_ID());
                iLine.save();
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                assetuse.setDescription("ALTA DE ACTIVO");
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                assetuse.save();
                int depwork = 0;
                depwork = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT coalesce(max(a_depreciation_workfile_id),0) from a_Depreciation_workfile where a_Asset_id = " + asset.get_ID()));
                if (depwork == 0) {
                    this.log.config("WORK ES CERO");
                } else {
                    X_A_Depreciation_Workfile work = new X_A_Depreciation_Workfile(this.getCtx(), depwork, this.get_TrxName());
                    work.setA_Asset_Cost(iLine.getPriceEntered());
                    work.save();
                }
            }
            ++lineIndex;
        }
    }

    private boolean isAsset(MInvoiceLine sLine) {
        if (sLine.getC_Charge_ID() > 0 && sLine.getC_Charge().getC_ChargeType_ID() > 0 && sLine.getC_Charge().getC_ChargeType().getValue().equals("TCAF")) {
            return true;
        }
        return sLine.getM_Product_ID() > 0 && sLine.getM_Product().getM_Product_Category().getA_Asset_Group_ID() > 0;
    }

    public void degradeAsset(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (iLine.getA_Asset_ID() > 0 && iLine.isActive()) {
                int A_Asset = iLine.getA_Asset_ID();
                A_Asset = OFBForward.getBP(A_Asset);
                MAsset asset = new MAsset(this.getCtx(), A_Asset, this.get_TrxName());
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                if (inv.getC_DocTypeTarget_ID() == 2000161) {
                    assetuse.setDescription("BAJA DE ACTIVO POR COMODATO");
                } else {
                    assetuse.setDescription("BAJA DE ACTIVO");
                }
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                assetuse.save();
                if (inv.getC_DocTypeTarget_ID() == 1000005) {
                    asset.set_CustomColumn("AssetSituation", "COM");
                } else {
                    asset.set_CustomColumn("AssetSituation", "BAJ");
                }
                asset.set_CustomColumn("GrandTotal", Env.ONE);
                asset.saveEx();
            }
            ++lineIndex;
        }
    }

    public void transferAsset(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (iLine.getA_Asset_ID() > 0 && iLine.isActive()) {
                int A_Asset = iLine.getA_Asset_ID();
                A_Asset = OFBForward.getBP(A_Asset);
                MAsset asset = new MAsset(this.getCtx(), A_Asset, this.get_TrxName());
                if (iLine.get_ValueAsInt("AD_NewOrg_ID") > 0) {
                    asset.setAD_Org_ID(iLine.get_ValueAsInt("AD_NewOrg_ID"));
                }
                if (iLine.get_ValueAsInt("C_NewRegion_ID") > 0) {
                    asset.set_CustomColumn("C_Region_ID", iLine.get_ValueAsInt("C_NewRegion_ID"));
                }
                if (iLine.get_ValueAsInt("C_NewProvince_ID") > 0) {
                    asset.set_CustomColumn("C_Province_ID", iLine.get_ValueAsInt("C_NewProvince_ID"));
                }
                this.log.config("new resource" + iLine.get_ValueAsInt("S_NewResource_ID"));
                this.log.config("TRACE ");
                if (iLine.get_ValueAsInt("S_NewResource_ID") > 0) {
                    asset.set_CustomColumn("S_Resource_ID", iLine.get_ValueAsInt("S_NewResource_ID"));
                }
                if (iLine.get_ValueAsInt("S_NewResourceRef_ID") > 0) {
                    asset.set_CustomColumn("S_ResourceRef_ID", iLine.get_ValueAsInt("S_NewResourceRef_ID"));
                }
                if (inv.getC_DocTypeTarget_ID() == 1000009) {
                    asset.set_CustomColumn("AssetSituation", "COM");
                }
                asset.saveEx(this.get_TrxName());
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                assetuse.setDescription("TRASPASO DE ACTIVO");
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                assetuse.save();
            }
            ++lineIndex;
        }
    }

    public void updateAsset(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (iLine.getA_Asset_ID() > 0 && iLine.isActive()) {
                BigDecimal amtDiff;
                int A_Asset = iLine.getA_Asset_ID();
                A_Asset = OFBForward.getBP(A_Asset);
                MAsset asset = new MAsset(this.getCtx(), A_Asset, this.get_TrxName());
                asset.setName(iLine.getDescription());
                asset.setAD_Org_ID(iLine.getAD_Org_ID());
                if (dType.get_ID() == 1000623) {
                    amtDiff = (BigDecimal)iLine.get_Value("PriceEffective");
                    if (amtDiff == null) {
                        amtDiff = Env.ZERO;
                    }
                    if (amtDiff.compareTo(Env.ZERO) != 0) {
                        asset.set_CustomColumn("GrandTotal", iLine.getPriceEntered().add(amtDiff));
                        asset.saveEx();
                        DB.executeUpdate((String)("UPDATE a_Depreciation_workfile SET a_asset_cost = " + iLine.getPriceEntered().add(amtDiff)), (String)this.get_TrxName());
                    }
                } else if (dType.get_ID() == 1000624) {
                    amtDiff = (BigDecimal)iLine.get_Value("PriceEffective");
                    if (amtDiff == null) {
                        amtDiff = Env.ZERO;
                    }
                    if (amtDiff.compareTo(Env.ZERO) != 0) {
                        asset.set_CustomColumn("GrandTotal", iLine.getPriceEntered().subtract(amtDiff));
                        asset.saveEx();
                        DB.executeUpdate((String)("UPDATE a_Depreciation_workfile SET a_asset_cost = " + iLine.getPriceEntered().subtract(amtDiff)), (String)this.get_TrxName());
                    }
                } else {
                    if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                        asset.setAD_User_ID(iLine.get_ValueAsInt("AD_user_ID"));
                    }
                    asset.set_CustomColumn("Brand", iLine.get_ValueAsString("Brand"));
                    asset.set_CustomColumn("Model", iLine.get_ValueAsString("Model"));
                    asset.set_CustomColumn("SerNo", iLine.get_ValueAsString("SerNo"));
                    asset.set_CustomColumn("Color", iLine.get_ValueAsString("Color"));
                    if (iLine.get_ValueAsString("AssetStatus") != null && iLine.get_ValueAsString("AssetStatus").trim().length() > 0) {
                        asset.set_CustomColumn("AssetStatus", iLine.get_ValueAsString("AssetStatus"));
                    }
                    asset.set_CustomColumn("A_Parent_Asset_ID", iLine.get_ValueAsInt("A_Parent_Asset_ID"));
                    if (iLine.get_ValueAsString("Type1") != null && iLine.get_ValueAsString("Type1").trim().length() > 0) {
                        asset.set_CustomColumn("Type1", iLine.get_ValueAsString("Type1"));
                    }
                    asset.set_CustomColumn("Rol", iLine.get_ValueAsString("Rol"));
                    asset.set_CustomColumn("GroundSurface", (BigDecimal)iLine.get_Value("GroundSurface"));
                    asset.set_CustomColumn("EdificationSurface", (BigDecimal)iLine.get_Value("EdificationSurface"));
                    asset.set_CustomColumn("Engine", iLine.get_ValueAsString("Engine"));
                    asset.set_CustomColumn("Chassis", iLine.get_ValueAsString("Chassis"));
                    asset.set_CustomColumn("LicensePlate", iLine.get_ValueAsString("LicensePlate"));
                    asset.set_CustomColumn("Digito", iLine.get_ValueAsString("Digito"));
                    asset.set_CustomColumn("Sigla", iLine.get_ValueAsString("Sigla"));
                    asset.set_CustomColumn("Fojas", iLine.get_ValueAsString("Fojas"));
                    asset.set_CustomColumn("RegistrationNumber", iLine.get_ValueAsString("RegistrationNumber"));
                    asset.set_CustomColumn("Year", iLine.get_ValueAsString("Year"));
                    asset.set_CustomColumn("Inmueble", iLine.get_ValueAsString("Inmueble"));
                    if (iLine.get_ValueAsInt("C_Region_ID") > 0) {
                        asset.set_CustomColumn("C_Region_ID", iLine.get_ValueAsInt("C_Region_ID"));
                    }
                    if (iLine.get_ValueAsInt("C_Province_ID") > 0) {
                        asset.set_CustomColumn("C_Province_ID", iLine.get_ValueAsInt("C_Province_ID"));
                    }
                    if (iLine.get_ValueAsInt("C_City_ID") > 0) {
                        asset.set_CustomColumn("C_City_ID", iLine.get_ValueAsString("C_City_ID"));
                    }
                    if (iLine.get_ValueAsString("DocDestination") != null && iLine.get_ValueAsString("DocDestination").trim().length() > 0) {
                        asset.set_CustomColumn("DocDestination", iLine.get_ValueAsString("DocDestination"));
                    }
                    asset.set_CustomColumn("DocNumber", iLine.get_ValueAsString("DocNumber"));
                    asset.set_CustomColumn("Conservador", iLine.get_ValueAsString("Conservador"));
                    asset.set_CustomColumn("Notaria", iLine.get_ValueAsString("Notaria"));
                    asset.set_CustomColumn("N_Fecha_ValeVista", iLine.get_ValueAsString("N_Fecha_ValeVista"));
                    asset.set_CustomColumn("Vlr_ValeVista", (BigDecimal)iLine.get_Value("Vlr_ValeVista"));
                    asset.set_CustomColumn("Fecha_Subasta", (Timestamp)iLine.get_Value("Fecha_Subasta"));
                    asset.set_CustomColumn("Vlr_Subasta", (BigDecimal)iLine.get_Value("Vlr_Subasta"));
                    asset.set_CustomColumn("Lot", iLine.get_ValueAsString("Lot"));
                    asset.set_CustomColumn("Martillero", iLine.get_ValueAsString("Martillero"));
                    asset.set_CustomColumn("DocNumber2", iLine.get_ValueAsString("DocNumber2"));
                    asset.set_CustomColumn("ParentAsset", iLine.get_ValueAsString("ParentAsset"));
                    if (iLine.get_ValueAsInt("A_Asset_Group_Ref_ID") > 0) {
                        asset.set_CustomColumn("A_Asset_Group_Ref_ID", iLine.get_ValueAsInt("A_Asset_Group_Ref_ID"));
                    }
                    if (dType.get_ID() == 1000626) {
                        asset.set_CustomColumn("AssetSituation", "ALT");
                        int ID_ILine = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT C_InvoiceLine_ID FROM C_InvoiceLine cil  INNER JOIN C_Invoice ci ON (cil.C_Invoice_ID = ci.C_Invoice_ID) WHERE cil.C_InvoiceLine_ID <> " + iLine.get_ID() + " AND cil.A_Asset_ID = ? AND PriceEntered > 1 " + " ORDER BY DateInvoiced DESC, cil.created DESC"), (int)asset.get_ID());
                        if (ID_ILine > 0) {
                            MInvoiceLine iLineOld = new MInvoiceLine(this.getCtx(), ID_ILine, this.get_TrxName());
                            asset.set_CustomColumn("GrandTotal", iLineOld.getPriceEntered());
                        }
                    } else if (iLine.get_ValueAsString("AssetSituation") != null && iLine.get_ValueAsString("AssetSituation").trim().length() > 0) {
                        asset.set_CustomColumn("AssetSituation", iLine.get_ValueAsString("AssetSituation"));
                    }
                    asset.saveEx();
                }
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                assetuse.setDescription("MODIFICACI\u00d3N DE ACTIVO");
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                if (dType.get_ID() == 1000623 || dType.get_ID() == 1000624) {
                    assetuse.set_CustomColumn("Amt", (Object)iLine.getPriceEntered());
                    BigDecimal amtDiff2 = (BigDecimal)iLine.get_Value("PriceEffective");
                    if (dType.get_ID() == 1000623) {
                        assetuse.set_CustomColumn("AmountRef", (Object)iLine.getPriceEntered().add(amtDiff2));
                    } else {
                        assetuse.set_CustomColumn("AmountRef", (Object)iLine.getPriceEntered().subtract(amtDiff2));
                    }
                }
                assetuse.save();
            }
            ++lineIndex;
        }
    }

    public void degradeAssetInProcess(MInvoice inv, MDocType dType) {
        MInvoiceLine[] lines = inv.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInvoiceLine iLine = lines[lineIndex];
            if (iLine.getA_Asset_ID() > 0 && iLine.isActive()) {
                MAsset asset = new MAsset(this.getCtx(), iLine.getA_Asset_ID(), this.get_TrxName());
                X_A_Asset_Use assetuse = new X_A_Asset_Use(inv.getCtx(), 0, inv.get_TrxName());
                assetuse.setA_Asset_ID(asset.getA_Asset_ID());
                assetuse.setUseDate(inv.getDateInvoiced());
                assetuse.setUseUnits(1);
                if (iLine.get_ValueAsInt("AD_User_ID") > 0) {
                    assetuse.set_CustomColumn("AD_User_ID", (Object)iLine.get_ValueAsInt("AD_User_ID"));
                }
                if (iLine.get_ValueAsInt("S_Resource_ID") > 0) {
                    assetuse.set_CustomColumn("S_Resource_ID", (Object)iLine.get_ValueAsInt("S_Resource_ID"));
                }
                if (iLine.get_ValueAsInt("S_ResourceRef_ID") > 0) {
                    assetuse.set_CustomColumn("S_ResourceRef_ID", (Object)iLine.get_ValueAsInt("S_ResourceRef_ID"));
                }
                assetuse.setDescription("BAJA CON ENAJENACION EN PROCESO");
                assetuse.set_CustomColumn("C_DocType_ID", (Object)inv.getC_DocTypeTarget_ID());
                assetuse.set_CustomColumn("type1", (Object)dType.get_ValueAsString("type1"));
                assetuse.set_CustomColumn("C_InvoiceLine_ID", (Object)iLine.get_ID());
                assetuse.save();
            }
            ++lineIndex;
        }
    }
}

