/*
 * Decompiled with CFR 0.152.
 */
package org.indap.process;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.X_HR_AdministrativeRequests;
import org.compiere.model.X_HR_AdministrativeRequestsL;
import org.compiere.model.X_HR_AttendanceLine;
import org.compiere.model.X_HR_HourPlanningLine;
import org.compiere.model.X_HR_HoursUsedDetail;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;
import org.ofb.utils.DateUtils;

public class ProcessAdministrativeRequest
extends SvrProcess {
    private int p_AdmRequest_ID = 0;
    private String p_Action = "PR";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_AdmRequest_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_AdmRequest_ID > 0) {
            X_HR_AdministrativeRequests req = new X_HR_AdministrativeRequests(this.getCtx(), this.p_AdmRequest_ID, this.get_TrxName());
            String newStatus = "DR";
            String newAction = "DR";
            this.log.config("paction " + this.p_Action);
            if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "SS";
                newAction = "SS";
            } else if (req.getDocStatus().compareTo("SS") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AP";
                newAction = "AP";
            } else if (req.getDocStatus().compareTo("AP") == 0 && this.p_Action.compareTo("CO") == 0 && req.getRequestType().compareTo("CMT") != 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("AP") == 0 && this.p_Action.compareTo("CO") == 0 && req.getRequestType().compareTo("CMT") == 0) {
                newStatus = "AD";
                newAction = "AD";
            } else if (req.getDocStatus().compareTo("AD") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("RJ") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("SS") == 0 && this.p_Action.compareTo("RJ") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AP") == 0 && this.p_Action.compareTo("RJ") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AD") == 0 && this.p_Action.compareTo("RJ") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("CO") != 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "VO";
                newAction = "VO";
            }
            int cant = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_Document_Action_Access daa INNER JOIN AD_Ref_List rl ON (daa.AD_Ref_List_ID = rl.AD_Ref_List_ID)  WHERE value = '" + newAction + "' AND AD_Role_ID = " + Env.getAD_Role_ID((Properties)this.getCtx()) + " AND C_DocType_ID = " + req.get_ValueAsInt("C_DocType_ID")));
            this.log.config("cantidad" + cant);
            if (cant > 0) {
                int BPartner;
                if (newAction.compareTo("CO") != 0) {
                    EMail mail2;
                    String mailaenviar2;
                    String sqlmailaenviar2;
                    EMail mail;
                    String mailaenviar;
                    String mailaenviar1;
                    MClient client;
                    MBPartner bp;
                    StringBuilder str;
                    String ln;
                    int reql;
                    BPartner = req.getC_BPartner_ID();
                    int HR_Employee = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT max(HR_Employee_ID)  FROM HR_Employee WHERE C_BPartner_ID = " + BPartner + " and" + " IsActive='Y'"));
                    this.log.config("HR_Employee " + HR_Employee);
                    String namebpartner = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT max(name) from c_bpartner  WHERE c_bpartner_id = ?", (int)BPartner);
                    String requestType = "";
                    requestType = req.getRequestType().compareTo("SVC") == 0 ? "Solicitud Feriado Legal" : (req.getRequestType().compareTo("PAD") == 0 ? "Permiso Administrativo" : (req.getRequestType().compareTo("COM") == 0 ? "Horas Compensatorias" : req.getRequestType()));
                    if (this.p_Action.compareTo("VO") == 0) {
                        if (req.get_Value("Comments") == null) {
                            throw new AdempiereException("Debe ingresar un motivo de anulacion");
                        }
                        int VoidedBy = Env.getAD_User_ID((Properties)this.getCtx());
                        if (VoidedBy > 0) {
                            req.set_CustomColumn("VoidedBy", VoidedBy);
                        }
                    }
                    if (newAction.compareTo("SS") == 0) {
                        BigDecimal DaysReq;
                        String sqldaysreq;
                        BigDecimal DaysReq2;
                        String sqldaysreq2;
                        BigDecimal DaysLeft;
                        String sqldays;
                        int hasboss = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT count(1) from ad_user where  c_bpartner_id = " + BPartner + " and supervisor_id > 0"));
                        if (hasboss == 0) {
                            throw new AdempiereException("El funcionario no tiene jefatura definida");
                        }
                        if (req.getRequestType().compareTo("SVC") == 0) {
                            sqldays = "SELECT VacationDay from HR_Employee where HR_Employee_ID = ?";
                            DaysLeft = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays, (int)HR_Employee);
                            this.log.config("hr employee = " + HR_Employee);
                            this.log.config("days left" + DaysLeft);
                            this.log.config("partner = " + BPartner);
                            sqldaysreq2 = "SELECT Days from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                            DaysReq2 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq2, (int)req.get_ID());
                            if (DaysLeft.compareTo(DaysReq2) < 0) {
                                throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                            }
                        }
                        if (req.getRequestType().compareTo("COM") == 0) {
                            BigDecimal minutosdisponibles = Env.ONE;
                            BigDecimal minutosusados = Env.ONE;
                            String sqlavailable = "SELECT hr_hourplanningline_id from hr_hourplanningline  WHERE hoursused < (daytimereal1 + nighttimereal1)  and c_bpartner_id = " + BPartner + " and expirationdate > '" + req.getDateDoc() + "' order by expirationdate";
                            CPreparedStatement pstmt = DB.prepareStatement((String)sqlavailable, (String)this.get_TrxName());
                            ResultSet rs = pstmt.executeQuery();
                            this.log.config("sql available " + sqlavailable);
                            String sqlminutosreq = "SELECT SUM(hours)*60 from HR_AdministrativeRequestsL where IsActive = 'Y' AND HR_AdministrativeRequests_ID = ? ";
                            BigDecimal minutosreq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlminutosreq, (int)req.get_ID());
                            boolean flag = false;
                            while (rs.next() && minutosreq.compareTo(Env.ZERO) > 0) {
                                BigDecimal totalminutosnocturnos;
                                int hpLine = rs.getInt("hr_hourplanningline_id");
                                flag = true;
                                X_HR_HourPlanningLine planning = new X_HR_HourPlanningLine(this.getCtx(), hpLine, this.get_TrxName());
                                BigDecimal totalminutosdiurnos = new BigDecimal(planning.getDayTimeReal1());
                                BigDecimal totalminutos = totalminutosdiurnos.add(totalminutosnocturnos = planning.getNightTimeReal1());
                                minutosdisponibles = totalminutos.subtract(minutosusados = (BigDecimal)planning.get_Value("hoursused"));
                                if (minutosdisponibles.compareTo(Env.ZERO) <= 0) {
                                    return "REVISAR ERROR!";
                                }
                                if (minutosreq.compareTo(minutosdisponibles) <= 0) {
                                    minutosreq = Env.ZERO;
                                    break;
                                }
                                minutosreq = minutosreq.subtract(minutosdisponibles);
                            }
                            this.log.config("What");
                            if (!flag || minutosreq.compareTo(Env.ZERO) != 0) {
                                throw new AdempiereException("No hay horas disponibles");
                            }
                        }
                        if (req.getRequestType().compareTo("PAD") == 0) {
                            sqldays = "SELECT AdministrativeDay from HR_Employee where HR_Employee_ID = ?";
                            DaysLeft = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays, (int)HR_Employee);
                            this.log.config("hr employee = " + HR_Employee);
                            this.log.config("days left" + DaysLeft);
                            this.log.config("partner = " + BPartner);
                            sqldaysreq2 = "SELECT count(1) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? AND  AdmType like 'DIA'";
                            DaysReq2 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq2, (int)req.get_ID());
                            String sqlmiddaysreq = "SELECT count(1) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? AND  AdmType in ('MAN','TAR')";
                            BigDecimal MidDaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlmiddaysreq, (int)req.get_ID());
                            MidDaysReq = MidDaysReq.divide(new BigDecimal("2"));
                            BigDecimal suma = MidDaysReq.add(DaysReq2);
                            if (DaysLeft.compareTo(suma) < 0) {
                                throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                            }
                        }
                        if (req.getRequestType().compareTo("SVC") == 0) {
                            sqldays = "SELECT VacationDay from HR_Employee where HR_Employee_ID = ?";
                            DaysLeft = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays, (int)HR_Employee);
                            this.log.config("hr employee = " + HR_Employee);
                            this.log.config("days left" + DaysLeft);
                            this.log.config("partner = " + BPartner);
                            sqldaysreq2 = "SELECT Days from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                            DaysReq2 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq2, (int)req.get_ID());
                            if (DaysLeft.compareTo(DaysReq2) < 0) {
                                throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                            }
                        }
                        if (req.getRequestType().compareTo("SVT") == 0) {
                            String sqlyear = "Select extract (year from datedoc) from hr_administrativerequests where hr_administrativerequests_id = ?";
                            BigDecimal yeardoc = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlyear, (int)req.get_ID());
                            String sqlcount = "SELECT count(1) from hr_administrativerequests where requesttype = 'SVT' and datedoc  between '" + yeardoc + "-01-01' and '" + yeardoc + "-12-31' and c_bpartner_id = " + BPartner;
                            int contador = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcount);
                            if (contador > 1) {
                                throw new AdempiereException("Ya tiene una solicitud de traspaso para el a\u00f1o indicado");
                            }
                            String sqldays2 = "SELECT coalesce(VacationDay,0) from HR_Employee where HR_Employee_ID = ?";
                            BigDecimal DaysLeft2 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays2, (int)HR_Employee);
                            this.log.config("hr employee = " + HR_Employee);
                            this.log.config("days left" + DaysLeft2);
                            this.log.config("partner = " + BPartner);
                            String sqldaysreq3 = "SELECT coalesce(Days,0) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                            BigDecimal DaysReq3 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq3, (int)req.get_ID());
                            if (DaysLeft2.compareTo(DaysReq3) < 0) {
                                throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                            }
                        }
                        if (req.getRequestType().compareTo("PPM") == 0) {
                            this.log.config("hr employee = " + HR_Employee);
                            this.log.config("partner = " + BPartner);
                            sqldaysreq = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                            DaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                            this.log.config("days = " + DaysReq);
                            if (DaysReq.compareTo(new BigDecimal("5.0")) > 0) {
                                throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 5 dias.");
                            }
                        }
                        if (req.getRequestType().compareTo("PAT") == 0) {
                            this.log.config("hr employee = " + HR_Employee);
                            this.log.config("partner = " + BPartner);
                            sqldaysreq = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                            DaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                            this.log.config("days = " + DaysReq);
                            if (DaysReq.compareTo(new BigDecimal("5.0")) > 0) {
                                throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 5 dias.");
                            }
                        }
                        if (req.getRequestType().compareTo("SHT") == 0) {
                            this.log.config("hr employee = " + HR_Employee);
                            this.log.config("partner = " + BPartner);
                            sqldaysreq = "SELECT SUM(hours) from HR_AdministrativeRequestsL where IsActive = 'Y' AND HR_AdministrativeRequests_ID = ? ";
                            BigDecimal HoursReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                            this.log.config("Hours = " + HoursReq);
                            HoursReq.compareTo(Env.ZERO);
                        }
                        if (req.getRequestType().compareTo("FAL") == 0) {
                            this.log.config("hr employee = " + HR_Employee);
                            this.log.config("partner = " + BPartner);
                            sqldaysreq = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                            DaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                            this.log.config("days = " + DaysReq);
                            if (req.get_ValueAsString("RequestType2").compareTo("01") == 0 && DaysReq.compareTo(new BigDecimal("7.0")) > 0) {
                                throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 7 dias.");
                            }
                            if (req.get_ValueAsString("RequestType2").compareTo("02") == 0 && DaysReq.compareTo(new BigDecimal("3.0")) > 0) {
                                throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 3 dias.");
                            }
                        }
                        int reql2 = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT max(hr_administrativerequestsl_id) from hr_administrativerequestsl where  hr_administrativerequests_id = ?", (int)this.p_AdmRequest_ID);
                        this.log.config("valo = " + reql2);
                        if (reql2 <= 0) {
                            return "sin lineas";
                        }
                        X_HR_AdministrativeRequestsL reqline = new X_HR_AdministrativeRequestsL(this.getCtx(), reql2, this.get_TrxName());
                        String ln2 = System.getProperty("line.separator");
                        StringBuilder str2 = new StringBuilder();
                        str2.append("Estimad@");
                        str2.append(ln2);
                        str2.append(ln2);
                        str2.append("Se ha ingresado la siguiente solicitud en ADempiere:");
                        str2.append(ln2);
                        str2.append("Nro solicitud: " + req.getDocumentNo());
                        str2.append(ln2);
                        str2.append("Fecha solicitud: " + req.getDateDoc());
                        str2.append(ln2);
                        str2.append("Tipo de solicitud: " + requestType);
                        str2.append(ln2);
                        str2.append("Funcionario: " + namebpartner);
                        str2.append(ln2);
                        if (req.getRequestType().compareTo("SVC") == 0) {
                            str2.append("Fecha Inicio: " + reqline.getdatestartrequest());
                            str2.append(ln2);
                            str2.append("Fecha Termino: " + reqline.getdateendrequest());
                            str2.append(ln2);
                            str2.append("Dias Solicitados: " + reqline.getDays());
                            str2.append(ln2);
                        } else if (req.getRequestType().compareTo("PAD") == 0) {
                            str2.append("Fecha Inicio: " + reqline.getdatestartrequest());
                            str2.append(ln2);
                            if (reqline.getAdmType().compareTo("DIA") == 0) {
                                str2.append("Jornada: Dia Completo");
                            }
                            if (reqline.getAdmType().compareTo("MAN") == 0) {
                                str2.append("Jornada: Media Ma\u00f1ana");
                            }
                            if (reqline.getAdmType().compareTo("TAR") == 0) {
                                str2.append("Jornada: Media Tarde");
                            }
                            str2.append(ln2);
                        } else if (req.getRequestType().compareTo("COM") == 0) {
                            str2.append("Fecha Inicio: " + reqline.get_Value("Date01"));
                            str2.append(ln2);
                            str2.append("Fecha Termino: " + reqline.get_Value("date2"));
                            str2.append(ln2);
                            str2.append("Cantidad de horas: " + reqline.gethours());
                            str2.append(ln2);
                        }
                        str2.append(ln2);
                        str2.append("Saludos, ");
                        str2.append(ln2);
                        str2.append("ESTE CORREO ES AUTOM\u00c1TICO, NO LO RESPONDA");
                        MBPartner bp2 = new MBPartner(this.getCtx(), BPartner, this.get_TrxName());
                        MClient client2 = new MClient(bp2.getCtx(), bp2.getAD_Client_ID(), bp2.get_TrxName());
                        String sqlmailaenviar1 = "SELECT max(EMail) from ad_user where isactive='Y' and c_bpartner_id = ?";
                        String mailaenviar12 = DB.getSQLValueString((String)this.get_TrxName(), (String)sqlmailaenviar1, (int)bp2.get_ID());
                        EMail mail3 = new EMail(client2, client2.getRequestEMail(), mailaenviar12, "Aviso de ingreso solicitud", str2.toString());
                        mail3.createAuthenticator(client2.getRequestUser(), client2.getRequestUserPW());
                        if (req.getRequestType().compareTo("COM") == 0 || req.getRequestType().compareTo("SVC") == 0 || req.getRequestType().compareTo("PAD") == 0) {
                            mail3.send();
                        }
                        this.log.config("Correo Enviado a " + mailaenviar12);
                        this.log.config("Errores Correo: " + mail3.getSentMsg());
                        String sqlmailaenviar22 = "SELECT max(EMail) from ad_user where  isactive='Y' and ad_user_id in (select supervisor_id from ad_user where  c_bpartner_id = ? and supervisor_id > 0)";
                        String mailaenviar22 = DB.getSQLValueString((String)this.get_TrxName(), (String)sqlmailaenviar22, (int)bp2.get_ID());
                        EMail mail22 = new EMail(client2, client2.getRequestEMail(), mailaenviar22, "Aviso de ingreso solicitud", str2.toString());
                        mail22.createAuthenticator(client2.getRequestUser(), client2.getRequestUserPW());
                        if (req.getRequestType().compareTo("COM") == 0 || req.getRequestType().compareTo("SVC") == 0 || req.getRequestType().compareTo("PAD") == 0) {
                            mail22.send();
                        }
                    }
                    if (newAction.compareTo("AP") == 0) {
                        reql = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT max(hr_administrativerequestsl_id) from hr_administrativerequestsl where  hr_administrativerequests_id = ?", (int)this.p_AdmRequest_ID);
                        if (reql <= 0) {
                            return "sin lineas";
                        }
                        X_HR_AdministrativeRequestsL reqline = new X_HR_AdministrativeRequestsL(this.getCtx(), reql, this.get_TrxName());
                        ln = System.getProperty("line.separator");
                        str = new StringBuilder();
                        str.append("Estimad@");
                        str.append(ln);
                        str.append(ln);
                        str.append("Se ha aprobado la siguiente solicitud en ADempiere:");
                        str.append(ln);
                        str.append("Nro solicitud: " + req.getDocumentNo());
                        str.append(ln);
                        str.append("Fecha solicitud: " + req.getDateDoc());
                        str.append(ln);
                        str.append("Tipo de solicitud: " + requestType);
                        str.append(ln);
                        str.append("Funcionario: " + namebpartner);
                        str.append(ln);
                        if (req.getRequestType().compareTo("SVC") == 0) {
                            str.append("Fecha Inicio: " + reqline.getdatestartrequest());
                            str.append(ln);
                            str.append("Fecha Termino: " + reqline.getdateendrequest());
                            str.append(ln);
                            str.append("Dias Solicitados: " + reqline.getDays());
                            str.append(ln);
                        } else if (req.getRequestType().compareTo("PAD") == 0) {
                            str.append("Fecha Inicio: " + reqline.getdatestartrequest());
                            str.append(ln);
                            if (reqline.getAdmType().compareTo("DIA") == 0) {
                                str.append("Jornada: Dia Completo");
                            }
                            if (reqline.getAdmType().compareTo("MAN") == 0) {
                                str.append("Jornada: Media Ma\u00f1ana");
                            }
                            if (reqline.getAdmType().compareTo("TAR") == 0) {
                                str.append("Jornada: Media Tarde");
                            }
                            str.append(ln);
                        } else if (req.getRequestType().compareTo("COM") == 0) {
                            str.append("Fecha Inicio: " + reqline.get_Value("Date01"));
                            str.append(ln);
                            str.append("Fecha Termino: " + reqline.get_Value("date2"));
                            str.append(ln);
                            str.append("Cantidad de horas: " + reqline.gethours());
                            str.append(ln);
                        }
                        str.append(ln);
                        str.append("Saludos, ");
                        str.append(ln);
                        str.append("ESTE CORREO ES AUTOM\u00c1TICO, NO LO RESPONDA");
                        bp = new MBPartner(this.getCtx(), BPartner, this.get_TrxName());
                        client = new MClient(bp.getCtx(), bp.getAD_Client_ID(), bp.get_TrxName());
                        mailaenviar1 = "SELECT max(EMail) from ad_user where isactive='Y' and c_bpartner_id = ?";
                        mailaenviar = DB.getSQLValueString((String)this.get_TrxName(), (String)mailaenviar1, (int)bp.get_ID());
                        mail = new EMail(client, client.getRequestEMail(), mailaenviar, "Aviso de aprobacion solicitud", str.toString());
                        mail.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
                        if (req.getRequestType().compareTo("COM") == 0 || req.getRequestType().compareTo("SVC") == 0 || req.getRequestType().compareTo("PAD") == 0) {
                            mail.send();
                        }
                        this.log.config("Correo Enviado a " + mailaenviar);
                        this.log.config("Errores Correo: " + mail.getSentMsg());
                        sqlmailaenviar2 = "SELECT max(EMail) from ad_user where  isactive='Y' and ad_user_id in (select supervisor_id from ad_user where  c_bpartner_id = ? and supervisor_id > 0)";
                        mailaenviar2 = DB.getSQLValueString((String)this.get_TrxName(), (String)sqlmailaenviar2, (int)bp.get_ID());
                        mail2 = new EMail(client, client.getRequestEMail(), mailaenviar2, "Aviso de aprobacion solicitud", str.toString());
                        mail2.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
                        if (req.getRequestType().compareTo("COM") == 0 || req.getRequestType().compareTo("SVC") == 0 || req.getRequestType().compareTo("PAD") == 0) {
                            mail2.send();
                        }
                    }
                    if (newAction.compareTo("DR") == 0) {
                        reql = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT max(hr_administrativerequestsl_id) from hr_administrativerequestsl where  hr_administrativerequests_id = ?", (int)this.p_AdmRequest_ID);
                        if (reql <= 0) {
                            return "sin lineas";
                        }
                        X_HR_AdministrativeRequestsL reqline = new X_HR_AdministrativeRequestsL(this.getCtx(), reql, this.get_TrxName());
                        ln = System.getProperty("line.separator");
                        str = new StringBuilder();
                        str.append("Estimad@");
                        str.append(ln);
                        str.append(ln);
                        str.append("Se ha rechazado la siguiente solicitud en ADempiere:");
                        str.append(ln);
                        str.append("Nro solicitud: " + req.getDocumentNo());
                        str.append(ln);
                        str.append("Fecha solicitud: " + req.getDateDoc());
                        str.append(ln);
                        str.append("Tipo de solicitud: " + requestType);
                        str.append(ln);
                        str.append("Funcionario: " + namebpartner);
                        str.append(ln);
                        if (req.getRequestType().compareTo("SVC") == 0) {
                            str.append("Fecha Inicio: " + reqline.getdatestartrequest());
                            str.append(ln);
                            str.append("Fecha Termino: " + reqline.getdateendrequest());
                            str.append(ln);
                            str.append("Dias Solicitados: " + reqline.getDays());
                            str.append(ln);
                        } else if (req.getRequestType().compareTo("PAD") == 0) {
                            str.append("Fecha Inicio: " + reqline.getdatestartrequest());
                            str.append(ln);
                            if (reqline.getAdmType().compareTo("DIA") == 0) {
                                str.append("Jornada: Dia Completo");
                            }
                            if (reqline.getAdmType().compareTo("MAN") == 0) {
                                str.append("Jornada: Media Ma\u00f1ana");
                            }
                            if (reqline.getAdmType().compareTo("TAR") == 0) {
                                str.append("Jornada: Media Tarde");
                            }
                            str.append(ln);
                        } else if (req.getRequestType().compareTo("COM") == 0) {
                            str.append("Fecha Inicio: " + reqline.get_Value("Date01"));
                            str.append(ln);
                            str.append("Fecha Termino: " + reqline.get_Value("date2"));
                            str.append(ln);
                            str.append("Cantidad de horas: " + reqline.gethours());
                            str.append(ln);
                        }
                        str.append(ln);
                        str.append("Saludos, ");
                        str.append(ln);
                        str.append("ESTE CORREO ES AUTOM\u00c1TICO, NO LO RESPONDA");
                        bp = new MBPartner(this.getCtx(), BPartner, this.get_TrxName());
                        client = new MClient(bp.getCtx(), bp.getAD_Client_ID(), bp.get_TrxName());
                        mailaenviar1 = "SELECT max(EMail) from ad_user where isactive='Y' and c_bpartner_id = ?";
                        mailaenviar = DB.getSQLValueString((String)this.get_TrxName(), (String)mailaenviar1, (int)bp.get_ID());
                        mail = new EMail(client, client.getRequestEMail(), mailaenviar, "Aviso de rechazo solicitud", str.toString());
                        mail.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
                        if (req.getRequestType().compareTo("COM") == 0 || req.getRequestType().compareTo("SVC") == 0 || req.getRequestType().compareTo("PAD") == 0) {
                            mail.send();
                        }
                        this.log.config("Correo Enviado a " + mailaenviar);
                        this.log.config("Errores Correo: " + mail.getSentMsg());
                        sqlmailaenviar2 = "SELECT max(EMail) from ad_user where  isactive='Y' and ad_user_id in (select supervisor_id from ad_user where  c_bpartner_id = ? and supervisor_id > 0)";
                        mailaenviar2 = DB.getSQLValueString((String)this.get_TrxName(), (String)sqlmailaenviar2, (int)bp.get_ID());
                        mail2 = new EMail(client, client.getRequestEMail(), mailaenviar2, "Aviso de aprobacion solicitud", str.toString());
                        mail2.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
                        if (req.getRequestType().compareTo("COM") == 0 || req.getRequestType().compareTo("SVC") == 0 || req.getRequestType().compareTo("PAD") == 0) {
                            mail2.send();
                        }
                    }
                    req.setDocStatus(newStatus);
                    if (newAction.compareTo("VO") == 0) {
                        req.setProcessed(true);
                    }
                    req.save();
                } else if (newAction.compareTo("CO") == 0) {
                    BigDecimal DaysReq;
                    String sqldaysreq;
                    BigDecimal DaysLeft;
                    String sqldays;
                    BPartner = req.getC_BPartner_ID();
                    BPartner = OFBForward.getBP(BPartner);
                    int HR_Employee = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT max(HR_Employee_ID)  FROM HR_Employee WHERE C_BPartner_ID = " + BPartner + " and" + " IsActive='Y'"));
                    this.log.config("HR_Employee " + HR_Employee);
                    if (req.getRequestType().compareTo("PAD") == 0) {
                        sqldays = "SELECT AdministrativeDay from HR_Employee where HR_Employee_ID = ?";
                        DaysLeft = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays, (int)HR_Employee);
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("days left" + DaysLeft);
                        this.log.config("partner = " + BPartner);
                        sqldaysreq = "SELECT count(1) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? AND  AdmType like 'DIA'";
                        DaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                        String sqlmiddaysreq = "SELECT count(1) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? AND  AdmType in ('MAN','TAR')";
                        BigDecimal MidDaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlmiddaysreq, (int)req.get_ID());
                        MidDaysReq = MidDaysReq.divide(new BigDecimal("2"));
                        BigDecimal suma = MidDaysReq.add(DaysReq);
                        if (DaysLeft.compareTo(suma) >= 0) {
                            DB.executeUpdate((String)("Update HR_Employee set AdministrativeDay = AdministrativeDay - " + suma + " WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        } else {
                            throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                        }
                    }
                    if (req.getRequestType().compareTo("SVC") == 0) {
                        sqldays = "SELECT VacationDay from HR_Employee where HR_Employee_ID = ?";
                        DaysLeft = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays, (int)HR_Employee);
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("days left" + DaysLeft);
                        this.log.config("partner = " + BPartner);
                        sqldaysreq = "SELECT Days from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        DaysReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq, (int)req.get_ID());
                        if (DaysLeft.compareTo(DaysReq) >= 0) {
                            DB.executeUpdate((String)("Update HR_Employee set VacationDay = VacationDay - " + DaysReq + " WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        } else {
                            throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                        }
                    }
                    if (req.getRequestType().compareTo("SVT") == 0) {
                        String sqlyear = "Select extract (year from datedoc) from hr_administrativerequests where hr_administrativerequests_id = ?";
                        BigDecimal yeardoc = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlyear, (int)req.get_ID());
                        String sqlcount = "SELECT count(1) from hr_administrativerequests where requesttype = 'SVT' and datedoc  between '" + yeardoc + "-01-01' and '" + yeardoc + "-12-31' and c_bpartner_id = " + BPartner;
                        int contador = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcount);
                        if (contador > 1) {
                            throw new AdempiereException("Ya tiene una solicitud de traspaso para el a\u00f1o indicado");
                        }
                        String sqldays3 = "SELECT coalesce(VacationDay,0) from HR_Employee where HR_Employee_ID = ?";
                        BigDecimal DaysLeft3 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldays3, (int)HR_Employee);
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("days left" + DaysLeft3);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq4 = "SELECT coalesce(Days,0) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq4 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq4, (int)req.get_ID());
                        if (DaysLeft3.compareTo(DaysReq4) >= 0) {
                            DB.executeUpdate((String)("Update HR_Employee set VacationDay = " + DaysReq4 + " + VacationDayInitial WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        } else {
                            throw new AdempiereException("Debe revisar la cantidad de d\u00edas solicitados.");
                        }
                    }
                    if (req.getRequestType().compareTo("COM") == 0) {
                        BigDecimal minutosdisponibles = Env.ONE;
                        BigDecimal minutosusados = Env.ONE;
                        String sqlavailable = "SELECT hr_hourplanningline_id from hr_hourplanningline  WHERE hoursused < (daytimereal1 + nighttimereal1)  and c_bpartner_id = " + BPartner + " and expirationdate > '" + req.getDateDoc() + "' order by expirationdate";
                        CPreparedStatement pstmt = DB.prepareStatement((String)sqlavailable, (String)this.get_TrxName());
                        ResultSet rs = pstmt.executeQuery();
                        this.log.config("sql available " + sqlavailable);
                        String sqlminutosreq = "SELECT SUM(hours)*60 from HR_AdministrativeRequestsL where IsActive = 'Y' AND HR_AdministrativeRequests_ID = ? ";
                        BigDecimal minutosreq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlminutosreq, (int)req.get_ID());
                        boolean flag = false;
                        while (rs.next() && minutosreq.compareTo(Env.ZERO) > 0) {
                            X_HR_HoursUsedDetail us;
                            BigDecimal totalminutosnocturnos;
                            int hpLine = rs.getInt("hr_hourplanningline_id");
                            flag = true;
                            X_HR_HourPlanningLine planning = new X_HR_HourPlanningLine(this.getCtx(), hpLine, this.get_TrxName());
                            BigDecimal totalminutosdiurnos = new BigDecimal(planning.getDayTimeReal1());
                            BigDecimal totalminutos = totalminutosdiurnos.add(totalminutosnocturnos = planning.getNightTimeReal1());
                            minutosdisponibles = totalminutos.subtract(minutosusados = (BigDecimal)planning.get_Value("hoursused"));
                            if (minutosdisponibles.compareTo(Env.ZERO) <= 0) {
                                return "REVISAR ERROR!";
                            }
                            if (minutosreq.compareTo(minutosdisponibles) <= 0) {
                                planning.set_CustomColumn("hoursused", ((BigDecimal)planning.get_Value("hoursused")).add(minutosreq));
                                planning.save();
                                us = new X_HR_HoursUsedDetail(this.getCtx(), 0, this.get_TrxName());
                                us.setAD_Org_ID(req.getAD_Org_ID());
                                us.setHR_AdministrativeRequests_ID(req.get_ID());
                                us.sethours(minutosreq.intValue());
                                us.setHR_HourPlanningLine_ID(planning.get_ID());
                                us.save();
                                minutosreq = Env.ZERO;
                                break;
                            }
                            planning.set_CustomColumn("hoursused", totalminutos);
                            planning.save();
                            us = new X_HR_HoursUsedDetail(this.getCtx(), 0, this.get_TrxName());
                            us.setAD_Org_ID(req.getAD_Org_ID());
                            us.setHR_AdministrativeRequests_ID(req.get_ID());
                            us.sethours(minutosreq.subtract(minutosdisponibles).intValue());
                            us.setHR_HourPlanningLine_ID(planning.get_ID());
                            us.save();
                            minutosreq = minutosreq.subtract(minutosdisponibles);
                        }
                        this.log.config("What");
                        if (!flag || minutosreq.compareTo(Env.ZERO) != 0) {
                            throw new AdempiereException("No hay horas disponibles");
                        }
                    }
                    if (req.getRequestType().compareTo("CAP") == 0) {
                        int yearReq = DateUtils.today().getYear() + 1900;
                        int yearAD = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(C_Year_ID) FROM C_Year WHERE FiscalYear = '" + yearReq + "'"));
                        int ID_Cab = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(HR_Attendance_ID) FROM HR_Attendance WHERE C_Year_ID = " + yearAD));
                        if (ID_Cab > 0) {
                            String sql = "SELECT * FROM HR_AdministrativeRequestsL WHERE HR_AdministrativeRequests_ID = " + req.get_ID();
                            CPreparedStatement pstmt = null;
                            ResultSet rs = null;
                            try {
                                try {
                                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                                    rs = pstmt.executeQuery();
                                    while (rs.next()) {
                                        X_HR_AttendanceLine line = new X_HR_AttendanceLine(this.getCtx(), 0, this.get_TrxName());
                                        line.setC_BPartner_ID(req.getC_BPartner_ID());
                                        line.setHR_Attendance_ID(ID_Cab);
                                        line.setDateTrx(rs.getTimestamp("DateRequired"));
                                        line.setRequestType(rs.getString("AttType"));
                                        line.save();
                                    }
                                    rs.close();
                                    pstmt.close();
                                    pstmt = null;
                                }
                                catch (SQLException e) {
                                    throw new DBException((Exception)e, sql);
                                }
                            }
                            catch (Throwable flag) {
                                DB.close(rs, pstmt);
                                rs = null;
                                pstmt = null;
                                throw flag;
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                        }
                    }
                    if (req.getRequestType().compareTo("PPM") == 0) {
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq5 = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq5 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq5, (int)req.get_ID());
                        this.log.config("days = " + DaysReq5);
                        if (DaysReq5.compareTo(new BigDecimal("5.0")) > 0) {
                            throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 5 dias.");
                        }
                    }
                    if (req.getRequestType().compareTo("PAT") == 0) {
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq6 = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq6 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq6, (int)req.get_ID());
                        this.log.config("days = " + DaysReq6);
                        if (DaysReq6.compareTo(new BigDecimal("5.0")) > 0) {
                            throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 5 dias.");
                        }
                    }
                    if (req.getRequestType().compareTo("SHT") == 0) {
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq7 = "SELECT SUM(hours) from HR_AdministrativeRequestsL where IsActive = 'Y' AND HR_AdministrativeRequests_ID = ? ";
                        BigDecimal HoursReq = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq7, (int)req.get_ID());
                        this.log.config("Hours = " + HoursReq);
                        if (HoursReq.compareTo(Env.ZERO) > 0) {
                            DB.executeUpdate((String)("Update HR_Employee set HoursEarned  = HoursEarned + " + HoursReq + " WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                            DB.executeUpdate((String)("Update HR_Employee set HoursAvailable = HoursEarned - HoursUsed WHERE HR_Employee_ID = " + HR_Employee), (String)this.get_TrxName());
                        }
                    }
                    if (req.getRequestType().compareTo("FAL") == 0) {
                        this.log.config("hr employee = " + HR_Employee);
                        this.log.config("partner = " + BPartner);
                        String sqldaysreq8 = "SELECT SUM(Days) from HR_AdministrativeRequestsL where HR_AdministrativeRequests_ID = ? ";
                        BigDecimal DaysReq7 = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqldaysreq8, (int)req.get_ID());
                        this.log.config("days = " + DaysReq7);
                        if (req.get_ValueAsString("RequestType2").compareTo("01") == 0 && DaysReq7.compareTo(new BigDecimal("7.0")) > 0) {
                            throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 7 dias.");
                        }
                        if (req.get_ValueAsString("RequestType2").compareTo("02") == 0 && DaysReq7.compareTo(new BigDecimal("3.0")) > 0) {
                            throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 3 dias.");
                        }
                    }
                    req.setDocStatus("CO");
                    req.setProcessed(true);
                    req.save();
                    String namebpartner = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT max(name) from c_bpartner  WHERE c_bpartner_id = ?", (int)BPartner);
                    String requestType = "";
                    requestType = req.getRequestType().compareTo("SVC") == 0 ? "Solicitud Feriado Legal" : (req.getRequestType().compareTo("PAD") == 0 ? "Permiso Administrativo" : (req.getRequestType().compareTo("COM") == 0 ? "Horas Compensatorias" : req.getRequestType()));
                    int reql = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT max(hr_administrativerequestsl_id) from hr_administrativerequestsl where  hr_administrativerequests_id = ?", (int)this.p_AdmRequest_ID);
                    this.log.config("valo = " + reql);
                    if (reql <= 0) {
                        return "sin lineas";
                    }
                    X_HR_AdministrativeRequestsL reqline = new X_HR_AdministrativeRequestsL(this.getCtx(), reql, this.get_TrxName());
                    String ln = System.getProperty("line.separator");
                    StringBuilder str = new StringBuilder();
                    str.append("Estimad@");
                    str.append(ln);
                    str.append(ln);
                    str.append("Se ha completado la siguiente solicitud en ADempiere:");
                    str.append(ln);
                    str.append("Nro solicitud: " + req.getDocumentNo());
                    str.append(ln);
                    str.append("Fecha solicitud: " + req.getDateDoc());
                    str.append(ln);
                    str.append("Tipo de solicitud: " + requestType);
                    str.append(ln);
                    str.append("Funcionario: " + namebpartner);
                    str.append(ln);
                    if (req.getRequestType().compareTo("SVC") == 0) {
                        str.append("Fecha Inicio: " + reqline.getdatestartrequest());
                        str.append(ln);
                        str.append("Fecha Termino: " + reqline.getdateendrequest());
                        str.append(ln);
                        str.append("Dias Solicitados: " + reqline.getDays());
                        str.append(ln);
                    } else if (req.getRequestType().compareTo("PAD") == 0) {
                        str.append("Fecha Inicio: " + reqline.getdatestartrequest());
                        str.append(ln);
                        if (reqline.getAdmType().compareTo("DIA") == 0) {
                            str.append("Jornada: Dia Completo");
                        }
                        if (reqline.getAdmType().compareTo("MAN") == 0) {
                            str.append("Jornada: Media Ma\u00f1ana");
                        }
                        if (reqline.getAdmType().compareTo("TAR") == 0) {
                            str.append("Jornada: Media Tarde");
                        }
                        str.append(ln);
                    } else if (req.getRequestType().compareTo("COM") == 0) {
                        str.append("Fecha Inicio: " + reqline.get_Value("Date01"));
                        str.append(ln);
                        str.append("Fecha Termino: " + reqline.get_Value("date2"));
                        str.append(ln);
                        str.append("Cantidad de horas: " + reqline.gethours());
                        str.append(ln);
                    }
                    str.append(ln);
                    str.append("Saludos, ");
                    str.append(ln);
                    str.append("ESTE CORREO ES AUTOM\u00c1TICO, NO LO RESPONDA");
                    MBPartner bp = new MBPartner(this.getCtx(), BPartner, this.get_TrxName());
                    MClient client = new MClient(bp.getCtx(), bp.getAD_Client_ID(), bp.get_TrxName());
                    String mailaenviar1 = "SELECT max(EMail) from ad_user where isactive='Y' and c_bpartner_id = ?";
                    String mailaenviar = DB.getSQLValueString((String)this.get_TrxName(), (String)mailaenviar1, (int)bp.get_ID());
                    EMail mail = new EMail(client, client.getRequestEMail(), mailaenviar, "Aviso de completitud solicitud", str.toString());
                    mail.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
                    this.log.config("Correo Enviado a " + mailaenviar);
                    this.log.config("Errores Correo: " + mail.getSentMsg());
                    String sqlmailaenviar2 = "SELECT max(EMail) from ad_user where  isactive='Y' and ad_user_id in (select supervisor_id from ad_user where  c_bpartner_id = ? and supervisor_id > 0)";
                    String mailaenviar2 = DB.getSQLValueString((String)this.get_TrxName(), (String)sqlmailaenviar2, (int)bp.get_ID());
                    EMail mail2 = new EMail(client, client.getRequestEMail(), mailaenviar2, "Aviso de completitud solicitud", str.toString());
                    mail2.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
                }
                if (newStatus.compareTo("SS") == 0) {
                    this.log.config("Correo Enviado solicitud administrativa: " + req.get_ID());
                    CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                    cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    cst.setInt(2, 36);
                    cst.setString(3, "-");
                    cst.setInt(4, req.get_ID());
                } else if (newStatus.compareTo("AP") == 0) {
                    this.log.config("Correo Enviado solicitud administrativa: " + req.get_ID());
                    CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                    cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    cst.setInt(2, 37);
                    cst.setString(3, "-");
                    cst.setInt(4, req.get_ID());
                } else if (newStatus.compareTo("CO") == 0) {
                    this.log.config("Correo Enviado solicitud administrativa: " + req.get_ID());
                    CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                    cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    cst.setInt(2, 38);
                    cst.setString(3, "-");
                    cst.setInt(4, req.get_ID());
                } else if (newStatus.compareTo("DR") == 0) {
                    this.log.config("Correo Enviado solicitud administrativa: " + req.get_ID());
                    CallableStatement cst = DB.prepareCall((String)"{call pa_envia_mail_auto2(?,?,?,?)}");
                    cst.setInt(1, Env.getAD_Client_ID((Properties)this.getCtx()));
                    cst.setInt(2, 39);
                    cst.setString(3, "-");
                    cst.setInt(4, req.get_ID());
                }
            } else {
                throw new AdempiereException("Error: Permisos de rol insuficientes");
            }
        }
        return "Procesado";
    }
}

