/*
 * Decompiled with CFR 0.152.
 */
package org.indap.process;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.X_HR_AdministrativeRequests;
import org.compiere.model.X_HR_AdministrativeRequestsL;
import org.compiere.model.X_I_AdministrativeRequests;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.ofb.utils.DateUtils;

public class ImportCometidos
extends SvrProcess {
    private String p_PathFile;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("archivo")) {
                    this.p_PathFile = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String rutaArchivo;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        String pattern = "#,##0.0#";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        String pFile = rutaArchivo = this.p_PathFile;
        ArrayList<String[]> datos = new ArrayList<String[]>();
        int cantLines = 0;
        try {
            DB.executeUpdate((String)"DELETE FROM I_AdministrativeRequests ", (String)this.get_TrxName());
            FileInputStream fis = new FileInputStream(pFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datos.add(linea.split(";"));
                linea = br.readLine();
                if (((String[])datos.get(0))[0] != null && ((String[])datos.get(0))[1] != null && ((String[])datos.get(0))[4] != null && ((String[])datos.get(0))[5] != null) {
                    X_I_AdministrativeRequests iReq = new X_I_AdministrativeRequests(this.getCtx(), 0, this.get_TrxName());
                    iReq.setBPValue(((String[])datos.get(0))[1]);
                    iReq.setOrgValue(((String[])datos.get(0))[0]);
                    if (DateUtils.isDateddMMyyyy(((String[])datos.get(0))[4])) {
                        iReq.setStartDate(DateUtils.convertDateddMMyyyy(((String[])datos.get(0))[4]));
                    }
                    if (DateUtils.isDateddMMyyyy(((String[])datos.get(0))[5])) {
                        iReq.setEndDate(DateUtils.convertDateddMMyyyy(((String[])datos.get(0))[5]));
                    }
                    iReq.setProcessed(false);
                    iReq.saveEx(this.get_TrxName());
                }
                ++cantLines;
                datos.clear();
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config("Se han le\u00eddo " + cantLines + " lineas de archivo");
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        DB.executeUpdate((String)"UPDATE I_AdministrativeRequests i SET C_BPartner_ID = (SELECT bp.C_BPartner_ID FROM C_BPartner bp WHERE bp.Value = i.BPValue)  WHERE C_BPartner_ID IS NULL AND Processed <> 'Y'", (String)this.get_TrxName());
        DB.executeUpdate((String)"UPDATE I_AdministrativeRequests i SET AD_OrgRef_ID = (SELECT o.AD_Org_ID FROM AD_Org o WHERE o.Name = i.OrgValue)  WHERE AD_OrgRef_ID IS NULL AND Processed <> 'Y'", (String)this.get_TrxName());
        this.commitEx();
        String sql = "SELECT * FROM I_AdministrativeRequests WHERE Processed <> 'Y'  AND C_BPartner_ID > 0 AND AD_OrgRef_ID > 0";
        int cant = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getTimestamp("StartDate") == null || rs.getTimestamp("EndDate") == null) continue;
                X_HR_AdministrativeRequests req = new X_HR_AdministrativeRequests(this.getCtx(), 0, this.get_TrxName());
                req.setAD_Org_ID(rs.getInt("AD_OrgRef_ID"));
                req.setC_BPartner_ID(rs.getInt("C_Bpartner_ID"));
                req.setDateDoc(rs.getTimestamp("StartDate"));
                req.setRequestType("CMT");
                req.saveEx(this.get_TrxName());
                ++cant;
                Timestamp fechaEmision = rs.getTimestamp("StartDate");
                Timestamp fechaVencimiento = rs.getTimestamp("EndDate");
                Calendar calCalendario = Calendar.getInstance();
                if (fechaEmision != null && fechaVencimiento != null) {
                    while (fechaEmision.compareTo(fechaVencimiento) <= 0) {
                        X_HR_AdministrativeRequestsL line = new X_HR_AdministrativeRequestsL(this.getCtx(), 0, this.get_TrxName());
                        line.setHR_AdministrativeRequests_ID(req.get_ID());
                        line.setAD_Org_ID(req.getAD_Org_ID());
                        line.setAdmType("DIA");
                        line.setdatestartrequest(fechaEmision);
                        line.set_CustomColumn("date2", fechaEmision);
                        line.sethours(new BigDecimal("8.0"));
                        line.saveEx(this.get_TrxName());
                        calCalendario.setTimeInMillis(fechaEmision.getTime());
                        calCalendario.add(5, 1);
                        fechaEmision = new Timestamp(calCalendario.getTimeInMillis());
                    }
                }
                req.setDocStatus("CO");
                req.saveEx(this.get_TrxName());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "BP - " + sql.toString(), (Throwable)e);
        }
        return "Se gan generado " + cant + " cometidos";
    }
}

