/*
 * Decompiled with CFR 0.152.
 */
package org.geminis.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.I_GL_Journal;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Asset_Dep;
import org.compiere.model.X_A_Asset_Forecast;
import org.compiere.model.X_A_Asset_Forecast_New;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DepreAssetsGeminisV2
extends SvrProcess {
    private Properties m_ctx;
    private int Record_ID;
    X_A_Asset_Dep DepDoc = null;

    protected void prepare() {
        this.m_ctx = Env.getCtx();
        this.Record_ID = this.getRecord_ID();
        this.DepDoc = new X_A_Asset_Dep(this.m_ctx, this.Record_ID, this.get_TrxName());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        Calendar cal;
        String sql = "select a.a_asset_id,a.name,a.value,acct.c_acctschema_id, acct.a_asset_acct2,  acct.a_depreciation_acct2, fore.amount,fore.a_asset_forecast_new_id,p.c_period_id,p.name, acct.a_accumdepreciation_acct2,wk.a_asset_cost2, wk.a_accumulated_depr2, acct.A_AssetComplement_Acct from a_asset a inner join a_asset_acct acct on (a.a_asset_id=acct.a_asset_id) inner join A_Depreciation_Workfile wk on (a.a_asset_id=wk.a_asset_id) inner join a_asset_forecast_new fore on (a.a_asset_id=fore.a_asset_id) inner join c_period p on (fore.datedoc between p.startdate and p.enddate) where a.ad_client_id=? and p.c_period_id=? and acct.IsActive='Y' ";
        if (this.DepDoc.isSameYear()) {
            cal = Calendar.getInstance();
            cal.set(6, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else {
            cal = Calendar.getInstance();
            cal.set(6, 1);
            cal.set(1, cal.get(1) - 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("GDP")) {
            sql = String.valueOf(sql) + " And fore.processed='N' and a.isinposession='Y' And a.a_asset_group_id=" + this.DepDoc.getA_Asset_Group_ID();
        }
        sql = String.valueOf(sql) + " and a.IsInPosession = 'Y' and a.IsActive = 'Y' ";
        sql = String.valueOf(sql) + " and a.AD_Org_ID=" + this.DepDoc.getAD_Org_ID();
        this.log.config("sql " + sql);
        CPreparedStatement pstmt = null;
        MJournalBatch batch = null;
        MJournal journal = null;
        MClient client = MClient.get((Properties)this.m_ctx, (int)Env.getAD_Client_ID((Properties)this.m_ctx));
        int count = 0;
        if (this.DepDoc.getDocStatus().equals("DR")) {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.DepDoc.getAD_Client_ID());
                pstmt.setInt(2, this.DepDoc.getC_Period_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (batch == null) {
                        batch = new MJournalBatch(this.m_ctx, 0, this.get_TrxName());
                        batch.setAD_Org_ID(this.DepDoc.getAD_Org_ID());
                        batch.setDescription("Assets Deprecation Process NEW");
                        batch.setPostingType("A");
                        batch.setC_DocType_ID(MDocType.getOfDocBaseType((Properties)this.m_ctx, (String)"GLJ")[0].getC_DocType_ID());
                        batch.setGL_Category_ID(MGLCategory.getDefault((Properties)this.m_ctx, (String)"M").getGL_Category_ID());
                        batch.setDateAcct(this.DepDoc.getDateDoc());
                        batch.setDateDoc(this.DepDoc.getDateDoc());
                        batch.setC_Period_ID(MPeriod.getC_Period_ID((Properties)this.m_ctx, (Timestamp)this.DepDoc.getDateAcct()));
                        batch.setC_Currency_ID(client.getC_Currency_ID());
                        if (!batch.save()) {
                            return "la transaccion no puede ser generara para *";
                        }
                    }
                    ++count;
                    journal = new MJournal(batch);
                    journal.setDescription(String.valueOf(rs.getString("value")) + "-" + rs.getString("name"));
                    journal.setC_AcctSchema_ID(MAcctSchema.getClientAcctSchema((Properties)this.m_ctx, (int)Env.getAD_Client_ID((Properties)this.m_ctx))[0].getC_AcctSchema_ID());
                    journal.setGL_Category_ID(MGLCategory.getDefault((Properties)this.m_ctx, (String)"D").getGL_Category_ID());
                    journal.setC_ConversionType_ID(114);
                    journal.set_ValueOfColumn("A_Asset_ID", rs.getInt("a_asset_id"));
                    journal.set_ValueOfColumn("A_Asset_Forecast_ID", rs.getInt("a_asset_forecast_new_id"));
                    journal.save();
                    if (!this.DepDoc.getDepType().equalsIgnoreCase("GDP")) continue;
                    MJournalLine line1 = new MJournalLine(journal);
                    line1.setA_Asset_ID(rs.getInt("a_asset_id"));
                    line1.setAmtSourceDr(rs.getBigDecimal("amount"));
                    line1.setAmtSourceCr(Env.ZERO);
                    line1.setAmtAcct(rs.getBigDecimal("amount"), Env.ZERO);
                    line1.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct2"));
                    line1.save();
                    MJournalLine line2 = new MJournalLine(journal);
                    line2.setA_Asset_ID(rs.getInt("a_asset_id"));
                    line2.setAmtSourceDr(Env.ZERO);
                    line2.setAmtSourceCr(rs.getBigDecimal("amount"));
                    line2.setAmtAcct(Env.ZERO, rs.getBigDecimal("amount"));
                    line2.setC_ValidCombination_ID(rs.getInt("A_AssetComplement_Acct"));
                    line2.save();
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            }
            if (count > 0) {
                this.DepDoc.setGL_JournalBatch_ID(batch.getGL_JournalBatch_ID());
                this.DepDoc.setDocStatus("IP");
                this.DepDoc.save();
                DB.executeUpdate((String)("Update GL_JournalLine set A_Asset_Dep_ID=" + this.DepDoc.getA_Asset_Dep_ID() + " Where GL_Journal_ID IN (select GL_Journal_ID from GL_Journal where GL_JournalBatch_ID=" + batch.getGL_JournalBatch_ID() + " )"), (String)this.get_TrxName());
            } else if (batch != null) {
                batch.delete(true, this.get_TrxName());
            }
        } else if (this.DepDoc.getDocStatus().equals("IP") && !this.DepDoc.isVoid()) {
            this.log.info("IP");
            batch = new MJournalBatch(this.m_ctx, this.DepDoc.getGL_JournalBatch_ID(), this.get_TrxName());
            batch.processIt("CO");
            batch.save();
            batch.setProcessed(true);
            batch.save();
            MJournal[] journals = batch.getJournals(true);
            int i = 0;
            while (i < journals.length) {
                MJournal jour = journals[i];
                X_A_Asset asset = new X_A_Asset(this.getCtx(), jour.get_ValueAsInt("A_Asset_ID"), null);
                if (this.DepDoc.getDepType().equalsIgnoreCase("GDP")) {
                    MDepreciationWorkfile workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    BigDecimal accumulateddepr2 = (BigDecimal)workfile.get_Value("A_Accumulated_Depr2");
                    workfile.set_CustomColumn("A_Accumulated_Depr2", (Object)accumulateddepr2.add(jour.getTotalCr()));
                    workfile.set_CustomColumn("AssetDepreciationDate2", (Object)this.DepDoc.getDateDoc());
                    workfile.save();
                    X_A_Asset_Forecast_New fore = new X_A_Asset_Forecast_New(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore.setProcessed(true);
                    fore.setGL_Journal_ID(jour.getGL_Journal_ID());
                    fore.save();
                }
                ++i;
            }
            this.DepDoc.setDocStatus("CO");
            this.DepDoc.setProcessed(true);
            this.DepDoc.save();
        } else if (this.DepDoc.getDocStatus().equals("CO") && this.DepDoc.isVoid()) {
            batch = new MJournalBatch(this.m_ctx, this.DepDoc.getGL_JournalBatch_ID(), this.get_TrxName());
            MJournal[] journals = batch.getJournals(true);
            int i = 0;
            while (i < journals.length) {
                MDepreciationWorkfile workfile;
                MJournal jour = journals[i];
                if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(jour.getTotalCr()));
                    workfile.setA_Period_Posted(workfile.getA_Period_Posted() - 1);
                    workfile.setAssetDepreciationDate(this.DepDoc.getDateDoc());
                    workfile.save();
                    X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), this.get_TrxName());
                    fore.setProcessed(false);
                    fore.setGL_Journal_ID(0);
                    fore.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    MAssetAcct group = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                    BigDecimal acum = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.get_ValueAsInt("a_assetcomplement_acct")), (Object[])new Object[0]);
                    if (acum == null) {
                        acum = Env.ZERO;
                    }
                    this.log.config("Grupo " + group.getA_Asset_ID());
                    this.log.config("cuenta del grupo" + group.get_ValueAsInt("a_assetcomplememt_acct"));
                    this.log.config("variable acum " + acum);
                    acum = acum.subtract(DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.get_ValueAsInt("a_assetcomplement_acct")), (Object[])new Object[0]));
                    this.log.config("variable acum 2 " + acum);
                    BigDecimal neto = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Asset_Acct()), (Object[])new Object[0]);
                    if (neto == null) {
                        neto = Env.ZERO;
                    }
                    neto = neto.subtract(DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Asset_Acct()), (Object[])new Object[0]));
                    if (acum == null) {
                        acum = Env.ZERO;
                    }
                    if (neto == null) {
                        neto = Env.ZERO;
                    }
                    if (workfile != null) {
                        workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(acum));
                        workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(neto));
                        workfile.save();
                    }
                    if (jour.get_ValueAsInt("A_Asset_Forecast_ID") > 0) {
                        X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                        fore.setCorrected(false);
                        fore.save();
                    }
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("REV")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Calc_Accumulated_Depr());
                    workfile.save();
                    DB.executeUpdate((String)("Update A_Asset_Forecast set processed='N', corrected='N' where gl_journal_id is null and A_Asset_ID=" + jour.get_ValueAsInt("A_Asset_ID")), (String)this.get_TrxName());
                }
                ++i;
            }
            MJournal[] mJournalArray = journals;
            int n = journals.length;
            int n2 = 0;
            while (n2 < n) {
                MJournal j = mJournalArray[n2];
                DB.executeUpdate((String)("delete from fact_acct where record_id=" + j.getGL_Journal_ID() + " and ad_table_id=" + I_GL_Journal.Table_ID), (String)this.get_TrxName());
                DB.executeUpdate((String)("delete from gl_journalline where gl_journal_id=" + j.getGL_Journal_ID()), (String)this.get_TrxName());
                ++n2;
            }
            DB.executeUpdate((String)("delete from gl_journal where gl_journalbatch_id=" + batch.getGL_JournalBatch_ID()), (String)this.get_TrxName());
            DB.executeUpdate((String)("delete from gl_journalbatch where gl_journalbatch_id=" + batch.getGL_JournalBatch_ID()), (String)this.get_TrxName());
            this.DepDoc.setDocStatus("VO");
            this.DepDoc.setProcessed(true);
            this.DepDoc.save();
        }
        this.commitEx();
        return "";
    }
}

